/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;

public class Utils {
    public static String toSnakeCase(String s) {
        return s.replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase();
    }

    public static <T> T[] listToArray(List<T> list, Class<T> clazz) {
        Object[] array = (Object[])Array.newInstance(clazz, list.size());
        return list.toArray(array);
    }

    public static String getDotDelimitedLastSection(String s) {
        String[] splitArr = s.split("\\.");
        return splitArr[splitArr.length - 1];
    }

    public static String firstLetterToLower(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String fqnCamelCase(String s) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_' && i + 1 < s.length()) continue;
            if (Utils.isASCIIDigit(c) || c == '.') {
                result.append(c);
                continue;
            }
            if (Utils.isASCIILower(c)) {
                c = Character.toUpperCase(c);
            }
            result.append(c);
            while (i + 1 < s.length() && Utils.isASCIILower(s.charAt(i + 1))) {
                result.append(s.charAt(i + 1));
                ++i;
            }
        }
        return result.toString();
    }

    private static boolean isASCIIDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isASCIILower(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static Field getFieldFromFqn(Class<?> clazz, String fqn) throws Exception {
        String featureName = Utils.getDotDelimitedLastSection(fqn);
        String fieldName = Utils.firstLetterToLower(Utils.fqnCamelCase(featureName));
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        throw new IllegalArgumentException("Field " + fieldName + " does not exist in class " + clazz.getName());
    }

    public static Class<?> getListFeatureInnerType(Field field) throws Exception {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            Type[] typeArgs;
            ParameterizedType paramType = (ParameterizedType)genericType;
            for (Type arg : typeArgs = paramType.getActualTypeArguments()) {
                Type[] innerTypeArgs;
                if (!(arg instanceof ParameterizedType)) continue;
                ParameterizedType innerParamType = (ParameterizedType)arg;
                for (Type innerArg : innerTypeArgs = innerParamType.getActualTypeArguments()) {
                    if (!(innerArg instanceof Class)) continue;
                    return (Class)innerArg;
                }
            }
        }
        throw new Exception("Could not get inner type of field " + field.getName() + " in class " + field.getDeclaringClass().getName());
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String formatBucketDuration(int duration) {
        String[] units = new String[]{"s", "m", "h", "d", "w"};
        int[] divisors = new int[]{60, 60, 24, 7};
        for (int i = 0; i < divisors.length; ++i) {
            if (duration % divisors[i] != 0) {
                return String.format("%d%s", duration, units[i]);
            }
            duration /= divisors[i];
        }
        return String.format("%d%s", duration, units[units.length - 1]);
    }

    public static String convertBucketDurationToSeconds(String duration) {
        if (duration.equals("all")) {
            return duration;
        }
        String[] units = new String[]{"s", "m", "h", "d", "w"};
        int[] multipliers = new int[]{1, 60, 3600, 86400, 604800};
        for (int i = 0; i < units.length; ++i) {
            if (!duration.endsWith(units[i])) continue;
            int secondsInt = Integer.parseInt(duration.substring(0, duration.length() - units[i].length())) * multipliers[i];
            return String.format("%d", secondsInt);
        }
        throw new IllegalArgumentException("Invalid bucket duration: " + duration);
    }

    public static Object[] convertToArrayOfObjects(Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Provided object is not an array");
        }
        int length = Array.getLength(array);
        Object[] outputArray = new Object[length];
        for (int i = 0; i < length; ++i) {
            outputArray[i] = Array.get(array, i);
        }
        return outputArray;
    }

    public static String toChalkDuration(Duration duration) {
        String res;
        if (ChronoUnit.FOREVER.getDuration().equals(duration)) {
            return "all";
        }
        long seconds = duration.getSeconds();
        long nanoseconds = duration.getNano();
        long weeks = seconds / 604800L;
        long days = (seconds %= 604800L) / 86400L;
        long hours = (seconds %= 86400L) / 3600L;
        long minutes = (seconds %= 3600L) / 60L;
        seconds %= 60L;
        long milliseconds = nanoseconds / 1000000L;
        long microseconds = (nanoseconds %= 1000000L) / 1000L;
        nanoseconds %= 1000L;
        StringBuilder builder = new StringBuilder();
        if (weeks > 0L) {
            builder.append(weeks).append("w ");
        }
        if (days > 0L) {
            builder.append(days).append("d ");
        }
        if (hours > 0L) {
            builder.append(hours).append("h ");
        }
        if (minutes > 0L) {
            builder.append(minutes).append("m ");
        }
        if (seconds > 0L) {
            builder.append(seconds).append("s ");
        }
        if (milliseconds > 0L) {
            builder.append(milliseconds).append("ms ");
        }
        if (microseconds > 0L) {
            builder.append(microseconds).append("us ");
        }
        if (nanoseconds > 0L) {
            builder.append(nanoseconds).append("ns ");
        }
        if ((res = builder.toString().trim()).isEmpty()) {
            return "0s";
        }
        return res;
    }
}

