/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.internal.arrow;

import ai.chalk.exceptions.ClientException;
import ai.chalk.features.Feature;
import ai.chalk.features.FeaturesClass;
import ai.chalk.features.HasMany;
import ai.chalk.features.StructFeaturesClass;
import ai.chalk.internal.Constants;
import ai.chalk.internal.Utils;
import ai.chalk.internal.codegen.Initializer;
import ai.chalk.models.OnlineQueryResult;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.holders.NullableBigIntHolder;
import org.apache.arrow.vector.holders.NullableBitHolder;
import org.apache.arrow.vector.holders.NullableDateDayHolder;
import org.apache.arrow.vector.holders.NullableDateMilliHolder;
import org.apache.arrow.vector.holders.NullableFloat4Holder;
import org.apache.arrow.vector.holders.NullableFloat8Holder;
import org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.vector.holders.NullableSmallIntHolder;
import org.apache.arrow.vector.holders.NullableTimeMicroHolder;
import org.apache.arrow.vector.holders.NullableTimeMilliHolder;
import org.apache.arrow.vector.holders.NullableTimeNanoHolder;
import org.apache.arrow.vector.holders.NullableTimeSecHolder;
import org.apache.arrow.vector.holders.NullableTimeStampMicroHolder;
import org.apache.arrow.vector.holders.NullableTimeStampMicroTZHolder;
import org.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import org.apache.arrow.vector.holders.NullableTimeStampMilliTZHolder;
import org.apache.arrow.vector.holders.NullableTimeStampNanoHolder;
import org.apache.arrow.vector.holders.NullableTimeStampNanoTZHolder;
import org.apache.arrow.vector.holders.NullableTimeStampSecHolder;
import org.apache.arrow.vector.holders.NullableTimeStampSecTZHolder;
import org.apache.arrow.vector.holders.NullableTinyIntHolder;
import org.apache.arrow.vector.table.Row;
import org.apache.arrow.vector.table.Table;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.util.Text;

public class Unmarshaller {
    public static <T extends FeaturesClass> T[] unmarshalOnlineQueryResult(OnlineQueryResult result, Class<T> target) throws ClientException {
        try {
            FeaturesClass[] rootFeatureClasses = Unmarshaller.unmarshalTable((Table)result.getScalarsTable(), target);
            Unmarshaller.unmarshalHasMany(result.getGroupsTables(), rootFeatureClasses);
            return rootFeatureClasses;
        }
        catch (Exception e) {
            throw new ClientException("Failed to unmarshal online query result into Java classes", e);
        }
    }

    public static void unmarshalHasMany(Map<String, Table> tables, FeaturesClass[] targets) throws Exception {
        if (targets.length == 0) {
            return;
        }
        for (Map.Entry<String, Table> entry : tables.entrySet()) {
            Class<?> localClass = targets[0].getClass();
            String fqn = entry.getKey();
            Table table = entry.getValue();
            java.lang.reflect.Field hasManyField = Utils.getFieldFromFqn(targets[0].getClass(), fqn);
            Class<?> hasManyClass = Utils.getListFeatureInnerType(hasManyField);
            if (!hasManyField.isAnnotationPresent(HasMany.class)) {
                throw new Exception("Field " + fqn + " is not annotated as a has-many field");
            }
            HasMany hm = hasManyField.getAnnotation(HasMany.class);
            String localFqn = Utils.toSnakeCase(localClass.getSimpleName()) + "." + hm.localKey();
            String foreignFqn = Utils.toSnakeCase(hasManyClass.getSimpleName()) + "." + hm.foreignKey();
            FeaturesClass[] objects = Unmarshaller.unmarshalTable((Table)table, hasManyClass.asSubclass(FeaturesClass.class));
            HashMap grouped = new HashMap();
            for (FeaturesClass obj : objects) {
                java.lang.reflect.Field foreignField = Utils.getFieldFromFqn(hasManyClass, foreignFqn);
                Feature foreignKeyFeature = (Feature)foreignField.get(obj);
                if (foreignKeyFeature == null) {
                    throw new Exception("Error while grouping has-many result: foreign join key is null");
                }
                String v = foreignKeyFeature.getValue().toString();
                if (!grouped.containsKey(v)) {
                    grouped.put(v, new ArrayList());
                }
                ((List)grouped.get(v)).add(obj);
            }
            for (FeaturesClass target : targets) {
                java.lang.reflect.Field localField = Utils.getFieldFromFqn(localClass, localFqn);
                Feature localKeyFeature = (Feature)localField.get(target);
                if (localKeyFeature == null) {
                    throw new Exception("Error while grouping has-many result: local join key is null");
                }
                java.lang.reflect.Field hmField = Utils.getFieldFromFqn(target.getClass(), fqn);
                Feature hmFieldFeature = (Feature)hmField.get(target);
                String v = localKeyFeature.getValue().toString();
                if (grouped.containsKey(v)) {
                    List group = (List)grouped.get(v);
                    hmFieldFeature.setValue(group);
                    continue;
                }
                hmFieldFeature.setValue(new ArrayList());
            }
        }
    }

    public static <T extends FeaturesClass> T[] unmarshalTable(Table table, Class<T> target) throws Exception {
        ArrayList<FeaturesClass> result = new ArrayList<FeaturesClass>();
        for (Row row : table) {
            Map<String, Feature<?>> featureMap;
            FeaturesClass obj = (FeaturesClass)target.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            try {
                featureMap = Initializer.initResult(obj);
            }
            catch (Exception e) {
                throw new Exception("Failed to initialize result object", e);
            }
            result.add(obj);
            for (Field arrowField : table.getSchema().getFields()) {
                String fqn = arrowField.getName();
                String[] fqnsToSkip = new String[]{Constants.tsFeatureFqn};
                if (Arrays.asList(fqnsToSkip).contains(fqn)) continue;
                Feature<?> feature = featureMap.get(fqn);
                if (feature == null) {
                    if (arrowField.getType().getTypeID() == ArrowType.ArrowTypeID.Struct) {
                        Object structObj = row.getStruct(fqn);
                        if (structObj == null) {
                            if (arrowField.isNullable()) continue;
                            throw new Exception(String.format("Non-nullable field '%s' is null", fqn));
                        }
                        Unmarshaller.unmarshalNested((HashMap)structObj, featureMap, fqn);
                        continue;
                    }
                    throw new Exception(String.format("Target field not found for unmarshalling feature with FQN: '%s'", fqn));
                }
                block2 : switch (arrowField.getType().getTypeID()) {
                    case Int: {
                        NullableIntHolder holder;
                        ArrowType.Int castInt = (ArrowType.Int)arrowField.getFieldType().getType();
                        int bitWidth = castInt.getBitWidth();
                        if (bitWidth == 32) {
                            holder = new NullableIntHolder();
                            row.getInt(fqn, holder);
                            if (holder.isSet != 1) break;
                            feature.setValue(holder.value);
                            break;
                        }
                        if (bitWidth == 64) {
                            NullableBigIntHolder nullableBigIntHolder = new NullableBigIntHolder();
                            row.getBigInt(fqn, nullableBigIntHolder);
                            if (nullableBigIntHolder.isSet != 1) break;
                            feature.setValue(nullableBigIntHolder.value);
                            break;
                        }
                        if (bitWidth == 16) {
                            holder = new NullableSmallIntHolder();
                            row.getSmallInt(fqn, (NullableSmallIntHolder)holder);
                            if (holder.isSet != 1) break;
                            feature.setValue(holder.value);
                            break;
                        }
                        if (bitWidth == 8) {
                            holder = new NullableTinyIntHolder();
                            row.getTinyInt(fqn, (NullableTinyIntHolder)holder);
                            if (holder.isSet != 1) break;
                            feature.setValue(holder.value);
                            break;
                        }
                        throw new Exception("Unsupported bitwidth found while converting from Arrow to Java: " + bitWidth);
                    }
                    case FloatingPoint: {
                        NullableIntHolder holder;
                        ArrowType.FloatingPoint castFloatingPoint = (ArrowType.FloatingPoint)arrowField.getFieldType().getType();
                        FloatingPointPrecision precision = castFloatingPoint.getPrecision();
                        if (precision == FloatingPointPrecision.SINGLE) {
                            holder = new NullableFloat4Holder();
                            row.getFloat4(fqn, (NullableFloat4Holder)holder);
                            if (holder.isSet != 1) break;
                            feature.setValue(Float.valueOf(holder.value));
                            break;
                        }
                        if (precision == FloatingPointPrecision.DOUBLE) {
                            holder = new NullableFloat8Holder();
                            row.getFloat8(fqn, (NullableFloat8Holder)holder);
                            if (holder.isSet != 1) break;
                            feature.setValue(holder.value);
                            break;
                        }
                        throw new Exception("Unsupported precision found while converting from Arrow to Java: " + precision);
                    }
                    case Bool: {
                        NullableBitHolder holder = new NullableBitHolder();
                        row.getBit(fqn, holder);
                        if (holder.isSet != 1) break;
                        feature.setValue(holder.value == 1);
                        break;
                    }
                    case Utf8: {
                        byte[] bytes = row.getVarChar(fqn);
                        if (bytes == null) break;
                        String strVal = new String(bytes);
                        feature.setValue(strVal);
                        break;
                    }
                    case LargeUtf8: {
                        byte[] bytes = row.getLargeVarChar(fqn);
                        if (bytes == null) break;
                        String strVal = new String(bytes);
                        feature.setValue(strVal);
                        break;
                    }
                    case Date: {
                        NullableDateDayHolder holder;
                        ArrowType.Date castDate = (ArrowType.Date)arrowField.getFieldType().getType();
                        if (castDate.getUnit() == DateUnit.DAY) {
                            holder = new NullableDateDayHolder();
                            row.getDateDay(fqn, holder);
                            if (holder.isSet != 1) break;
                            feature.setValue(LocalDate.ofEpochDay(holder.value));
                            break;
                        }
                        if (castDate.getUnit() == DateUnit.MILLISECOND) {
                            holder = new NullableDateMilliHolder();
                            row.getDateMilli(fqn, (NullableDateMilliHolder)holder);
                            if (holder.isSet != 1) break;
                            LocalDate localDate = Instant.ofEpochSecond(holder.value).atZone(ZoneOffset.UTC).toLocalDate();
                            feature.setValue(localDate);
                            break;
                        }
                        throw new Exception("Unsupported date unit found while converting from Arrow to Java: " + castDate.getUnit());
                    }
                    case Timestamp: {
                        ArrowType.Timestamp cast = (ArrowType.Timestamp)arrowField.getFieldType().getType();
                        String timezone = cast.getTimezone();
                        ZoneId zoneId = null;
                        if (timezone != null) {
                            zoneId = ZoneId.of(timezone);
                        }
                        boolean hasTimezone = zoneId != null;
                        switch (cast.getUnit()) {
                            case SECOND: {
                                NullableTimeStampSecTZHolder holder;
                                if (hasTimezone) {
                                    holder = new NullableTimeStampSecTZHolder();
                                    row.getTimeStampSecTZ(fqn, holder);
                                    if (holder.isSet != 1) break block2;
                                    feature.setValue(Instant.ofEpochSecond(holder.value).atZone(zoneId));
                                    break block2;
                                }
                                holder = new NullableTimeStampSecHolder();
                                row.getTimeStampSec(fqn, (NullableTimeStampSecHolder)holder);
                                if (holder.isSet != 1) break block2;
                                feature.setValue(Instant.ofEpochSecond(holder.value).atZone(ZoneOffset.UTC).toLocalDateTime());
                                break block2;
                            }
                            case MILLISECOND: {
                                NullableTimeStampSecTZHolder holder;
                                if (hasTimezone) {
                                    holder = new NullableTimeStampMilliTZHolder();
                                    row.getTimeStampMilliTZ(fqn, (NullableTimeStampMilliTZHolder)holder);
                                    if (holder.isSet != 1) break block2;
                                    feature.setValue(Instant.ofEpochMilli(holder.value).atZone(zoneId));
                                    break block2;
                                }
                                holder = new NullableTimeStampMilliHolder();
                                row.getTimeStampMilli(fqn, (NullableTimeStampMilliHolder)holder);
                                if (holder.isSet != 1) break block2;
                                feature.setValue(Instant.ofEpochMilli(holder.value).atZone(ZoneOffset.UTC).toLocalDateTime());
                                break block2;
                            }
                            case MICROSECOND: {
                                long epochNanoRemainder;
                                long epochSecondsTruncated;
                                NullableTimeStampSecTZHolder holder;
                                if (hasTimezone) {
                                    holder = new NullableTimeStampMicroTZHolder();
                                    row.getTimeStampMicroTZ(fqn, (NullableTimeStampMicroTZHolder)holder);
                                    if (holder.isSet != 1) break block2;
                                    epochSecondsTruncated = holder.value / 1000000L;
                                    epochNanoRemainder = holder.value % 1000000L * 1000L;
                                    feature.setValue(Instant.ofEpochSecond(epochSecondsTruncated, epochNanoRemainder).atZone(zoneId));
                                    break block2;
                                }
                                holder = new NullableTimeStampMicroHolder();
                                row.getTimeStampMicro(fqn, (NullableTimeStampMicroHolder)holder);
                                if (holder.isSet != 1) break block2;
                                epochSecondsTruncated = holder.value / 1000000L;
                                epochNanoRemainder = holder.value % 1000000L * 1000L;
                                feature.setValue(Instant.ofEpochSecond(epochSecondsTruncated, epochNanoRemainder).atZone(ZoneOffset.UTC).toLocalDateTime());
                                break block2;
                            }
                            case NANOSECOND: {
                                long epochNanoRemainder;
                                long epochSecondsTruncated;
                                NullableTimeStampSecTZHolder holder;
                                if (hasTimezone) {
                                    holder = new NullableTimeStampNanoTZHolder();
                                    row.getTimeStampNanoTZ(fqn, (NullableTimeStampNanoTZHolder)holder);
                                    if (holder.isSet != 1) break block2;
                                    epochSecondsTruncated = holder.value / 1000000000L;
                                    epochNanoRemainder = holder.value % 1000000000L;
                                    feature.setValue(Instant.ofEpochSecond(epochSecondsTruncated, epochNanoRemainder).atZone(zoneId));
                                    break block2;
                                }
                                holder = new NullableTimeStampNanoHolder();
                                row.getTimeStampNano(fqn, (NullableTimeStampNanoHolder)holder);
                                if (holder.isSet != 1) break block2;
                                epochSecondsTruncated = holder.value / 1000000000L;
                                epochNanoRemainder = holder.value % 1000000000L;
                                feature.setValue(Instant.ofEpochSecond(epochSecondsTruncated, epochNanoRemainder).atZone(ZoneOffset.UTC).toLocalDateTime());
                                break block2;
                            }
                            default: {
                                throw new Exception("Unsupported timestamp unit found while converting from Arrow to Java: " + cast.getUnit());
                            }
                        }
                    }
                    case List: 
                    case LargeList: {
                        List originalList;
                        if (arrowField.getType().getTypeID() == ArrowType.ArrowTypeID.LargeList) {
                            LargeListVector largeListVector = (LargeListVector)table.getVectorCopy(fqn);
                            originalList = largeListVector.getObject(row.getRowNumber());
                        } else {
                            originalList = row.getList(fqn);
                        }
                        if (originalList == null) break;
                        ArrayList<Object> resultList = new ArrayList<Object>();
                        for (Object rawObj : originalList) {
                            if (rawObj instanceof Text) {
                                resultList.add(rawObj.toString());
                                continue;
                            }
                            if (rawObj instanceof Map) {
                                Class<?> dataclass;
                                try {
                                    java.lang.reflect.Field field = Utils.getFieldFromFqn(target, fqn);
                                    dataclass = Utils.getListFeatureInnerType(field);
                                }
                                catch (Exception e) {
                                    throw new Exception("Could not get the inner type of list feature: " + fqn, e);
                                }
                                StructFeaturesClass dataclassInstance = (StructFeaturesClass)dataclass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                Map<String, Feature<?>> dataclassFeatureMap = Initializer.initResult(dataclassInstance);
                                for (Map.Entry entry : ((Map)rawObj).entrySet()) {
                                    String dataclassRootFqn = Utils.toSnakeCase(dataclass.getSimpleName());
                                    String childFqn = dataclassRootFqn + "." + (String)entry.getKey();
                                    Object value = entry.getValue();
                                    if (value instanceof Map) {
                                        Unmarshaller.unmarshalNested((Map)value, dataclassFeatureMap, childFqn);
                                        continue;
                                    }
                                    Feature<?> childFeature = dataclassFeatureMap.get(childFqn);
                                    childFeature.setValue(value);
                                }
                                resultList.add(dataclassInstance);
                                continue;
                            }
                            resultList.add(rawObj);
                        }
                        feature.setValue(resultList);
                        break;
                    }
                    case Duration: {
                        Duration duration = row.getDurationObj(fqn);
                        if (duration == null) break;
                        feature.setValue(Duration.ofSeconds(duration.getSeconds(), duration.getNano()));
                        break;
                    }
                    case Time: {
                        ArrowType.Timestamp cast = (ArrowType.Time)arrowField.getFieldType().getType();
                        switch (cast.getUnit()) {
                            case SECOND: {
                                NullableTimeSecHolder holder = new NullableTimeSecHolder();
                                row.getTimeSec(fqn, holder);
                                if (holder.isSet != 1) break block2;
                                feature.setValue(LocalTime.ofSecondOfDay(holder.value));
                                break block2;
                            }
                            case MILLISECOND: {
                                NullableTimeSecHolder holder = new NullableTimeMilliHolder();
                                row.getTimeMilli(fqn, (NullableTimeMilliHolder)holder);
                                if (holder.isSet != 1) break block2;
                                feature.setValue(LocalTime.ofNanoOfDay((long)holder.value * 1000000L));
                                break block2;
                            }
                            case MICROSECOND: {
                                NullableTimeSecHolder holder = new NullableTimeMicroHolder();
                                row.getTimeMicro(fqn, (NullableTimeMicroHolder)holder);
                                if (holder.isSet != 1) break block2;
                                feature.setValue(LocalTime.ofNanoOfDay(holder.value * 1000L));
                                break block2;
                            }
                            case NANOSECOND: {
                                NullableTimeSecHolder holder = new NullableTimeNanoHolder();
                                row.getTimeNano(fqn, (NullableTimeNanoHolder)holder);
                                if (holder.isSet != 1) break block2;
                                feature.setValue(LocalTime.ofNanoOfDay(holder.value));
                                break block2;
                            }
                            default: {
                                throw new Exception("Unsupported time unit found while converting from Arrow to Java: " + cast.getUnit());
                            }
                        }
                    }
                    default: {
                        throw new Exception("Unsupported type found while unmarshalling Arrow Table: " + arrowField.getType().getTypeID());
                    }
                }
                if (feature.getValue() != null || arrowField.isNullable()) continue;
                throw new Exception(String.format("Non-nullable field '%s' is null", fqn));
            }
        }
        return (FeaturesClass[])Utils.listToArray(result, target);
    }

    private static void unmarshalNested(Map<String, Object> struct, Map<String, Feature<?>> featureMap, String fqn) {
        for (Map.Entry<String, Object> entry : struct.entrySet()) {
            String childFqn = fqn + "." + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Unmarshaller.unmarshalNested((Map)value, featureMap, childFqn);
                continue;
            }
            Feature<?> childFeature = featureMap.get(childFqn);
            childFeature.setValue(value);
        }
    }
}

