/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.models;

import ai.chalk.exceptions.ClientException;
import ai.chalk.exceptions.ServerError;
import ai.chalk.features.FeaturesClass;
import ai.chalk.internal.arrow.Unmarshaller;
import ai.chalk.models.QueryMeta;
import java.util.Arrays;
import java.util.Map;
import org.apache.arrow.vector.table.Table;

public class OnlineQueryResult
implements AutoCloseable {
    private final Table scalarsTable;
    private final Map<String, Table> groupsTables;
    private final ServerError[] errors;
    private final QueryMeta meta;

    @Override
    public void close() {
        if (this.scalarsTable != null) {
            this.scalarsTable.close();
        }
        if (this.groupsTables != null) {
            for (Table table : this.groupsTables.values()) {
                table.close();
            }
        }
    }

    public <T extends FeaturesClass> T[] unmarshal(Class<T> clazz) throws ClientException {
        return Unmarshaller.unmarshalOnlineQueryResult((OnlineQueryResult)this, clazz);
    }

    public Table getScalarsTable() {
        return this.scalarsTable;
    }

    public Map<String, Table> getGroupsTables() {
        return this.groupsTables;
    }

    public ServerError[] getErrors() {
        return this.errors;
    }

    public QueryMeta getMeta() {
        return this.meta;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OnlineQueryResult)) {
            return false;
        }
        OnlineQueryResult other = (OnlineQueryResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Table this$scalarsTable = this.getScalarsTable();
        Table other$scalarsTable = other.getScalarsTable();
        if (this$scalarsTable == null ? other$scalarsTable != null : !this$scalarsTable.equals(other$scalarsTable)) {
            return false;
        }
        Map<String, Table> this$groupsTables = this.getGroupsTables();
        Map<String, Table> other$groupsTables = other.getGroupsTables();
        if (this$groupsTables == null ? other$groupsTables != null : !((Object)this$groupsTables).equals(other$groupsTables)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getErrors(), other.getErrors())) {
            return false;
        }
        QueryMeta this$meta = this.getMeta();
        QueryMeta other$meta = other.getMeta();
        return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OnlineQueryResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Table $scalarsTable = this.getScalarsTable();
        result = result * 59 + ($scalarsTable == null ? 43 : $scalarsTable.hashCode());
        Map<String, Table> $groupsTables = this.getGroupsTables();
        result = result * 59 + ($groupsTables == null ? 43 : ((Object)$groupsTables).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getErrors());
        QueryMeta $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        return result;
    }

    public String toString() {
        return "OnlineQueryResult(scalarsTable=" + this.getScalarsTable() + ", groupsTables=" + this.getGroupsTables() + ", errors=" + Arrays.deepToString(this.getErrors()) + ", meta=" + this.getMeta() + ")";
    }

    public OnlineQueryResult(Table scalarsTable, Map<String, Table> groupsTables, ServerError[] errors, QueryMeta meta) {
        this.scalarsTable = scalarsTable;
        this.groupsTables = groupsTables;
        this.errors = errors;
        this.meta = meta;
    }
}

