/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.client;

import ai.chalk.client.GrpcHeaders;
import ai.chalk.client.ServerType;
import ai.chalk.client.TokenRefresher;
import ai.chalk.protos.chalk.server.v1.GetTokenResponse;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.stub.MetadataUtils;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AuthenticatedHeaderClientInterceptor
implements ClientInterceptor {
    private final Map<Metadata.Key<String>, String> allHeaders;
    private final TokenRefresher tokenRefresher;

    public AuthenticatedHeaderClientInterceptor(@NonNull ServerType serverType, @NonNull Map<String, String> additionalHeaders, @NonNull TokenRefresher tokenRefresher, @NonNull String environmentId) {
        this.tokenRefresher = tokenRefresher;
        this.allHeaders = new HashMap<Metadata.Key<String>, String>(Map.of(GrpcHeaders.SERVER_TYPE_KEY, serverType.headerName(), GrpcHeaders.ENVIRONMENT_ID_KEY, environmentId));
        for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
            this.allHeaders.put((Metadata.Key<String>)Metadata.Key.of((String)entry.getKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), entry.getValue());
        }
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, final CallOptions callOptions, final Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                GetTokenResponse token = AuthenticatedHeaderClientInterceptor.this.tokenRefresher.getToken();
                for (Map.Entry<Metadata.Key<String>, String> entry : AuthenticatedHeaderClientInterceptor.this.allHeaders.entrySet()) {
                    headers.put(entry.getKey(), (Object)entry.getValue());
                }
                headers.put(GrpcHeaders.AUTHORIZATION_KEY, (Object)("Bearer " + token.getAccessToken()));
                MetadataUtils.newAttachHeadersInterceptor((Metadata)headers).interceptCall(method, callOptions, next);
            }
        };
    }
}

