/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.client;

import ai.chalk.client.AuthenticatedHeaderClientInterceptor;
import ai.chalk.client.BuilderImpl;
import ai.chalk.client.ResolvedConfig;
import ai.chalk.client.ServerType;
import ai.chalk.client.TokenRefresher;
import ai.chalk.client.UnauthenticatedHeaderClientInterceptor;
import ai.chalk.internal.config.Loader;
import ai.chalk.internal.config.models.ProjectToken;
import ai.chalk.protos.chalk.server.v1.AuthServiceGrpc;
import ai.chalk.protos.chalk.server.v1.GetTokenResponse;
import ai.chalk.protos.chalk.server.v1.TeamServiceGrpc;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.TlsChannelCredentials;
import java.util.ArrayList;
import java.util.Map;

public class GRPCClient {
    private final AuthServiceGrpc.AuthServiceBlockingStub authStub;
    private final TeamServiceGrpc.TeamServiceBlockingStub teamStub;

    public GRPCClient(BuilderImpl builder) {
        ProjectToken chalkYamlConfig = new ProjectToken();
        try {
            String projectRoot = Loader.loadProjectDirectory();
            chalkYamlConfig = Loader.getChalkYamlConfig(projectRoot);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResolvedConfig resolvedConfig = ResolvedConfig.fromBuilder(builder, chalkYamlConfig);
        if (resolvedConfig.clientId().value().isEmpty() || resolvedConfig.clientSecret().value().isEmpty()) {
            throw new IllegalArgumentException("Client ID and Client Secret are required");
        }
        String grpcHost = resolvedConfig.grpcHost();
        ChannelCredentials channelCreds = grpcHost.startsWith("localhost") || grpcHost.startsWith("127.0.0.1") ? InsecureChannelCredentials.create() : TlsChannelCredentials.create();
        ManagedChannelBuilder unauthenticatedChannelBuilder = Grpc.newChannelBuilder((String)grpcHost, (ChannelCredentials)channelCreds).maxInboundMessageSize(0x6400000);
        this.authStub = AuthServiceGrpc.newBlockingStub((Channel)unauthenticatedChannelBuilder.intercept(new ClientInterceptor[]{new UnauthenticatedHeaderClientInterceptor(Map.of())}).build());
        TokenRefresher tokenRefresher = new TokenRefresher(resolvedConfig.clientId().value(), resolvedConfig.clientSecret().value(), this.authStub);
        GetTokenResponse token = tokenRefresher.getToken();
        String environmentId = resolvedConfig.environmentId().value();
        if (environmentId.isEmpty() && !token.getPrimaryEnvironment().isEmpty()) {
            environmentId = token.getPrimaryEnvironment();
        }
        if (environmentId.isEmpty()) {
            throw new IllegalArgumentException("Environment ID is required");
        }
        if (!token.containsEnvironmentIdToName(environmentId)) {
            ArrayList<String> environmentIds = new ArrayList<String>();
            for (Map.Entry<String, String> entry : token.getEnvironmentIdToNameMap().entrySet()) {
                if (!entry.getValue().equals(environmentId)) continue;
                environmentIds.add(entry.getKey());
            }
            if (environmentIds.isEmpty()) {
                throw new IllegalArgumentException("Environment name %s not found".formatted(environmentId));
            }
            if (environmentIds.size() > 1) {
                throw new IllegalArgumentException("Environment name %s is ambiguous among %s".formatted(environmentId, environmentIds));
            }
            environmentId = (String)environmentIds.get(0);
        }
        ManagedChannel authenticatedServerChannel = Grpc.newChannelBuilder((String)grpcHost, (ChannelCredentials)channelCreds).maxInboundMessageSize(0x6400000).intercept(new ClientInterceptor[]{new AuthenticatedHeaderClientInterceptor(ServerType.SERVER, Map.of(), tokenRefresher, environmentId)}).build();
        this.teamStub = TeamServiceGrpc.newBlockingStub((Channel)authenticatedServerChannel);
    }
}

