/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.client;

import ai.chalk.client.ChalkClient;
import ai.chalk.client.ConfigEnvVars;
import ai.chalk.internal.config.models.ProjectToken;
import ai.chalk.internal.config.models.SourcedConfig;
import org.checkerframework.checker.nullness.qual.NonNull;

public record ResolvedConfig(@NonNull SourcedConfig apiServer, @NonNull SourcedConfig clientId, @NonNull SourcedConfig clientSecret, @NonNull SourcedConfig environmentId) {
    public static ResolvedConfig fromBuilder(ChalkClient.Builder builder, ProjectToken chalkYamlConfig) {
        return new ResolvedConfig(SourcedConfig.firstNonEmpty(SourcedConfig.fromBuilder(builder.getApiServer()), SourcedConfig.fromEnvVar(ConfigEnvVars.apiServerKey), SourcedConfig.fromConfigFile(chalkYamlConfig.getApiServer()), new SourcedConfig("default", "https://api.chalk.ai")), SourcedConfig.firstNonEmpty(SourcedConfig.fromBuilder(builder.getClientId()), SourcedConfig.fromEnvVar(ConfigEnvVars.clientIdKey), SourcedConfig.fromConfigFile(chalkYamlConfig.getClientId())), SourcedConfig.firstNonEmpty(SourcedConfig.fromBuilder(builder.getClientSecret()), SourcedConfig.fromEnvVar(ConfigEnvVars.clientSecretKey), SourcedConfig.fromConfigFile(chalkYamlConfig.getClientSecret())), SourcedConfig.firstNonEmpty(SourcedConfig.fromBuilder(builder.getEnvironmentId()), SourcedConfig.fromEnvVar(ConfigEnvVars.environmentIdKey), SourcedConfig.fromConfigFile(chalkYamlConfig.getActiveEnvironment())));
    }

    public String grpcHost() {
        return this.apiServer.value().replaceFirst("^https?://", "");
    }
}

