/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.client;

import ai.chalk.protos.chalk.server.v1.AuthServiceGrpc;
import ai.chalk.protos.chalk.server.v1.GetTokenRequest;
import ai.chalk.protos.chalk.server.v1.GetTokenResponse;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TokenRefresher {
    private final AuthServiceGrpc.AuthServiceBlockingStub blockingStub;
    private final @NonNull String clientId;
    private final @NonNull String clientSecret;
    private @Nullable GetTokenResponse lastToken;

    public TokenRefresher(@NonNull String clientId, @NonNull String clientSecret, AuthServiceGrpc.AuthServiceBlockingStub blockingStub) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.blockingStub = blockingStub;
        this.lastToken = null;
    }

    public @NonNull GetTokenResponse getToken() {
        if (this.lastToken == null || this.lastToken.getExpiresAt().getSeconds() < System.currentTimeMillis() / 1000L + 60L) {
            this.lastToken = this.blockingStub.getToken(GetTokenRequest.newBuilder().setClientId(this.clientId).setClientSecret(this.clientSecret).build());
        }
        return this.lastToken;
    }
}

