/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.internal.arrow;

import ai.chalk.internal.Utils;
import ai.chalk.internal.arrow.StructEntry;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.arrow.compression.CommonsCompressionFactory;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.impl.BigIntWriterImpl;
import org.apache.arrow.vector.complex.impl.BitWriterImpl;
import org.apache.arrow.vector.complex.impl.Float8WriterImpl;
import org.apache.arrow.vector.complex.impl.LargeVarBinaryWriterImpl;
import org.apache.arrow.vector.complex.impl.LargeVarCharWriterImpl;
import org.apache.arrow.vector.complex.impl.NullableStructWriter;
import org.apache.arrow.vector.complex.impl.TimeStampMicroTZWriterImpl;
import org.apache.arrow.vector.complex.impl.TimeStampMicroWriterImpl;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.BigIntWriter;
import org.apache.arrow.vector.complex.writer.BitWriter;
import org.apache.arrow.vector.complex.writer.Float8Writer;
import org.apache.arrow.vector.complex.writer.LargeVarBinaryWriter;
import org.apache.arrow.vector.complex.writer.LargeVarCharWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMicroTZWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMicroWriter;
import org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.arrow.vector.holders.TimeStampMicroHolder;
import org.apache.arrow.vector.holders.TimeStampMicroTZHolder;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.ipc.SeekableReadChannel;
import org.apache.arrow.vector.table.Table;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;
import org.apache.arrow.vector.util.VectorSchemaRootAppender;

public class FeatherProcessor {
    public static ArrayList<StructEntry> getEntriesFromMap(Map<String, ?> obj) {
        ArrayList<StructEntry> entries = new ArrayList<StructEntry>();
        for (Map.Entry<String, ?> entry : obj.entrySet()) {
            entries.add(new StructEntry(entry.getKey(), entry.getValue()));
        }
        return entries;
    }

    public static ArrayList<StructEntry> getEntriesFromObject(Object obj) throws Exception {
        Field[] fields;
        ArrayList<StructEntry> pairs = new ArrayList<StructEntry>();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            Object value = field.get(obj);
            pairs.add(new StructEntry(field.getName(), value));
        }
        return pairs;
    }

    public static ArrayList<StructEntry> getEntries(Object obj) throws Exception {
        if (obj instanceof Map) {
            Map mapObj = (Map)obj;
            return FeatherProcessor.getEntriesFromMap(mapObj);
        }
        return FeatherProcessor.getEntriesFromObject(obj);
    }

    public static void powerWrite(BaseWriter writer, Object value) throws Exception {
        if (value instanceof Integer) {
            if (!(writer instanceof BigIntWriter)) {
                throw new Exception(String.format("Have `Integer` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            BigIntWriter intWriter = (BigIntWriter)writer;
            intWriter.writeBigInt((long)((Integer)value).intValue());
        } else if (value instanceof Long) {
            if (!(writer instanceof BigIntWriter)) {
                throw new Exception(String.format("Have `Long` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            BigIntWriter intWriter = (BigIntWriter)writer;
            intWriter.writeBigInt(((Long)value).longValue());
        } else if (value instanceof Double) {
            if (!(writer instanceof Float8Writer)) {
                throw new Exception(String.format("Have `Double` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            Float8Writer floatWriter = (Float8Writer)writer;
            floatWriter.writeFloat8(((Double)value).doubleValue());
        } else if (value instanceof String) {
            String stringValue = (String)value;
            if (!(writer instanceof LargeVarCharWriter)) {
                throw new Exception(String.format("Have `String` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            LargeVarCharWriter stringWriter = (LargeVarCharWriter)writer;
            byte[] bytesValue = stringValue.getBytes();
            ArrowBuf tempBuf = new RootAllocator(Long.MAX_VALUE).buffer((long)bytesValue.length);
            tempBuf.setBytes(0L, bytesValue);
            stringWriter.writeLargeVarChar(0L, (long)bytesValue.length, tempBuf);
        } else if (value instanceof Boolean) {
            if (!(writer instanceof BitWriter)) {
                throw new Exception(String.format("Have `Boolean` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            BitWriter boolWriter = (BitWriter)writer;
            boolWriter.writeBit((Boolean)value != false ? 1 : 0);
        } else if (value instanceof byte[]) {
            byte[] binaryValue = (byte[])value;
            if (!(writer instanceof LargeVarBinaryWriter)) {
                throw new Exception(String.format("Have `byte[]` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            LargeVarBinaryWriter binaryWriter = (LargeVarBinaryWriter)writer;
            ArrowBuf tempBuf = new RootAllocator(Long.MAX_VALUE).buffer((long)binaryValue.length);
            tempBuf.setBytes(0L, binaryValue);
            binaryWriter.writeLargeVarBinary(0L, (long)binaryValue.length, tempBuf);
        } else if (value instanceof ZonedDateTime) {
            ZonedDateTime zonedDt = (ZonedDateTime)value;
            if (!(writer instanceof TimeStampMicroTZWriter)) {
                throw new Exception(String.format("Have `ZonedDateTime` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            TimeStampMicroTZWriter timestampWriter = (TimeStampMicroTZWriter)writer;
            TimeStampMicroTZHolder holder = new TimeStampMicroTZHolder();
            holder.value = zonedDt.toInstant().getEpochSecond() * 1000000L + (long)(zonedDt.getNano() / 1000);
            holder.timezone = zonedDt.getZone().toString();
            timestampWriter.write(holder);
        } else if (value instanceof LocalDateTime) {
            LocalDateTime localDt = (LocalDateTime)value;
            if (!(writer instanceof TimeStampMicroWriter)) {
                throw new Exception(String.format("Have `LocalDateTime` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            TimeStampMicroWriter timestampWriter = (TimeStampMicroWriter)writer;
            TimeStampMicroHolder holder = new TimeStampMicroHolder();
            holder.value = localDt.atZone(ZoneId.of("UTC")).toInstant().getEpochSecond() * 1000000L + (long)(localDt.getNano() / 1000);
            timestampWriter.write(holder);
        } else if (value instanceof List) {
            if (!(writer instanceof BaseWriter.ListWriter)) {
                throw new Exception(String.format("Have `List` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            BaseWriter.ListWriter listWriter = (BaseWriter.ListWriter)writer;
            if (((List)value).size() == 0) {
                throw new Exception("Input values is an `Array` or a `List` of length 0");
            }
            Object firstItem = ((List)value).get(0);
            Object innerWriter = firstItem instanceof Integer ? listWriter.bigInt() : (firstItem instanceof Long ? listWriter.bigInt() : (firstItem instanceof Double ? listWriter.float8() : (firstItem instanceof String ? listWriter.largeVarChar() : (firstItem instanceof Boolean ? listWriter.bit() : (firstItem instanceof byte[] ? listWriter.largeVarBinary() : (firstItem instanceof ZonedDateTime ? listWriter.timeStampMicroTZ() : (firstItem instanceof LocalDateTime ? listWriter.timeStampMicro() : (firstItem instanceof List ? listWriter.list() : listWriter.struct()))))))));
            listWriter.startList();
            for (Object item : (List)value) {
                FeatherProcessor.powerWrite((BaseWriter)innerWriter, item);
            }
            listWriter.endList();
        } else if (writer instanceof NullableStructWriter) {
            NullableStructWriter structWriter = (NullableStructWriter)writer;
            structWriter.start();
            for (StructEntry pair : FeatherProcessor.getEntries(value)) {
                Object fieldVal = pair.value();
                String fieldName = pair.key();
                if (fieldVal instanceof Integer) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.bigInt(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof Long) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.bigInt(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof Double) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.float8(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof String) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.largeVarChar(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof Boolean) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.bit(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof byte[]) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.largeVarBinary(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof ZonedDateTime) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.timeStampMicroTZ(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof LocalDateTime) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.timeStampMicro(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof List) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.list(fieldName), fieldVal);
                    continue;
                }
                throw new Exception("Unsupported data type: " + fieldVal.getClass().getSimpleName());
            }
            structWriter.end();
        } else if (writer instanceof UnionListWriter) {
            UnionListWriter structWriter = (UnionListWriter)writer;
            structWriter.start();
            for (StructEntry pair : FeatherProcessor.getEntries(value)) {
                Object fieldVal = pair.value();
                String fieldName = pair.key();
                if (fieldVal instanceof Integer) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.bigInt(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof Long) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.bigInt(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof Double) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.float8(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof String) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.largeVarChar(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof Boolean) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.bit(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof ZonedDateTime) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.timeStampMicroTZ(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof LocalDateTime) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.timeStampMicro(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof byte[]) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.largeVarBinary(fieldName), fieldVal);
                    continue;
                }
                if (fieldVal instanceof List) {
                    FeatherProcessor.powerWrite((BaseWriter)structWriter.list(fieldName), fieldVal);
                    continue;
                }
                throw new Exception("Unsupported data type: " + fieldVal.getClass().getSimpleName());
            }
            structWriter.end();
        } else {
            throw new Exception("Unsupported data type: " + value.getClass().getSimpleName());
        }
    }

    public static byte[] inputsToArrowBytes(Map<String, List<?>> inputs) throws Exception {
        ArrayList<Object> fieldVectors = new ArrayList<Object>();
        int uniformListLength = -1;
        for (Map.Entry<String, List<?>> entry : inputs.entrySet()) {
            BigIntWriterImpl writer;
            ArrayList values;
            List<?> value = entry.getValue();
            try {
                values = new ArrayList(value);
            }
            catch (Exception e) {
                throw new Exception(String.format("error converting '%s' value to a `List<Object>`: %s", entry.getKey(), e.getMessage()));
            }
            if (values.size() == 0) {
                throw new Exception("Input values is an `Array` or a `List` of length 0");
            }
            if (uniformListLength == -1) {
                uniformListLength = values.size();
            } else if (uniformListLength != values.size()) {
                throw new Exception(String.format("Input values have different lengths - expected %d but got %d: %s", uniformListLength, values.size(), values));
            }
            Class<?> clazz = values.get(0).getClass();
            Object firstVal = values.get(0);
            String fqn = entry.getKey();
            if (firstVal instanceof Integer) {
                BigIntVector intVector = new BigIntVector(fqn, (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                fieldVectors.add(intVector);
                writer = new BigIntWriterImpl(intVector);
                for (int i = 0; i < values.size(); ++i) {
                    writer.setPosition(i);
                    FeatherProcessor.powerWrite((BaseWriter)writer, values.get(i));
                }
                continue;
            }
            if (firstVal instanceof Long) {
                BigIntVector longVector = new BigIntVector(fqn, (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                fieldVectors.add(longVector);
                writer = new BigIntWriterImpl(longVector);
                for (int i = 0; i < values.size(); ++i) {
                    writer.setPosition(i);
                    FeatherProcessor.powerWrite((BaseWriter)writer, values.get(i));
                }
                continue;
            }
            if (firstVal instanceof Double) {
                Float8Vector doubleVector = new Float8Vector(fqn, (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                fieldVectors.add(doubleVector);
                writer = new Float8WriterImpl(doubleVector);
                for (int i = 0; i < values.size(); ++i) {
                    writer.setPosition(i);
                    FeatherProcessor.powerWrite((BaseWriter)writer, values.get(i));
                }
                continue;
            }
            if (firstVal instanceof String) {
                LargeVarCharVector stringVector = new LargeVarCharVector(fqn, (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                fieldVectors.add(stringVector);
                writer = new LargeVarCharWriterImpl(stringVector);
                for (int i = 0; i < values.size(); ++i) {
                    writer.setPosition(i);
                    FeatherProcessor.powerWrite((BaseWriter)writer, values.get(i));
                }
                continue;
            }
            if (firstVal instanceof Boolean) {
                BitVector boolVector = new BitVector(fqn, (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                fieldVectors.add(boolVector);
                writer = new BitWriterImpl(boolVector);
                for (int i = 0; i < values.size(); ++i) {
                    writer.setPosition(i);
                    FeatherProcessor.powerWrite((BaseWriter)writer, values.get(i));
                }
                continue;
            }
            if (firstVal instanceof byte[]) {
                LargeVarBinaryVector binaryVector = new LargeVarBinaryVector(fqn, (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                fieldVectors.add(binaryVector);
                writer = new LargeVarBinaryWriterImpl(binaryVector);
                for (int i = 0; i < values.size(); ++i) {
                    writer.setPosition(i);
                    FeatherProcessor.powerWrite((BaseWriter)writer, values.get(i));
                }
                continue;
            }
            if (firstVal instanceof ZonedDateTime) {
                ZonedDateTime zonedDt = (ZonedDateTime)firstVal;
                String tz = zonedDt.getZone().toString();
                TimeStampMicroTZVector timestampVector = new TimeStampMicroTZVector(fqn, (BufferAllocator)new RootAllocator(Long.MAX_VALUE), tz);
                fieldVectors.add(timestampVector);
                TimeStampMicroTZWriterImpl writer2 = new TimeStampMicroTZWriterImpl(timestampVector);
                for (int i = 0; i < values.size(); ++i) {
                    writer2.setPosition(i);
                    FeatherProcessor.powerWrite((BaseWriter)writer2, values.get(i));
                }
                continue;
            }
            if (firstVal instanceof LocalDateTime) {
                LocalDateTime localDt = (LocalDateTime)firstVal;
                TimeStampMicroVector timestampVector = new TimeStampMicroVector(fqn, (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                fieldVectors.add(timestampVector);
                writer = new TimeStampMicroWriterImpl(timestampVector);
                for (int i = 0; i < values.size(); ++i) {
                    writer.setPosition(i);
                    FeatherProcessor.powerWrite((BaseWriter)writer, values.get(i));
                }
                continue;
            }
            if (firstVal instanceof List) {
                LargeListVector listVector = LargeListVector.empty((String)fqn, (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                fieldVectors.add(listVector);
                writer = listVector.getWriter();
                for (Object o : values) {
                    FeatherProcessor.powerWrite((BaseWriter)writer, o);
                }
                writer.setValueCount(values.size());
                continue;
            }
            if (firstVal instanceof Map) {
                StructVector structVector = StructVector.empty((String)fqn, (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                fieldVectors.add(structVector);
                writer = structVector.getWriter();
                for (Object o : values) {
                    FeatherProcessor.powerWrite((BaseWriter)writer, o);
                }
                writer.setValueCount(values.size());
                continue;
            }
            throw new Exception("Unsupported data type: " + clazz.getSimpleName());
        }
        VectorSchemaRoot root = VectorSchemaRoot.of((FieldVector[])Utils.listToArray(fieldVectors, FieldVector.class));
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ArrowFileWriter writer = new ArrowFileWriter(root, null, Channels.newChannel(out));){
                writer.start();
                writer.writeBatch();
                writer.end();
                writer.close();
                root.close();
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    public static Table getTableIfBatchSizeOne(byte[] bytes) throws Exception {
        SeekableReadChannel seekableReadChannelBatchCounter = new SeekableReadChannel((SeekableByteChannel)new ByteArrayReadableSeekableByteChannel(bytes));
        ArrowFileReader arrowFileReaderBatchCounter = new ArrowFileReader(seekableReadChannelBatchCounter, (BufferAllocator)new RootAllocator(Long.MAX_VALUE), (CompressionCodec.Factory)new CommonsCompressionFactory());
        int numBatches = 0;
        try (VectorSchemaRoot readerRootBatchCounter = arrowFileReaderBatchCounter.getVectorSchemaRoot();){
            Table firstTable = null;
            while (arrowFileReaderBatchCounter.loadNextBatch()) {
                if (firstTable == null) {
                    firstTable = new Table(readerRootBatchCounter);
                }
                ++numBatches;
            }
            if (numBatches == 1) {
                Table table = firstTable;
                return table;
            }
            if (firstTable != null) {
                firstTable.close();
            }
        }
        arrowFileReaderBatchCounter.close();
        return null;
    }

    public static Table convertBytesToTable(byte[] bytes) throws Exception {
        Table maybeSingleBatchTable = FeatherProcessor.getTableIfBatchSizeOne(bytes);
        if (maybeSingleBatchTable != null) {
            return maybeSingleBatchTable;
        }
        SeekableReadChannel seekableReadChannel = new SeekableReadChannel((SeekableByteChannel)new ByteArrayReadableSeekableByteChannel(bytes));
        ArrowFileReader arrowFileReader = new ArrowFileReader(seekableReadChannel, (BufferAllocator)new RootAllocator(Long.MAX_VALUE), (CompressionCodec.Factory)new CommonsCompressionFactory());
        try (VectorSchemaRoot readerRoot = arrowFileReader.getVectorSchemaRoot();){
            Table table;
            block14: {
                VectorSchemaRoot collectorRoot = VectorSchemaRoot.create((Schema)readerRoot.getSchema(), (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                try {
                    collectorRoot.allocateNew();
                    while (arrowFileReader.loadNextBatch()) {
                        VectorSchemaRootAppender.append((VectorSchemaRoot)collectorRoot, (VectorSchemaRoot[])new VectorSchemaRoot[]{readerRoot});
                    }
                    Table table2 = new Table(collectorRoot);
                    arrowFileReader.close();
                    table = table2;
                    if (collectorRoot == null) break block14;
                }
                catch (Throwable throwable) {
                    if (collectorRoot != null) {
                        try {
                            collectorRoot.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                collectorRoot.close();
            }
            return table;
        }
    }
}

