/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.internal.codegen;

import ai.chalk.features.Feature;
import ai.chalk.features.FeaturesBase;
import ai.chalk.features.StructFeaturesClass;
import ai.chalk.features.Versioned;
import ai.chalk.features.WindowedFeaturesClass;
import ai.chalk.internal.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class Initializer {
    public static Exception initFeatures(Class<?> cls) {
        Field[] fields;
        for (Field field : fields = cls.getDeclaredFields()) {
            if (!FeaturesBase.class.isAssignableFrom(field.getType())) continue;
            String rootFeatureFqn = Utils.chalkpySnakeCase(field.getType().getSimpleName());
            try {
                Object featureClass = Initializer.init(field, rootFeatureFqn, null, new HashSet());
                field.set(cls, featureClass);
            }
            catch (Exception e) {
                return e;
            }
        }
        return null;
    }

    public static Map<String, List<Feature<?>>> initResult(FeaturesBase fc) throws Exception {
        Field[] myFields = fc.getClass().getDeclaredFields();
        Field[] parentFields = fc.getClass().getSuperclass().getDeclaredFields();
        Field[] fields = (Field[])Stream.concat(Arrays.stream(myFields), Arrays.stream(parentFields)).toArray(Field[]::new);
        HashMap featureMap = new HashMap();
        String rootFeatureFqn = Utils.chalkpySnakeCase(fc.getClass().getSimpleName());
        for (Field field : fields) {
            String childFqn = rootFeatureFqn + "." + Utils.getResolvedName(field);
            Object feature = Initializer.init(field, childFqn, featureMap, new HashSet());
            field.set(fc, feature);
        }
        return featureMap;
    }

    public static Object init(Field f, String fqn, Map<String, List<Feature<?>>> featureMap, Set<Class<?>> seenClassesInChain) throws Exception {
        if (FeaturesBase.class.isAssignableFrom(f.getType())) {
            if (seenClassesInChain.contains(f.getType())) {
                return null;
            }
            seenClassesInChain.add(f.getType());
            FeaturesBase fc = (FeaturesBase)f.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
            fc.setFqn((String)fqn);
            for (Field ff : f.getType().getFields()) {
                Object childFqn = (String)fqn + "." + Utils.getResolvedName(ff);
                if (StructFeaturesClass.class.isAssignableFrom(f.getType()) && featureMap == null) {
                    childFqn = fqn;
                } else if (WindowedFeaturesClass.class.isAssignableFrom(f.getType())) {
                    String lastPart = Utils.getDotDelimitedLastSection((String)childFqn);
                    String durationWithUnitStr = lastPart.substring("bucket_".length());
                    String convertedDurationStr = Utils.convertBucketDurationToSeconds(durationWithUnitStr);
                    String replacementPart = String.format("__%s__", convertedDurationStr);
                    String partToReplace = "." + lastPart;
                    childFqn = ((String)childFqn).replace(partToReplace, replacementPart);
                }
                Object obj = Initializer.init(ff, (String)childFqn, featureMap, seenClassesInChain);
                ff.set(fc, obj);
            }
            seenClassesInChain.remove(f.getType());
            return fc;
        }
        if (f.getType() == Feature.class) {
            Feature feature = (Feature)f.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
            if (f.isAnnotationPresent(Versioned.class)) {
                Versioned versionInfo = f.getAnnotation(Versioned.class);
                if (versionInfo.defaultVersion() == 0) {
                    String[] parts = ((String)fqn).split("_");
                    String versionStr = parts[parts.length - 1].substring(1);
                    String baseFqn = String.join((CharSequence)"_", Arrays.copyOf(parts, parts.length - 1));
                    fqn = versionStr.equals("1") ? baseFqn : baseFqn + "@" + versionStr;
                } else if (versionInfo.defaultVersion() > 1) {
                    fqn = (String)fqn + "@" + versionInfo.defaultVersion();
                }
            }
            feature.setFqn((String)fqn);
            if (featureMap != null) {
                if (featureMap.containsKey(fqn)) {
                    featureMap.get(fqn).add(feature);
                } else {
                    featureMap.put((String)fqn, new ArrayList<Feature>(List.of(feature)));
                }
            }
            return feature;
        }
        throw new Exception("Unknown type found during call - expected `FeaturesClass` or `Feature`, found: " + f.getType());
    }
}

