/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.models;

import ai.chalk.features.Feature;
import ai.chalk.features.FeaturesBase;
import ai.chalk.features.StructFeaturesClass;
import ai.chalk.features.WindowedFeaturesClass;
import ai.chalk.models.OnlineQueryParamsComplete;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OnlineQueryParams {
    private Map<String, List<?>> inputs;
    private List<String> outputs;
    private Map<String, Duration> staleness;
    private Map<String, String> meta;
    private List<String> tags;
    private boolean includeMeta;
    private boolean storePlanStages;
    private boolean explain;
    private String environmentId;
    private String previewDeploymentId;
    private String queryName;
    private String correlationId;
    private String branch;

    public static BuilderSeed builder() {
        return new BuilderSeed();
    }

    public OnlineQueryParams(Map<String, List<?>> inputs, List<String> outputs, Map<String, Duration> staleness, Map<String, String> meta, List<String> tags, boolean includeMeta, boolean storePlanStages, boolean explain, String environmentId, String previewDeploymentId, String queryName, String correlationId, String branch) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.staleness = staleness;
        this.meta = meta;
        this.tags = tags;
        this.includeMeta = includeMeta;
        this.storePlanStages = storePlanStages;
        this.explain = explain;
        this.environmentId = environmentId;
        this.previewDeploymentId = previewDeploymentId;
        this.queryName = queryName;
        this.correlationId = correlationId;
        this.branch = branch;
    }

    public Map<String, List<?>> getInputs() {
        return this.inputs;
    }

    public List<String> getOutputs() {
        return this.outputs;
    }

    public Map<String, Duration> getStaleness() {
        return this.staleness;
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public boolean isIncludeMeta() {
        return this.includeMeta;
    }

    public boolean isStorePlanStages() {
        return this.storePlanStages;
    }

    public boolean isExplain() {
        return this.explain;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public String getPreviewDeploymentId() {
        return this.previewDeploymentId;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getBranch() {
        return this.branch;
    }

    public static class BuilderSeed
    extends Builder<BuilderSeed> {
        public BuilderSeed(Map<String, List<?>> inputs, List<String> outputs, Map<String, Duration> staleness, Map<String, String> meta, List<String> tags, boolean includeMeta, boolean storePlanStages, boolean explain, String environmentId, String previewDeploymentId, String queryName, String correlationId, String branch) {
            super(inputs, outputs, staleness, meta, tags, includeMeta, storePlanStages, explain, environmentId, previewDeploymentId, queryName, correlationId, branch);
        }

        public BuilderWithInputs newBuilderWithInputs() {
            return new BuilderWithInputs(this.inputs, this.outputs, this.staleness, this.meta, this.tags, this.includeMeta, this.storePlanStages, this.explain, this.environmentId, this.previewDeploymentId, this.queryName, this.correlationId, this.branch);
        }

        public BuilderWithOutputs newBuilderWithOutputs() {
            return new BuilderWithOutputs(this.inputs, this.outputs, this.staleness, this.meta, this.tags, this.includeMeta, this.storePlanStages, this.explain, this.environmentId, this.previewDeploymentId, this.queryName, this.correlationId, this.branch);
        }

        public BuilderWithInputs withInput(String fqn, List<?> values) {
            return this.newBuilderWithInputs().withInput(fqn, values);
        }

        public BuilderWithInputs withInputs(Map<String, List<?>> inputs) {
            return this.newBuilderWithInputs().withInputs(inputs);
        }

        @SafeVarargs
        public final <T> BuilderWithInputs withInput(Feature<T> feature, T ... value) {
            return this.newBuilderWithInputs().withInput(feature, value);
        }

        public final <T> BuilderWithInputs withInput(Feature<T> feature, List<T> value) {
            return this.newBuilderWithInputs().withInput(feature, value);
        }

        public BuilderWithOutputs withOutputs(String ... outputs) {
            return this.newBuilderWithOutputs().withOutputs(outputs);
        }

        public BuilderWithOutputs withOutputs(List<String> outputs) {
            return this.newBuilderWithOutputs().withOutputs(outputs);
        }

        public BuilderWithOutputs withOutputs(Feature<?> ... outputs) {
            return this.newBuilderWithOutputs().withOutputs(outputs);
        }

        public BuilderWithOutputs withOutputs(WindowedFeaturesClass ... outputs) {
            return this.newBuilderWithOutputs().withOutputs(outputs);
        }

        public BuilderWithOutputs withOutputs(StructFeaturesClass ... outputs) {
            return this.newBuilderWithOutputs().withOutputs(outputs);
        }

        public BuilderSeed() {
        }
    }

    public static class BuilderWithOutputs
    extends Builder<BuilderWithOutputs> {
        public BuilderWithOutputs(Map<String, List<?>> inputs, List<String> outputs, Map<String, Duration> staleness, Map<String, String> meta, List<String> tags, boolean includeMeta, boolean storePlanStages, boolean explain, String environmentId, String previewDeploymentId, String queryName, String correlationId, String branch) {
            super(inputs, outputs, staleness, meta, tags, includeMeta, storePlanStages, explain, environmentId, previewDeploymentId, queryName, correlationId, branch);
        }

        public BuilderComplete newBuilderComplete() {
            return new BuilderComplete(this.inputs, this.outputs, this.staleness, this.meta, this.tags, this.includeMeta, this.storePlanStages, this.explain, this.environmentId, this.previewDeploymentId, this.queryName, this.correlationId, this.branch);
        }

        public BuilderComplete withInput(String fqn, List<?> values) {
            return (BuilderComplete)this.newBuilderComplete()._withInput(fqn, values);
        }

        @SafeVarargs
        public final <T> BuilderComplete withInput(Feature<T> feature, T ... values) {
            return this.newBuilderComplete().withInput(feature, values);
        }

        public final <T> BuilderComplete withInput(Feature<T> feature, List<T> values) {
            return this.newBuilderComplete().withInput(feature, values);
        }

        public final <T> BuilderComplete withInputs(Map<String, List<?>> inputs) {
            return (BuilderComplete)this.newBuilderComplete()._withInputs(inputs);
        }

        public BuilderWithOutputs withOutputs(String ... outputs) {
            return (BuilderWithOutputs)this._withOutputs(outputs);
        }

        public BuilderWithOutputs withOutputs(List<String> outputs) {
            return (BuilderWithOutputs)this._withOutputs(outputs);
        }

        public BuilderWithOutputs withOutputs(Feature<?> ... outputs) {
            return (BuilderWithOutputs)this._withOutputs(outputs);
        }

        public BuilderWithOutputs withOutputs(FeaturesBase ... outputs) {
            return (BuilderWithOutputs)this._withOutputs(outputs);
        }
    }

    public static class BuilderWithInputs
    extends Builder<BuilderWithInputs> {
        public BuilderWithInputs(Map<String, List<?>> inputs, List<String> outputs, Map<String, Duration> staleness, Map<String, String> meta, List<String> tags, boolean includeMeta, boolean storePlanStages, boolean explain, String environmentId, String previewDeploymentId, String queryName, String correlationId, String branch) {
            super(inputs, outputs, staleness, meta, tags, includeMeta, storePlanStages, explain, environmentId, previewDeploymentId, queryName, correlationId, branch);
        }

        private BuilderComplete newBuilderComplete() {
            return new BuilderComplete(this.inputs, this.outputs, this.staleness, this.meta, this.tags, this.includeMeta, this.storePlanStages, this.explain, this.environmentId, this.previewDeploymentId, this.queryName, this.correlationId, this.branch);
        }

        public BuilderWithInputs withInput(String fqn, List<?> values) {
            return (BuilderWithInputs)this._withInput(fqn, values);
        }

        public BuilderWithInputs withInputs(Map<String, List<?>> inputs) {
            return (BuilderWithInputs)this._withInputs(inputs);
        }

        @SafeVarargs
        public final <T> BuilderWithInputs withInput(Feature<T> feature, T ... values) {
            return (BuilderWithInputs)this._withInput(feature, values);
        }

        public final <T> BuilderWithInputs withInput(Feature<T> feature, List<T> values) {
            return (BuilderWithInputs)this._withInput(feature, values);
        }

        public BuilderComplete withOutputs(String ... outputs) {
            return (BuilderComplete)this.newBuilderComplete()._withOutputs(outputs);
        }

        public BuilderComplete withOutputs(List<String> outputs) {
            return (BuilderComplete)this.newBuilderComplete()._withOutputs(outputs);
        }

        public BuilderComplete withOutputs(Feature<?> ... outputs) {
            return (BuilderComplete)this.newBuilderComplete()._withOutputs(outputs);
        }

        public BuilderComplete withOutputs(FeaturesBase ... outputs) {
            return (BuilderComplete)this.newBuilderComplete()._withOutputs(outputs);
        }
    }

    public static class BuilderComplete
    extends Builder<BuilderComplete> {
        public BuilderComplete(Map<String, List<?>> inputs, List<String> outputs, Map<String, Duration> staleness, Map<String, String> meta, List<String> tags, boolean includeMeta, boolean storePlanStages, boolean explain, String environmentId, String previewDeploymentId, String queryName, String correlationId, String branch) {
            super(inputs, outputs, staleness, meta, tags, includeMeta, storePlanStages, explain, environmentId, previewDeploymentId, queryName, correlationId, branch);
        }

        public BuilderComplete withInput(String fqn, List<?> values) {
            return (BuilderComplete)this._withInput(fqn, values);
        }

        public BuilderComplete withInputs(Map<String, List<?>> inputs) {
            return (BuilderComplete)this._withInputs(inputs);
        }

        @SafeVarargs
        public final <T> BuilderComplete withInput(Feature<T> feature, T ... values) {
            return (BuilderComplete)this._withInput(feature, values);
        }

        public final <T> BuilderComplete withInput(Feature<T> feature, List<T> values) {
            return (BuilderComplete)this._withInput(feature, values);
        }

        public BuilderComplete withOutputs(String ... outputs) {
            return (BuilderComplete)this._withOutputs(outputs);
        }

        public BuilderComplete withOutputs(List<String> outputs) {
            return (BuilderComplete)this._withOutputs(outputs);
        }

        public BuilderComplete withOutputs(Feature<?> ... outputs) {
            return (BuilderComplete)this._withOutputs(outputs);
        }

        public BuilderComplete withOutputs(FeaturesBase ... outputs) {
            return (BuilderComplete)this._withOutputs(outputs);
        }

        @Override
        public OnlineQueryParamsComplete build() {
            return new OnlineQueryParamsComplete(this.inputs, this.outputs, this.staleness, this.meta, this.tags, this.includeMeta, this.storePlanStages, this.explain, this.environmentId, this.previewDeploymentId, this.queryName, this.correlationId, this.branch);
        }
    }

    public static class Builder<T extends Builder<T>> {
        protected Map<String, List<?>> inputs;
        protected List<String> outputs;
        protected Map<String, Duration> staleness;
        protected Map<String, String> meta;
        protected List<String> tags;
        protected boolean includeMeta;
        protected boolean storePlanStages;
        protected boolean explain;
        protected String environmentId;
        protected String previewDeploymentId;
        protected String queryName;
        protected String correlationId;
        protected String branch;

        protected T _withInput(String fqn, List<?> values) {
            if (this.inputs == null) {
                this.inputs = new HashMap();
            }
            this.inputs.put(fqn, values);
            return (T)this;
        }

        public <K> T _withInput(Feature<K> feature, K ... value) {
            return this._withInput(feature.getFqn(), Arrays.asList(value));
        }

        public <K> T _withInput(Feature<K> feature, List<K> value) {
            return this._withInput(feature.getFqn(), value);
        }

        protected T _withInputs(Map<String, List<?>> inputs) {
            if (this.inputs == null) {
                this.inputs = new HashMap();
            }
            this.inputs.putAll(inputs);
            return (T)this;
        }

        protected T _withOutputs(String ... outputs) {
            if (this.outputs == null) {
                this.outputs = new ArrayList<String>();
            }
            this.outputs.addAll(Arrays.asList(outputs));
            return (T)this;
        }

        protected T _withOutputs(List<String> outputs) {
            if (this.outputs == null) {
                this.outputs = new ArrayList<String>();
            }
            this.outputs.addAll(outputs);
            return (T)this;
        }

        public T _withOutputs(Feature<?> ... outputs) {
            String[] outputFqns = new String[outputs.length];
            for (int i = 0; i < outputs.length; ++i) {
                outputFqns[i] = outputs[i].getFqn();
            }
            return this._withOutputs(outputFqns);
        }

        public T _withOutputs(FeaturesBase ... outputs) {
            String[] outputFqns = new String[outputs.length];
            for (int i = 0; i < outputs.length; ++i) {
                outputFqns[i] = outputs[i].getFqn();
            }
            return this._withOutputs(outputFqns);
        }

        public T withStaleness(Map<String, Duration> staleness) {
            if (this.staleness == null) {
                this.staleness = new HashMap<String, Duration>();
            }
            this.staleness.putAll(staleness);
            return (T)this;
        }

        public T withMeta(Map<String, String> meta) {
            if (this.meta == null) {
                this.meta = new HashMap<String, String>();
            }
            this.meta.putAll(meta);
            return (T)this;
        }

        public T withTags(List<String> tags) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.addAll(tags);
            return (T)this;
        }

        public T withTags(String ... tags) {
            return this.withTags(Arrays.asList(tags));
        }

        public T withTag(String tag) {
            return this.withTags(Arrays.asList(tag));
        }

        public T withIncludeMeta(boolean includeMeta) {
            this.includeMeta = includeMeta;
            return (T)this;
        }

        public T withStorePlanStages(boolean storePlanStages) {
            this.storePlanStages = storePlanStages;
            return (T)this;
        }

        public T withExplain(boolean explain) {
            this.explain = explain;
            return (T)this;
        }

        public T withEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
            return (T)this;
        }

        public T withPreviewDeploymentId(String previewDeploymentId) {
            this.previewDeploymentId = previewDeploymentId;
            return (T)this;
        }

        public T withQueryName(String queryName) {
            this.queryName = queryName;
            return (T)this;
        }

        public T withCorrelationId(String correlationId) {
            this.correlationId = correlationId;
            return (T)this;
        }

        public T withBranch(String branch) {
            this.branch = branch;
            return (T)this;
        }

        public OnlineQueryParams build() {
            return new OnlineQueryParams(this.inputs, this.outputs, this.staleness, this.meta, this.tags, this.includeMeta, this.storePlanStages, this.explain, this.environmentId, this.previewDeploymentId, this.queryName, this.correlationId, this.branch);
        }

        public Builder(Map<String, List<?>> inputs, List<String> outputs, Map<String, Duration> staleness, Map<String, String> meta, List<String> tags, boolean includeMeta, boolean storePlanStages, boolean explain, String environmentId, String previewDeploymentId, String queryName, String correlationId, String branch) {
            this.inputs = inputs;
            this.outputs = outputs;
            this.staleness = staleness;
            this.meta = meta;
            this.tags = tags;
            this.includeMeta = includeMeta;
            this.storePlanStages = storePlanStages;
            this.explain = explain;
            this.environmentId = environmentId;
            this.previewDeploymentId = previewDeploymentId;
            this.queryName = queryName;
            this.correlationId = correlationId;
            this.branch = branch;
        }

        public Builder() {
        }
    }
}

