/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.aggregator.base;

import ai.chronon.aggregator.base.MomentAggregator;
import ai.chronon.aggregator.base.MomentsIR;
import ai.chronon.api.DataType;
import ai.chronon.api.DoubleType$;
import ai.chronon.api.ListType;
import java.util.ArrayList;
import java.util.Collection;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;

public abstract class MomentAggregator$class {
    public static MomentsIR prepare(MomentAggregator $this, double input) {
        MomentsIR ir = new MomentsIR(0.0, 0.0, 0.0, 0.0, 0.0);
        return $this.update(ir, input);
    }

    public static MomentsIR update(MomentAggregator $this, MomentsIR ir, double x) {
        double n1 = ir.n();
        double n = ir.n() + 1.0;
        double delta = x - ir.m1();
        double deltaN = delta / n;
        double deltaN2 = deltaN * deltaN;
        double term1 = delta * deltaN * n1;
        double m1 = ir.m1() + deltaN;
        double m4 = ir.m4() + term1 * deltaN2 * (n * n - (double)3 * n + (double)3) + (double)6 * deltaN2 * ir.m2() - (double)4 * deltaN * ir.m3();
        double m3 = ir.m3() + term1 * deltaN * (n - (double)2) - (double)3 * deltaN * ir.m2();
        double m2 = ir.m2() + term1;
        return new MomentsIR(n, m1, m2, m3, m4);
    }

    public static DataType outputType(MomentAggregator $this) {
        return DoubleType$.MODULE$;
    }

    public static DataType irType(MomentAggregator $this) {
        return new ListType((DataType)DoubleType$.MODULE$);
    }

    public static MomentsIR merge(MomentAggregator $this, MomentsIR a, MomentsIR b) {
        double n = a.n() + b.n();
        double delta = b.m1() - a.m1();
        double delta2 = delta * delta;
        double delta3 = delta * delta2;
        double delta4 = delta2 * delta2;
        double m1 = (a.n() * a.m1() + b.n() * b.m1()) / n;
        double m2 = a.m2() + b.m2() + delta2 * a.n() * b.n() / n;
        double m3 = a.m3() + b.m3() + delta3 * a.n() * b.n() * (a.n() - b.n()) / (n * n) + 3.0 * delta * (a.n() * b.m2() - b.n() * a.m2()) / n;
        double m4 = a.m4() + b.m4() + delta4 * a.n() * b.n() * (a.n() * a.n() - a.n() * b.n() + b.n() * b.n()) / (n * n * n) + 6.0 * delta2 * (a.n() * a.n() * b.m2() + b.n() * b.n() * a.m2()) / (n * n) + 4.0 * delta * (a.n() * b.m3() - b.n() * a.m3()) / n;
        return new MomentsIR(n, m1, m2, m3, m4);
    }

    public static MomentsIR clone(MomentAggregator $this, MomentsIR ir) {
        return new MomentsIR(ir.n(), ir.m1(), ir.m2(), ir.m3(), ir.m4());
    }

    public static ArrayList normalize(MomentAggregator $this, MomentsIR ir) {
        List values = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{ir.n(), ir.m1(), ir.m2(), ir.m3(), ir.m4()}));
        return new ArrayList((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)values).asJava());
    }

    public static MomentsIR denormalize(MomentAggregator $this, Object normalized) {
        Buffer values = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)((ArrayList)normalized)).asScala();
        return new MomentsIR(BoxesRunTime.unboxToDouble((Object)values.apply(0)), BoxesRunTime.unboxToDouble((Object)values.apply(1)), BoxesRunTime.unboxToDouble((Object)values.apply(2)), BoxesRunTime.unboxToDouble((Object)values.apply(3)), BoxesRunTime.unboxToDouble((Object)values.apply(4)));
    }

    public static boolean isDeletable(MomentAggregator $this) {
        return false;
    }

    public static void $init$(MomentAggregator $this) {
    }
}

