/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.aggregator.base;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005)4Aa\u0003\u0007\u0001+!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u001dy\u0004A1A\u0005\n\u0001CaA\u0012\u0001!\u0002\u0013\tU\u0001B$\u0001\u0001!CQa\u0015\u0001\u0005\u000eQCQ\u0001\u0018\u0001\u0005\u0002uCQ!\u0019\u0001\u0005\u0002\tDQa\u001a\u0001\u0005\u0002!\u0014q!T5o\u0011\u0016\f\u0007O\u0003\u0002\u000e\u001d\u0005!!-Y:f\u0015\ty\u0001#\u0001\u0006bO\u001e\u0014XmZ1u_JT!!\u0005\n\u0002\u000f\rD'o\u001c8p]*\t1#\u0001\u0002bS\u000e\u0001QC\u0001\f1'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VMZ\u0001\b[\u0006D8+\u001b>f!\tAr$\u0003\u0002!3\t\u0019\u0011J\u001c;\u0002\u0011=\u0014H-\u001a:j]\u001e\u00042aI\u0016/\u001d\t!\u0013F\u0004\u0002&Q5\taE\u0003\u0002()\u00051AH]8pizJ\u0011AG\u0005\u0003Ue\tq\u0001]1dW\u0006<W-\u0003\u0002-[\tAqJ\u001d3fe&twM\u0003\u0002+3A\u0011q\u0006\r\u0007\u0001\t\u0015\t\u0004A1\u00013\u0005\u0005!\u0016CA\u001a7!\tAB'\u0003\u000263\t9aj\u001c;iS:<\u0007C\u0001\r8\u0013\tA\u0014DA\u0002B]f\fa\u0001P5oSRtDcA\u001e>}A\u0019A\b\u0001\u0018\u000e\u00031AQ!H\u0002A\u0002yAQ!I\u0002A\u0002\t\n\u0011C]3wKJ\u001cXmQ8na\u0006\u0014\u0018\r^8s+\u0005\t\u0005c\u0001\"F]5\t1I\u0003\u0002E3\u0005!Q.\u0019;i\u0013\ta3)\u0001\nsKZ,'o]3D_6\u0004\u0018M]1u_J\u0004#!D\"p]R\f\u0017N\\3s)f\u0004X-\u0006\u0002J%B\u0019!jT)\u000e\u0003-S!\u0001T'\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u001d\u0006!!.\u0019<b\u0013\t\u00016JA\u0005BeJ\f\u0017\u0010T5tiB\u0011qF\u0015\u0003\u0006c\u0019\u0011\rAM\u0001\rg&4G\u000fR8x]J{w\u000e\u001e\u000b\u0003+b\u0003\"\u0001\u0007,\n\u0005]K\"\u0001B+oSRDQ!W\u0004A\u0002i\u000b1!\u0019:s!\rYfAL\u0007\u0002\u0001\u00051\u0011N\\:feR$2A\u00170`\u0011\u0015I\u0006\u00021\u0001[\u0011\u0015\u0001\u0007\u00021\u0001/\u0003\u0011)G.Z7\u0002\u000b5,'oZ3\u0015\u0007i\u001bW\rC\u0003e\u0013\u0001\u0007!,\u0001\u0003beJ\f\u0004\"\u00024\n\u0001\u0004Q\u0016\u0001B1seJ\nAa]8siR\u0011!,\u001b\u0005\u00063*\u0001\rA\u0017")
public class MinHeap<T> {
    private final int maxSize;
    private final Ordering<T> ordering;
    private final Ordering<T> reverseComparator;

    private Ordering<T> reverseComparator() {
        return this.reverseComparator;
    }

    private final void siftDownRoot(ArrayList<T> arr) {
        int par = 0;
        int left = (par << 1) + 1;
        while (par >= 0 && left < arr.size()) {
            T parentVal;
            T rightVal;
            int candidate = left;
            T candidateVal = arr.get(left);
            int right = left + 1;
            if (right < arr.size() && this.ordering.lt(candidateVal, rightVal = arr.get(right))) {
                candidate = right;
                candidateVal = rightVal;
            }
            if (this.ordering.gteq(parentVal = arr.get(par), candidateVal)) {
                return;
            }
            arr.set(par, candidateVal);
            arr.set(candidate, parentVal);
            par = candidate;
            left = (par << 1) + 1;
        }
    }

    public ArrayList<T> insert(ArrayList<T> arr, T elem) {
        Boolean bl;
        if (arr.size() < this.maxSize - 1) {
            bl = BoxesRunTime.boxToBoolean((boolean)arr.add(elem));
        } else {
            if (arr.size() == this.maxSize - 1) {
                arr.add(elem);
                arr.sort((Comparator<T>)this.reverseComparator());
            } else if (arr.size() == this.maxSize && this.ordering.lteq(elem, arr.get(0))) {
                arr.set(0, elem);
                this.siftDownRoot(arr);
            }
            bl = BoxedUnit.UNIT;
        }
        return arr;
    }

    public ArrayList<T> merge(ArrayList<T> arr1, ArrayList<T> arr2) {
        Boolean bl;
        if (arr1.size() + arr2.size() < this.maxSize) {
            bl = BoxesRunTime.boxToBoolean((boolean)arr1.addAll(arr2));
        } else {
            Iterator<T> it = arr2.iterator();
            while (it.hasNext()) {
                this.insert(arr1, it.next());
            }
            bl = BoxedUnit.UNIT;
        }
        return arr1;
    }

    public ArrayList<T> sort(ArrayList<T> arr) {
        arr.sort((Comparator<T>)this.ordering);
        return arr;
    }

    public MinHeap(int maxSize, Ordering<T> ordering) {
        this.maxSize = maxSize;
        this.ordering = ordering;
        this.reverseComparator = ordering.reverse();
    }
}

