/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.flink.window;

import ai.chronon.api.DataType;
import ai.chronon.api.GroupBy;
import ai.chronon.flink.window.TimestampedIR;
import ai.chronon.flink.window.TimestampedTile;
import ai.chronon.online.TileCodec;
import java.util.Base64;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.scala.function.ProcessWindowFunction;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\t\u0012\u0001iA\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005'\")A\r\u0001C\u0001K\"Q\u0011\u000e\u0001a\u0001\u0002\u0004%\ta\u00056\t\u0015E\u0004\u0001\u0019!a\u0001\n\u0003\u0019\"\u000fC\u0005y\u0001\u0001\u0007\t\u0011)Q\u0005W\"AQ\u0010\u0001EC\u0002\u0013\u0005a\u0010C\u0006\u0002\u000e\u0001\u0001\r\u00111A\u0005\n\u0005=\u0001bCA\u000f\u0001\u0001\u0007\t\u0019!C\u0005\u0003?A1\"a\t\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0012!Y\u0011q\u0005\u0001A\u0002\u0003\u0007I\u0011BA\b\u0011-\tI\u0003\u0001a\u0001\u0002\u0004%I!a\u000b\t\u0017\u0005=\u0002\u00011A\u0001B\u0003&\u0011\u0011\u0003\u0005\b\u0003g\u0001A\u0011IA\u001b\u0011\u001d\t9\u0005\u0001C!\u0003\u0013\u0012!D\u00127j].\u0014vn^!hOB\u0013xnY3tg\u001a+hn\u0019;j_:T!AE\n\u0002\r]Lg\u000eZ8x\u0015\t!R#A\u0003gY&t7N\u0003\u0002\u0017/\u000591\r\u001b:p]>t'\"\u0001\r\u0002\u0005\u0005L7\u0001A\n\u0003\u0001m\u0001b\u0001\b\u0016-aM\"U\"A\u000f\u000b\u0005yy\u0012\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0005\u0001\n\u0013!B:dC2\f'B\u0001\u0012$\u0003\r\t\u0007/\u001b\u0006\u0003I\u0015\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005Q1#BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001eL!aK\u000f\u0003+A\u0013xnY3tg^Kg\u000eZ8x\rVt7\r^5p]B\u0011QFL\u0007\u0002#%\u0011q&\u0005\u0002\u000e)&lWm\u001d;b[B,G-\u0013*\u0011\u00055\n\u0014B\u0001\u001a\u0012\u0005=!\u0016.\\3ti\u0006l\u0007/\u001a3US2,\u0007c\u0001\u001b>\u0001:\u0011QG\u000f\b\u0003mej\u0011a\u000e\u0006\u0003qe\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0011\n\u0005mb\u0014a\u00029bG.\fw-\u001a\u0006\u0002A%\u0011ah\u0010\u0002\u0005\u0019&\u001cHO\u0003\u0002<yA\u0011\u0011IQ\u0007\u0002y%\u00111\t\u0010\u0002\u0004\u0003:L\bCA#K\u001b\u00051%BA$I\u0003\u001d9\u0018N\u001c3poNT!!S\u0011\u0002\u0013]Lg\u000eZ8xS:<\u0017BA&G\u0005)!\u0016.\\3XS:$wn^\u0001\bOJ|W\u000f\u001d\"z!\tq\u0005+D\u0001P\u0015\t\u0011S#\u0003\u0002R\u001f\n9qI]8va\nK\u0018aC5oaV$8k\u00195f[\u0006\u00042\u0001\u000e+W\u0013\t)vHA\u0002TKF\u0004B!Q,ZC&\u0011\u0001\f\u0010\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005isfBA.]!\t1D(\u0003\u0002^y\u00051\u0001K]3eK\u001aL!a\u00181\u0003\rM#(/\u001b8h\u0015\tiF\b\u0005\u0002OE&\u00111m\u0014\u0002\t\t\u0006$\u0018\rV=qK\u00061A(\u001b8jiz\"2AZ4i!\ti\u0003\u0001C\u0003M\u0007\u0001\u0007Q\nC\u0003S\u0007\u0001\u00071+A\u0005uS2,7i\u001c3fGV\t1\u000e\u0005\u0002m_6\tQN\u0003\u0002o+\u00051qN\u001c7j]\u0016L!\u0001]7\u0003\u0013QKG.Z\"pI\u0016\u001c\u0017!\u0004;jY\u0016\u001cu\u000eZ3d?\u0012*\u0017\u000f\u0006\u0002tmB\u0011\u0011\t^\u0005\u0003kr\u0012A!\u00168ji\"9q/BA\u0001\u0002\u0004Y\u0017a\u0001=%c\u0005QA/\u001b7f\u0007>$Wm\u0019\u0011)\u0005\u0019Q\bCA!|\u0013\taHHA\u0005ue\u0006t7/[3oi\u00061An\\4hKJ,\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0015\u0002\u000bMdg\r\u000e6\n\t\u0005%\u00111\u0001\u0002\u0007\u0019><w-\u001a:)\u0005\u001dQ\u0018!\u0007:poB\u0013xnY3tg&tw-\u0012:s_J\u001cu.\u001e8uKJ,\"!!\u0005\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006&\u0003\u001diW\r\u001e:jGNLA!a\u0007\u0002\u0016\t91i\\;oi\u0016\u0014\u0018!\b:poB\u0013xnY3tg&tw-\u0012:s_J\u001cu.\u001e8uKJ|F%Z9\u0015\u0007M\f\t\u0003\u0003\u0005x\u0013\u0005\u0005\t\u0019AA\t\u0003i\u0011xn\u001e)s_\u000e,7o]5oO\u0016\u0013(o\u001c:D_VtG/\u001a:!Q\tQ!0A\u000efm\u0016tG\u000f\u0015:pG\u0016\u001c8/\u001b8h\u000bJ\u0014xN]\"pk:$XM]\u0001 KZ,g\u000e\u001e)s_\u000e,7o]5oO\u0016\u0013(o\u001c:D_VtG/\u001a:`I\u0015\fHcA:\u0002.!Aq\u000fDA\u0001\u0002\u0004\t\t\"\u0001\u000ffm\u0016tG\u000f\u0015:pG\u0016\u001c8/\u001b8h\u000bJ\u0014xN]\"pk:$XM\u001d\u0011)\u00055Q\u0018\u0001B8qK:$2a]A\u001c\u0011\u001d\tID\u0004a\u0001\u0003w\t!\u0002]1sC6,G/\u001a:t!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!K\u0005i1m\u001c8gS\u001e,(/\u0019;j_:LA!!\u0012\u0002@\ti1i\u001c8gS\u001e,(/\u0019;j_:\fq\u0001\u001d:pG\u0016\u001c8\u000fF\u0005t\u0003\u0017\ny%a\u0017\u0002f!1\u0011QJ\bA\u0002M\nAa[3zg\"9\u0011\u0011K\bA\u0002\u0005M\u0013aB2p]R,\u0007\u0010\u001e\t\u0005\u0003+\n9&D\u0001\u0001\u0013\r\tIF\u000b\u0002\b\u0007>tG/\u001a=u\u0011\u001d\tif\u0004a\u0001\u0003?\n\u0001\"\u001a7f[\u0016tGo\u001d\t\u0005i\u0005\u0005D&C\u0002\u0002d}\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0003Oz\u0001\u0019AA5\u0003\ryW\u000f\u001e\t\u0006\u0003W\n\t\bM\u0007\u0003\u0003[R1!a\u001c&\u0003\u0011)H/\u001b7\n\t\u0005M\u0014Q\u000e\u0002\n\u0007>dG.Z2u_J\u0004")
public class FlinkRowAggProcessFunction
extends ProcessWindowFunction<TimestampedIR, TimestampedTile, List<Object>, TimeWindow> {
    private transient Logger logger;
    private final GroupBy groupBy;
    private final Seq<Tuple2<String, DataType>> inputSchema;
    private transient TileCodec tileCodec;
    private transient Counter rowProcessingErrorCounter;
    private transient Counter eventProcessingErrorCounter;
    private volatile transient boolean bitmap$trans$0;

    public TileCodec tileCodec() {
        return this.tileCodec;
    }

    public void tileCodec_$eq(TileCodec x$1) {
        this.tileCodec = x$1;
    }

    private Logger logger$lzycompute() {
        FlinkRowAggProcessFunction flinkRowAggProcessFunction = this;
        synchronized (flinkRowAggProcessFunction) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger((Class)this.getClass());
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private Counter rowProcessingErrorCounter() {
        return this.rowProcessingErrorCounter;
    }

    private void rowProcessingErrorCounter_$eq(Counter x$1) {
        this.rowProcessingErrorCounter = x$1;
    }

    private Counter eventProcessingErrorCounter() {
        return this.eventProcessingErrorCounter;
    }

    private void eventProcessingErrorCounter_$eq(Counter x$1) {
        this.eventProcessingErrorCounter = x$1;
    }

    public void open(Configuration parameters) {
        super.open(parameters);
        this.tileCodec_$eq(new TileCodec(this.groupBy, this.inputSchema));
        MetricGroup metricsGroup = this.getRuntimeContext().getMetricGroup().addGroup("chronon").addGroup("feature_group", this.groupBy.getMetaData().getName());
        this.rowProcessingErrorCounter_$eq(metricsGroup.counter("tiling_process_function_error"));
        this.eventProcessingErrorCounter_$eq(metricsGroup.counter("event_processing_error"));
    }

    public void process(List<Object> keys, ProcessWindowFunction.Context context, Iterable<TimestampedIR> elements, Collector<TimestampedTile> out) {
        boolean isComplete;
        long windowEnd = ((TimeWindow)context.window()).getEnd();
        TimestampedIR irEntry = (TimestampedIR)elements.head();
        Try tileBytes = Try$.MODULE$.apply(() -> FlinkRowAggProcessFunction.$anonfun$process$1(this, irEntry, isComplete = context.currentWatermark() >= windowEnd));
        Try try_ = tileBytes;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            byte[] v = (byte[])success.value();
            this.logger().debug(new StringBuilder(178).append(" \n                |Flink aggregator processed element irEntry=").append(irEntry).append("\n                |tileBytes=").append(Base64.getEncoder().encodeToString(v)).append("\n                |windowEnd=").append(windowEnd).append(" groupBy=").append(this.groupBy.getMetaData().getName()).append("\n                |keys=").append(keys).append(" isComplete=").append(isComplete).append(" tileAvroSchema=").append(this.tileCodec().tileAvroSchema()).toString());
            out.collect((Object)new TimestampedTile(keys, v, BoxesRunTime.unboxToLong((Object)irEntry.latestTsMillis().get())));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error("Flink process error making tile IR", e);
            this.eventProcessingErrorCounter().inc();
            this.rowProcessingErrorCounter().inc();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ byte[] $anonfun$process$1(FlinkRowAggProcessFunction $this, TimestampedIR irEntry$1, boolean isComplete$1) {
        return $this.tileCodec().makeTileIr(irEntry$1.ir(), isComplete$1);
    }

    public FlinkRowAggProcessFunction(GroupBy groupBy, Seq<Tuple2<String, DataType>> inputSchema) {
        this.groupBy = groupBy;
        this.inputSchema = inputSchema;
    }
}

