/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.online;

import ai.chronon.api.Constants;
import ai.chronon.online.Fetcher;
import ai.chronon.online.JavaRequest;
import ai.chronon.online.JavaResponse;
import ai.chronon.online.KVStore;
import ai.chronon.online.LoggableResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;

public class JavaFetcher {
    public static final Long DEFAULT_TIMEOUT = 10000L;
    Fetcher fetcher;

    public JavaFetcher(KVStore kVStore, String string, Long l, Consumer<LoggableResponse> consumer) {
        this.fetcher = new Fetcher(kVStore, string, l, consumer, false);
    }

    public JavaFetcher(KVStore kVStore, String string, Long l, Consumer<LoggableResponse> consumer, boolean bl) {
        this.fetcher = new Fetcher(kVStore, string, l, consumer, bl);
    }

    public JavaFetcher(KVStore kVStore, String string, Consumer<LoggableResponse> consumer) {
        this(kVStore, string, DEFAULT_TIMEOUT, consumer);
    }

    public JavaFetcher(KVStore kVStore, Consumer<LoggableResponse> consumer) {
        this(kVStore, Constants.ChrononMetadataKey(), DEFAULT_TIMEOUT, consumer);
    }

    public static List<JavaResponse> toJavaResponses(Seq<Fetcher.Response> seq) {
        ArrayList<JavaResponse> arrayList = new ArrayList<JavaResponse>(seq.size());
        Iterator iterator = seq.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new JavaResponse((Fetcher.Response)iterator.next()));
        }
        return arrayList;
    }

    private CompletableFuture<List<JavaResponse>> convertResponses(Future<Seq<Fetcher.Response>> future) {
        return FutureConverters.toJava(future).toCompletableFuture().thenApply(JavaFetcher::toJavaResponses);
    }

    private Seq<Fetcher.Request> convertJavaRequestList(List<JavaRequest> list, Boolean bl) {
        ArrayBuffer arrayBuffer = new ArrayBuffer();
        for (JavaRequest javaRequest : list) {
            Fetcher.Request request = javaRequest.toScalaRequest(bl);
            arrayBuffer.$plus$eq((Object)request);
        }
        return arrayBuffer.toSeq();
    }

    public CompletableFuture<List<JavaResponse>> fetchGroupBys(List<JavaRequest> list) {
        Future<Seq<Fetcher.Response>> future = this.fetcher.fetchGroupBys(this.convertJavaRequestList(list, true));
        return this.convertResponses(future);
    }

    public CompletableFuture<List<JavaResponse>> fetchJoin(List<JavaRequest> list) {
        Future<Seq<Fetcher.Response>> future = this.fetcher.fetchJoin(this.convertJavaRequestList(list, false));
        return this.convertResponses(future);
    }
}

