/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.online;

import ai.chronon.api.DataType;
import ai.chronon.online.SerializableFunction;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.StructMetaData;

public class ThriftDecoder
implements Serializable {
    public final DataType dataType;
    private final SerializableFunction<Object, Object> convertor;

    public ThriftDecoder(DataType dataType, SerializableFunction<Object, Object> serializableFunction) {
        this.dataType = dataType;
        this.convertor = serializableFunction;
    }

    public Object apply(Object object) {
        if (object == null) {
            return null;
        }
        return this.convertor.apply(object);
    }

    public static Map<? extends TFieldIdEnum, FieldMetaData> getMetaDataMap(String string) throws ClassNotFoundException {
        return FieldMetaData.getStructMetaDataMap((Class)new StructMetaData((byte)12, Class.forName((String)string)).structClass);
    }

    public static Object convertTimestamp(Object object) {
        return new Timestamp(((Instant)object).toEpochMilli());
    }

    public static Object convertDate(Object object) {
        return Date.valueOf((LocalDate)object);
    }

    public static Object convertEnum(Object object) {
        return object.toString();
    }

    public static Object convertBytes(Object object) {
        return ((ByteBuffer)object).array();
    }

    public static Object id(Object object) {
        return object;
    }

    public static SerializableFunction<Object, Object> wrapList(SerializableFunction<Object, Object> serializableFunction) {
        return object -> {
            List list = (List)object;
            return list.stream().map(serializableFunction).collect(Collectors.toList());
        };
    }

    public static SerializableFunction<Object, Object> wrapSet(SerializableFunction<Object, Object> serializableFunction) {
        return object -> {
            Set set = (Set)object;
            return set.stream().map(serializableFunction).collect(Collectors.toList());
        };
    }

    public static SerializableFunction<Object, Object> wrapMap(SerializableFunction<Object, Object> serializableFunction, SerializableFunction<Object, Object> serializableFunction2) {
        return object -> {
            Map map = (Map)object;
            HashMap hashMap = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                hashMap.put(serializableFunction.apply(entry.getKey()), serializableFunction2.apply(entry.getValue()));
            }
            return hashMap;
        };
    }

    public static SerializableFunction<Object, Object> coalesce(List<SerializableFunction<Object, Object>> list) {
        return object -> {
            Object[] objectArray = new Object[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                objectArray[i] = ((SerializableFunction)list.get(i)).apply(object);
            }
            return objectArray;
        };
    }
}

