/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.online;

import java.util.Objects;
import java.util.function.Function;
import scala.util.Try;

public abstract class JTry<V> {
    private JTry() {
    }

    public static <V> JTry<V> failure(Throwable throwable) {
        Objects.requireNonNull(throwable);
        return new Failure(throwable);
    }

    public static <V> JTry<V> success(V v) {
        Objects.requireNonNull(v);
        return new Success<V>(v);
    }

    public static <V> JTry<V> fromScala(Try<V> try_) {
        if (try_.isSuccess()) {
            return new Success<Object>(try_.get());
        }
        return new Failure((Throwable)try_.failed().get());
    }

    public abstract boolean isSuccess();

    public abstract Throwable getException();

    public abstract V getValue();

    public abstract <U> JTry<U> map(Function<? super V, ? extends U> var1);

    public Try<V> toScala() {
        if (this.isSuccess()) {
            try {
                return new scala.util.Success(this.getValue());
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Invalid try with isSuccess=True " + this);
            }
        }
        return new scala.util.Failure(this.getException());
    }

    private static class Success<V>
    extends JTry<V> {
        private final V value;

        public Success(V v) {
            this.value = v;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public Throwable getException() {
            throw new RuntimeException("Calling get exception on a successful object");
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public <U> JTry<U> map(Function<? super V, ? extends U> function) {
            Objects.requireNonNull(function);
            try {
                return JTry.success(function.apply(this.value));
            }
            catch (Throwable throwable) {
                return JTry.failure(throwable);
            }
        }
    }

    private static class Failure<V>
    extends JTry<V> {
        private final Throwable exception;

        public Failure(Throwable throwable) {
            this.exception = throwable;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }

        @Override
        public V getValue() {
            throw new RuntimeException(this.exception);
        }

        @Override
        public <U> JTry<U> map(Function<? super V, ? extends U> function) {
            Objects.requireNonNull(function);
            return JTry.failure(this.exception);
        }
    }
}

