/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.online;

import ai.chronon.api.Join;
import ai.chronon.online.ExternalSourceRegistry;
import ai.chronon.online.Fetcher;
import ai.chronon.online.FetcherResponseWithTs;
import ai.chronon.online.JavaRequest;
import ai.chronon.online.JavaResponse;
import ai.chronon.online.JavaSeriesStatsResponse;
import ai.chronon.online.JavaStatsRequest;
import ai.chronon.online.JavaStatsResponse;
import ai.chronon.online.KVStore;
import ai.chronon.online.LoggableResponse;
import ai.chronon.online.Metrics;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;

public class JavaFetcher {
    Fetcher fetcher;

    public JavaFetcher(KVStore kVStore, String string, Long l, Consumer<LoggableResponse> consumer, ExternalSourceRegistry externalSourceRegistry, String string2) {
        this.fetcher = new Fetcher(kVStore, string, l, consumer, false, externalSourceRegistry, string2);
    }

    public JavaFetcher(KVStore kVStore, String string, Long l, Consumer<LoggableResponse> consumer, ExternalSourceRegistry externalSourceRegistry) {
        this.fetcher = new Fetcher(kVStore, string, l, consumer, false, externalSourceRegistry, null);
    }

    public static List<JavaResponse> toJavaResponses(Seq<Fetcher.Response> seq) {
        ArrayList<JavaResponse> arrayList = new ArrayList<JavaResponse>(seq.size());
        Iterator iterator = seq.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new JavaResponse((Fetcher.Response)iterator.next()));
        }
        return arrayList;
    }

    private CompletableFuture<List<JavaResponse>> convertResponsesWithTs(Future<FetcherResponseWithTs> future, boolean bl, long l) {
        return FutureConverters.toJava(future).toCompletableFuture().thenApply(fetcherResponseWithTs -> {
            List<JavaResponse> list = JavaFetcher.toJavaResponses(fetcherResponseWithTs.responses());
            List<String> list2 = list.stream().map(javaResponse -> javaResponse.request.name).collect(Collectors.toList());
            this.instrument(list2, bl, "java.response_conversion.latency.millis", fetcherResponseWithTs.endTs());
            this.instrument(list2, bl, "java.overall.latency.millis", l);
            return list;
        });
    }

    public static List<JavaStatsResponse> toJavaStatsResponses(Seq<Fetcher.StatsResponse> seq) {
        ArrayList<JavaStatsResponse> arrayList = new ArrayList<JavaStatsResponse>(seq.size());
        Iterator iterator = seq.iterator();
        while (iterator.hasNext()) {
            arrayList.add(JavaFetcher.toJavaStatsResponse((Fetcher.StatsResponse)iterator.next()));
        }
        return arrayList;
    }

    public static JavaStatsResponse toJavaStatsResponse(Fetcher.StatsResponse statsResponse) {
        return new JavaStatsResponse(statsResponse);
    }

    public static JavaSeriesStatsResponse toJavaSeriesStatsResponse(Fetcher.SeriesStatsResponse seriesStatsResponse) {
        return new JavaSeriesStatsResponse(seriesStatsResponse);
    }

    private CompletableFuture<List<JavaStatsResponse>> convertStatsResponses(Future<Seq<Fetcher.StatsResponse>> future) {
        return FutureConverters.toJava(future).toCompletableFuture().thenApply(JavaFetcher::toJavaStatsResponses);
    }

    private Seq<Fetcher.Request> convertJavaRequestList(List<JavaRequest> list, boolean bl, long l) {
        ArrayBuffer arrayBuffer = new ArrayBuffer();
        for (JavaRequest javaRequest2 : list) {
            Fetcher.Request request = javaRequest2.toScalaRequest();
            arrayBuffer.$plus$eq((Object)request);
        }
        scala.collection.immutable.Seq seq = arrayBuffer.toSeq();
        this.instrument(list.stream().map(javaRequest -> javaRequest.name).collect(Collectors.toList()), bl, "java.request_conversion.latency.millis", l);
        return seq;
    }

    public CompletableFuture<List<JavaResponse>> fetchGroupBys(List<JavaRequest> list) {
        long l = System.currentTimeMillis();
        Seq<Fetcher.Request> seq = this.convertJavaRequestList(list, true, l);
        Future<FetcherResponseWithTs> future = this.fetcher.withTs(this.fetcher.fetchGroupBys(seq));
        return this.convertResponsesWithTs(future, true, l);
    }

    public CompletableFuture<List<JavaResponse>> fetchJoin(List<JavaRequest> list) {
        long l = System.currentTimeMillis();
        Seq<Fetcher.Request> seq = this.convertJavaRequestList(list, false, l);
        Future<FetcherResponseWithTs> future = this.fetcher.withTs(this.fetcher.fetchJoin(seq, (Option<Join>)Option.empty()));
        return this.convertResponsesWithTs(future, false, l);
    }

    private void instrument(List<String> list, boolean bl, String string, Long l) {
        long l2 = System.currentTimeMillis();
        for (String string2 : list) {
            Metrics.Context context = bl ? this.getGroupByContext(string2) : this.getJoinContext(string2);
            context.distribution(string, l2 - l);
        }
    }

    private Metrics.Context getJoinContext(String string) {
        return new Metrics.Context("join.fetch", string, null, null, false, null, null, null, null);
    }

    private Metrics.Context getGroupByContext(String string) {
        return new Metrics.Context("group_by.fetch", null, string, null, false, null, null, null, null);
    }

    public CompletableFuture<JavaSeriesStatsResponse> fetchStatsTimeseries(JavaStatsRequest javaStatsRequest) {
        Future<Fetcher.SeriesStatsResponse> future = this.fetcher.fetchStatsTimeseries(javaStatsRequest.toScalaRequest());
        return FutureConverters.toJava(future).toCompletableFuture().thenApply(JavaFetcher::toJavaSeriesStatsResponse);
    }

    public CompletableFuture<JavaSeriesStatsResponse> fetchLogStatsTimeseries(JavaStatsRequest javaStatsRequest) {
        Future<Fetcher.SeriesStatsResponse> future = this.fetcher.fetchLogStatsTimeseries(javaStatsRequest.toScalaRequest());
        return FutureConverters.toJava(future).toCompletableFuture().thenApply(JavaFetcher::toJavaSeriesStatsResponse);
    }

    public CompletableFuture<JavaSeriesStatsResponse> fetchConsistencyMetricsTimeseries(JavaStatsRequest javaStatsRequest) {
        Future<Fetcher.SeriesStatsResponse> future = this.fetcher.fetchConsistencyMetricsTimeseries(javaStatsRequest.toScalaRequest());
        return FutureConverters.toJava(future).toCompletableFuture().thenApply(JavaFetcher::toJavaSeriesStatsResponse);
    }
}

