/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.streaming;

import ai.chronon.aggregator.base.BottomK;
import ai.chronon.api.DataType;
import ai.chronon.api.UnknownType;
import ai.chronon.spark.stats.EditDistance$;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicListing;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TopicChecker$ {
    public static final TopicChecker$ MODULE$;

    static {
        new TopicChecker$();
    }

    public void topicShouldExist(String topic, String bootstrap) {
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrap);
        try {
            AdminClient adminClient = AdminClient.create((Properties)props);
            ListTopicsOptions options = new ListTopicsOptions();
            options.listInternal(true);
            ListTopicsResult topicsList = adminClient.listTopics(options);
            Map topicsResult = (Map)topicsList.namesToListings().get();
            if (topicsResult.containsKey(topic)) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found topic ", " in bootstrap ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, bootstrap})));
                return;
            }
            BottomK closestK = new BottomK((DataType)new UnknownType((Object)BoxedUnit.UNIT), 5, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.String$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class));
            ArrayList result = new ArrayList();
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(topicsResult.entrySet().iterator()).asScala()).map((Function1)new Serializable(topic){
                public static final long serialVersionUID = 0L;
                private final String topic$1;

                public final Tuple2<Object, String> apply(Map.Entry<String, TopicListing> topicListing) {
                    String existing = topicListing.getValue().name();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)((double)EditDistance$.MODULE$.betweenStrings(existing, this.topic$1).total() / (double)existing.length()))), (Object)existing);
                }
                {
                    this.topic$1 = topic$1;
                }
            }).foldLeft(result, (Function2)new Serializable(closestK){
                public static final long serialVersionUID = 0L;
                private final BottomK closestK$1;

                public final ArrayList<Tuple2<Object, String>> apply(ArrayList<Tuple2<Object, String>> cnt, Tuple2<Object, String> elem) {
                    return this.closestK$1.update(cnt, elem);
                }
                {
                    this.closestK$1 = closestK$1;
                }
            });
            closestK.finalize(result);
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                                      |Requested topic: ", " is not found in broker: ", ".\n                                      |Either the bootstrap is incorrect or the topic is. \n                                      |\n                                      | ------ Most similar topics are ------\n                                      |\n                                      |  ", "\n                                      |\n                                      | ------ End ------\n                                      |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, bootstrap, ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<Object, String> x$1) {
                    return (String)x$1._2();
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString("\n  ")})))).stripMargin());
        }
        catch (Exception exception) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to check for topic ", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, bootstrap})), exception);
        }
    }

    public void main(String[] args) {
        this.topicShouldExist(args[0], args[1]);
    }

    private TopicChecker$() {
        MODULE$ = this;
    }
}

