/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark;

import ai.chronon.spark.Extensions$;
import java.io.File;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LocalDataLoader$ {
    public static final LocalDataLoader$ MODULE$;

    static {
        new LocalDataLoader$();
    }

    public void writeTableFromFile(File file, String tableName, SparkSession session) {
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking table: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
        if (session.catalog().tableExists(tableName)) {
            return;
        }
        String extension = (String)Predef$.MODULE$.refArrayOps((Object[])file.getName().split("\\.")).last();
        if (((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"csv", "json", "jsonl"}))).contains((Object)extension)) {
            Dataset dataset;
            DataFrameReader reader = session.read().option("inferSchema", "true").option("mode", FailFastMode$.MODULE$.name());
            String string = extension;
            String string2 = "csv";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                dataset = reader.option("header", true).csv(file.getPath());
            } else {
                String string3 = extension;
                String string4 = "json";
                dataset = reader.option("multiLine", !(string3 != null ? !string3.equals(string4) : string4 != null)).option("allowComments", true).json(file.getPath());
            }
            Dataset df = dataset;
            StructType schema = df.schema();
            if (Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()).contains((Object)"ts")) {
                DataType dataType = schema.apply(schema.fieldIndex("ts")).dataType();
                StringType$ stringType$ = StringType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null)) {
                    df = df.withColumnRenamed("ts", "ts_string").withColumn("ts", functions$.MODULE$.unix_timestamp(functions$.MODULE$.col("ts_string")).$times((Object)BoxesRunTime.boxToInteger((int)1000))).drop("ts_string");
                }
            }
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading data from ", " into ", ". Sample data and schema shown below"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getPath(), tableName})));
            df.show(100);
            Predef$.MODULE$.println((Object)Extensions$.MODULE$.StructTypeOps(df.schema()).pretty());
            if (((SeqLike)df.schema().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField x$1) {
                    return x$1.name();
                }
            }, Seq$.MODULE$.canBuildFrom())).contains((Object)"ds")) {
                df.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ds"})).saveAsTable(tableName);
            } else {
                df.write().saveAsTable(tableName);
            }
            return;
        }
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to load file due to invalid extension from file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getPath()})));
    }

    public void loadData(File f, SparkSession session, Seq<String> namespaces) {
        Tuple2 tuple2;
        block4: {
            block3: {
                Tuple2 tuple22;
                String[] splits;
                Seq nsFields;
                block2: {
                    Predef$.MODULE$.assert(f.exists(), (Function0)new Serializable(f){
                        public static final long serialVersionUID = 0L;
                        private final File f$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Non existent file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.f$1.getPath()}));
                        }
                        {
                            this.f$1 = f$1;
                        }
                    });
                    nsFields = namespaces.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default"})) : namespaces;
                    splits = f.getName().split("\\.");
                    if (!f.isDirectory()) break block2;
                    Predef$.MODULE$.refArrayOps((Object[])f.listFiles()).foreach((Function1)new Serializable(f, session, namespaces){
                        public static final long serialVersionUID = 0L;
                        private final File f$1;
                        private final SparkSession session$1;
                        private final Seq namespaces$1;

                        public final void apply(File x$2) {
                            LocalDataLoader$.MODULE$.loadData(x$2, this.session$1, (Seq<String>)((Seq)this.namespaces$1.$colon$plus((Object)this.f$1.getName(), Seq$.MODULE$.canBuildFrom())));
                        }
                        {
                            this.f$1 = f$1;
                            this.session$1 = session$1;
                            this.namespaces$1 = namespaces$1;
                        }
                    });
                    break block3;
                }
                Tuple2 tuple23 = tuple2 = Predef$.MODULE$.refArrayOps((Object[])splits).size() == 2 ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nsFields), (Object)splits[0]) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(nsFields.$colon$plus((Object)splits[0], Seq$.MODULE$.canBuildFrom())), (Object)splits[1]);
                if (tuple2 == null) break block4;
                Seq ns = (Seq)tuple2._1();
                String table = (String)tuple2._2();
                Tuple2 tuple24 = tuple22 = new Tuple2((Object)ns, (Object)table);
                Seq ns2 = (Seq)tuple24._1();
                String table2 = (String)tuple24._2();
                String namespace = ns2.mkString("_");
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.getPath()})));
                Object object = session.catalog().databaseExists(namespace) ? BoxedUnit.UNIT : session.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE DATABASE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{namespace})));
                this.writeTableFromFile(f, new StringBuilder().append((Object)namespace).append((Object)".").append((Object)table2).toString(), session);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Seq<String> loadData$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private LocalDataLoader$() {
        MODULE$ = this;
    }
}

