/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark;

import ai.chronon.api.Constants$;
import ai.chronon.api.Extensions$;
import ai.chronon.api.Join;
import ai.chronon.spark.JoinUtils$;
import ai.chronon.spark.SemanticHashHiveMetadata;
import ai.chronon.spark.TableUtils;
import com.google.gson.Gson;
import java.util.HashMap;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.ScalaJavaConversions$;

public final class SemanticHashUtils$ {
    public static final SemanticHashUtils$ MODULE$;

    static {
        new SemanticHashUtils$();
    }

    public Tuple2<Seq<String>, Object> tablesToRecompute(Join joinConf, String outputTable, TableUtils tableUtils, boolean unsetSemanticHash) {
        return this.computeDiff(joinConf, outputTable, tableUtils, unsetSemanticHash, (Function3)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Map<String, String> oldSemanticHash, Map<String, String> newSemanticHash, Join join) {
                return SemanticHashUtils$.MODULE$.tableHashesChanged(oldSemanticHash, newSemanticHash, join);
            }
        }, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public Tuple2<Object, Object> shouldRecomputeLeft(Join joinConf, String outputTable, TableUtils tableUtils, boolean unsetSemanticHash) {
        return this.computeDiff(joinConf, outputTable, tableUtils, unsetSemanticHash, (Function3)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Map<String, String> oldSemanticHash, Map<String, String> newSemanticHash, Join join) {
                return SemanticHashUtils$.MODULE$.ai$chronon$spark$SemanticHashUtils$$isLeftHashChanged(oldSemanticHash, newSemanticHash, join);
            }
        }, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        });
    }

    private boolean canAutoArchive(SemanticHashHiveMetadata semanticHashHiveMetadata) {
        return semanticHashHiveMetadata.excludeTopic();
    }

    private <T> Tuple2<T, Object> computeDiff(Join joinConf, String outputTable, TableUtils tableUtils, boolean unsetSemanticHash, Function3<Map<String, String>, Map<String, String>, Join, T> computeDiffFunc, Function0<T> emptyFunc) {
        Tuple2 tuple2;
        if (unsetSemanticHash) {
            JoinUtils$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Semantic hash has been unset for table ", ". Proceed to computation and table creation."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputTable})));
            return new Tuple2(emptyFunc.apply(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        Option<SemanticHashHiveMetadata> semanticHashHiveMetadata = this.getSemanticHashFromHive(outputTable, tableUtils);
        if (semanticHashHiveMetadata.isDefined()) {
            Map<String, String> oldSemanticHash = ((SemanticHashHiveMetadata)semanticHashHiveMetadata.get()).semanticHash();
            Map newSemanticHash = Extensions$.MODULE$.JoinOps(joinConf).semanticHash(((SemanticHashHiveMetadata)semanticHashHiveMetadata.get()).excludeTopic());
            JoinUtils$.MODULE$.logger().info(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Comparing Hashes:\n           |Hive Flag:\n           |", ": ", "\n           |Old Hashes:\n           |", "\n           |New Hashes:\n           |", "\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Constants$.MODULE$.SemanticHashExcludeTopic(), BoxesRunTime.boxToBoolean((boolean)((SemanticHashHiveMetadata)semanticHashHiveMetadata.get()).excludeTopic()), this.prettyPrintMap$1(oldSemanticHash), this.prettyPrintMap$1(newSemanticHash)})))).stripMargin());
            Object diff = computeDiffFunc.apply(oldSemanticHash, (Object)newSemanticHash, (Object)joinConf);
            boolean autoArchive = this.canAutoArchive((SemanticHashHiveMetadata)semanticHashHiveMetadata.get());
            tuple2 = new Tuple2(diff, (Object)BoxesRunTime.boxToBoolean((boolean)autoArchive));
        } else {
            JoinUtils$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No semantic hash found in table ", ". Proceed to computation and table creation."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputTable})));
            tuple2 = new Tuple2(emptyFunc.apply(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        return tuple2;
    }

    private Option<SemanticHashHiveMetadata> getSemanticHashFromHive(String outputTable, TableUtils tableUtils) {
        Gson gson = new Gson();
        Option<Map<String, String>> tablePropsOpt = tableUtils.getTableProperties(outputTable);
        Option oldSemanticJsonOpt = tablePropsOpt.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(Map<String, String> x$1) {
                return x$1.get((Object)Constants$.MODULE$.SemanticHashKey());
            }
        });
        Option oldSemanticHash = oldSemanticJsonOpt.map((Function1)new Serializable(gson){
            public static final long serialVersionUID = 0L;
            private final Gson gson$1;

            public final Map<String, String> apply(String json) {
                return ScalaJavaConversions$.MODULE$.MapOps((java.util.Map)this.gson$1.fromJson(json, HashMap.class)).toScala();
            }
            {
                this.gson$1 = gson$1;
            }
        });
        Map oldSemanticHashOptions = (Map)tablePropsOpt.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(Map<String, String> x$2) {
                return x$2.get((Object)Constants$.MODULE$.SemanticHashOptionsKey());
            }
        }).map((Function1)new Serializable(gson){
            public static final long serialVersionUID = 0L;
            private final Gson gson$1;

            public final Map<String, String> apply(String m) {
                return ScalaJavaConversions$.MODULE$.MapOps((java.util.Map)this.gson$1.fromJson(m, HashMap.class)).toScala();
            }
            {
                this.gson$1 = gson$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, Nothing$> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        });
        boolean hasSemanticHashExcludeTopicFlag = oldSemanticHashOptions.get((Object)Constants$.MODULE$.SemanticHashExcludeTopic()).contains((Object)"true");
        return oldSemanticHash.map((Function1)new Serializable(hasSemanticHashExcludeTopicFlag){
            public static final long serialVersionUID = 0L;
            private final boolean hasSemanticHashExcludeTopicFlag$1;

            public final SemanticHashHiveMetadata apply(Map<String, String> hashes) {
                return new SemanticHashHiveMetadata(hashes, this.hasSemanticHashExcludeTopicFlag$1);
            }
            {
                this.hasSemanticHashExcludeTopicFlag$1 = hasSemanticHashExcludeTopicFlag$1;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public boolean ai$chronon$spark$SemanticHashUtils$$isLeftHashChanged(Map<String, String> oldSemanticHash, Map<String, String> newSemanticHash, Join join) {
        if (!oldSemanticHash.contains((Object)Extensions$.MODULE$.MetadataOps(join.metaData).bootstrapTable())) ** GOTO lbl-1000
        v0 = oldSemanticHash.get((Object)Extensions$.MODULE$.MetadataOps(join.metaData).bootstrapTable());
        var5_4 = newSemanticHash.get((Object)Extensions$.MODULE$.MetadataOps(join.metaData).bootstrapTable());
        if (v0 == null ? var5_4 != null : v0.equals(var5_4) == false) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        bootstrapExistsAndChanged = v1;
        JoinUtils$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bootstrap table changed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)bootstrapExistsAndChanged)})));
        v2 = oldSemanticHash.get((Object)Extensions$.MODULE$.JoinOps(join).leftSourceKey());
        var6_6 = newSemanticHash.get((Object)Extensions$.MODULE$.JoinOps(join).leftSourceKey());
        return (v2 != null ? v2.equals(var6_6) == false : var6_6 != null) || bootstrapExistsAndChanged != false;
    }

    public Seq<String> tableHashesChanged(Map<String, String> oldSemanticHash, Map<String, String> newSemanticHash, Join join) {
        Seq seq;
        if (this.ai$chronon$spark$SemanticHashUtils$$isLeftHashChanged(oldSemanticHash, newSemanticHash, join)) {
            seq = this.partHashes$1(oldSemanticHash, join).keys().toSeq();
        } else {
            scala.collection.immutable.Iterable changed = (scala.collection.immutable.Iterable)this.partHashes$1(newSemanticHash, join).flatMap((Function1)new Serializable(oldSemanticHash){
                public static final long serialVersionUID = 0L;
                private final Map oldSemanticHash$1;

                public final Iterable<String> apply(Tuple2<String, String> x0$3) {
                    Tuple2<String, String> tuple2 = x0$3;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        String newVal = (String)tuple2._2();
                        Iterable iterable = Option$.MODULE$.option2Iterable(this.oldSemanticHash$1.get((Object)key).filter((Function1)new Serializable(this, newVal){
                            public static final long serialVersionUID = 0L;
                            private final String newVal$1;

                            public final boolean apply(String x$3) {
                                String string = x$3;
                                String string2 = this.newVal$1;
                                return string != null ? !string.equals(string2) : string2 != null;
                            }
                            {
                                this.newVal$1 = newVal$1;
                            }
                        }).map((Function1)new Serializable(this, key){
                            public static final long serialVersionUID = 0L;
                            private final String key$1;

                            public final String apply(String x$4) {
                                return this.key$1;
                            }
                            {
                                this.key$1 = key$1;
                            }
                        }));
                        return iterable;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.oldSemanticHash$1 = oldSemanticHash$1;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            Iterable deleted = (Iterable)this.partHashes$1(oldSemanticHash, join).keys().filterNot((Function1)new Serializable(newSemanticHash){
                public static final long serialVersionUID = 0L;
                private final Map newSemanticHash$1;

                public final boolean apply(String key) {
                    return this.newSemanticHash$1.contains((Object)key);
                }
                {
                    this.newSemanticHash$1 = newSemanticHash$1;
                }
            });
            seq = ((TraversableOnce)changed.$plus$plus((GenTraversableOnce)deleted, Iterable$.MODULE$.canBuildFrom())).toSeq();
        }
        Seq partsToDrop = seq;
        Iterable added = (Iterable)((TraversableLike)newSemanticHash.keys().filter((Function1)new Serializable(oldSemanticHash){
            public static final long serialVersionUID = 0L;
            private final Map oldSemanticHash$1;

            public final boolean apply(String x$5) {
                return !this.oldSemanticHash$1.contains((Object)x$5);
            }
            {
                this.oldSemanticHash$1 = oldSemanticHash$1;
            }
        })).filter((Function1)new Serializable(join){
            public static final long serialVersionUID = 0L;
            private final Join join$1;

            public final boolean apply(String x0$4) {
                String string;
                String string2 = string = x0$4;
                String string3 = Extensions$.MODULE$.MetadataOps(this.join$1.metaData).bootstrapTable();
                boolean bl = !(string2 != null ? !string2.equals(string3) : string3 != null) ? this.join$1.isSetBootstrapParts() && !this.join$1.bootstrapParts.isEmpty() : true;
                return bl;
            }
            {
                this.join$1 = join$1;
            }
        });
        Option option = oldSemanticHash.get((Object)Extensions$.MODULE$.JoinOps(join).derivedKey());
        Option option2 = newSemanticHash.get((Object)Extensions$.MODULE$.JoinOps(join).derivedKey());
        boolean derivedChanges = option != null ? !option.equals(option2) : option2 != null;
        Some mainTable = partsToDrop.nonEmpty() || added.nonEmpty() || derivedChanges ? new Some((Object)Extensions$.MODULE$.MetadataOps(join.metaData).outputTable()) : None$.MODULE$;
        return (Seq)partsToDrop.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)mainTable), Seq$.MODULE$.canBuildFrom());
    }

    private final String prettyPrintMap$1(Map map) {
        return ((TraversableOnce)((TraversableLike)map.toSeq().sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"- ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private final Map partHashes$1(Map semanticHashMap, Join join$1) {
        return (Map)semanticHashMap.filter((Function1)new Serializable(join$1){
            public static final long serialVersionUID = 0L;
            private final Join join$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Tuple2<String, String> x0$2) {
                String name;
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 == null) throw new MatchError(tuple2);
                String string = name = (String)tuple2._1();
                String string2 = Extensions$.MODULE$.JoinOps(this.join$1).leftSourceKey();
                if (string == null) {
                    if (string2 == null) return false;
                } else if (string.equals(string2)) return false;
                String string3 = name;
                String string4 = Extensions$.MODULE$.JoinOps(this.join$1).derivedKey();
                if (string3 != null) {
                    if (!string3.equals(string4)) return true;
                    return false;
                }
                if (string4 == null) return false;
                return true;
            }
            {
                this.join$1 = join$1;
            }
        });
    }

    private SemanticHashUtils$() {
        MODULE$ = this;
    }
}

