/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.stats;

import ai.chronon.api.Constants$;
import ai.chronon.api.DataModel$;
import ai.chronon.api.Extensions$;
import ai.chronon.api.Join;
import ai.chronon.api.PartitionSpec;
import ai.chronon.api.StagingQuery;
import ai.chronon.online.DataMetrics;
import ai.chronon.online.SparkConversions$;
import ai.chronon.spark.Analyzer;
import ai.chronon.spark.Analyzer$;
import ai.chronon.spark.PartitionRange;
import ai.chronon.spark.StagingQuery$;
import ai.chronon.spark.TableUtils;
import ai.chronon.spark.stats.CompareBaseJob$;
import ai.chronon.spark.stats.CompareJob$;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.ScalaVersionSpecificCollectionsConverter$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u000e\u001d\u0001\u0015B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!Y\u0005A!A!\u0002\u0013\u0001\u0005\"\u0002'\u0001\t\u0003i\u0005bB+\u0001\u0005\u0004%\tA\u0016\u0005\u00075\u0002\u0001\u000b\u0011B,\t\u000fm\u0003!\u0019!C\u00019\"1A\r\u0001Q\u0001\nuCq!\u001a\u0001C\u0002\u0013\u0005a\r\u0003\u0004h\u0001\u0001\u0006I\u0001\u0011\u0005\bQ\u0002\u0011\r\u0011\"\u0001g\u0011\u0019I\u0007\u0001)A\u0005\u0001\"9!\u000e\u0001b\u0001\n\u00031\u0007BB6\u0001A\u0003%\u0001\tC\u0004m\u0001\t\u0007I\u0011\u00014\t\r5\u0004\u0001\u0015!\u0003A\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u001d\ty\u0002\u0001C\u0001\u0003CAq!!\u000e\u0001\t\u0003\t9dB\u0004\u0002@qA\t!!\u0011\u0007\rma\u0002\u0012AA\"\u0011\u0019au\u0003\"\u0001\u0002F!9\u0011qI\f\u0005\u0002\u0005%\u0003\"CA6/\u0005\u0005I\u0011BA7\u0005)\u0019u.\u001c9be\u0016TuN\u0019\u0006\u0003;y\tQa\u001d;biNT!a\b\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0005\u0012\u0013aB2ie>twN\u001c\u0006\u0002G\u0005\u0011\u0011-[\u0002\u0001'\r\u0001a\u0005\f\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dj\u0013B\u0001\u0018)\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003)!\u0018M\u00197f+RLGn\u001d\t\u0003cIj\u0011AH\u0005\u0003gy\u0011!\u0002V1cY\u0016,F/\u001b7t\u0003!Qw.\u001b8D_:4\u0007C\u0001\u001c:\u001b\u00059$B\u0001\u001d!\u0003\r\t\u0007/[\u0005\u0003u]\u0012AAS8j]\u0006\u00012\u000f^1hS:<\u0017+^3ss\u000e{gN\u001a\t\u0003muJ!AP\u001c\u0003\u0019M#\u0018mZ5oOF+XM]=\u0002\u0013M$\u0018M\u001d;ECR,\u0007CA!I\u001d\t\u0011e\t\u0005\u0002DQ5\tAI\u0003\u0002FI\u00051AH]8pizJ!a\u0012\u0015\u0002\rA\u0013X\rZ3g\u0013\tI%J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000f\"\nq!\u001a8e\t\u0006$X-\u0001\u0004=S:LGO\u0010\u000b\u0007\u001dB\u000b&k\u0015+\u0011\u0005=\u0003Q\"\u0001\u000f\t\u000b=2\u0001\u0019\u0001\u0019\t\u000bQ2\u0001\u0019A\u001b\t\u000bm2\u0001\u0019\u0001\u001f\t\u000b}2\u0001\u0019\u0001!\t\u000b-3\u0001\u0019\u0001!\u0002\u0015Q\f'\r\\3Qe>\u00048/F\u0001X!\u0011\t\u0005\f\u0011!\n\u0005eS%aA'ba\u0006YA/\u00192mKB\u0013x\u000e]:!\u0003%q\u0017-\\3ta\u0006\u001cW-F\u0001^!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0003mC:<'\"\u00012\u0002\t)\fg/Y\u0005\u0003\u0013~\u000b!B\\1nKN\u0004\u0018mY3!\u0003!Qw.\u001b8OC6,W#\u0001!\u0002\u0013)|\u0017N\u001c(b[\u0016\u0004\u0013\u0001E:uC\u001eLgnZ)vKJLh*Y7f\u0003E\u0019H/Y4j]\u001e\fV/\u001a:z\u001d\u0006lW\rI\u0001\u0014G>l\u0007/\u0019:jg>tG+\u00192mK:\u000bW.Z\u0001\u0015G>l\u0007/\u0019:jg>tG+\u00192mK:\u000bW.\u001a\u0011\u0002!5,GO]5dgR\u000b'\r\\3OC6,\u0017!E7fiJL7m\u001d+bE2,g*Y7fA\u0005\u0019!/\u001e8\u0015\u0003A\u0004baJ9tg\u0006M\u0011B\u0001:)\u0005\u0019!V\u000f\u001d7fgA\u0019A/!\u0004\u000f\u0007U\f9AD\u0002w\u0003\u0003q!a\u001e@\u000f\u0005a\\hBA\"z\u0013\u0005Q\u0018aA8sO&\u0011A0`\u0001\u0007CB\f7\r[3\u000b\u0003iL!aH@\u000b\u0005ql\u0018\u0002BA\u0002\u0003\u000b\t1a]9m\u0015\tyr0\u0003\u0003\u0002\n\u0005-\u0011a\u00029bG.\fw-\u001a\u0006\u0005\u0003\u0007\t)!\u0003\u0003\u0002\u0010\u0005E!!\u0003#bi\u00064%/Y7f\u0015\u0011\tI!a\u0003\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007!\u0003\u0019yg\u000e\\5oK&!\u0011QDA\f\u0005-!\u0015\r^1NKR\u0014\u0018nY:\u0002\u0017\u001d,GOS8j].+\u0017p\u001d\u000b\u0005\u0003G\t\u0019\u0004E\u0003\u0002&\u00055\u0002I\u0004\u0003\u0002(\u0005-bbA\"\u0002*%\t\u0011&C\u0002\u0002\n!JA!a\f\u00022\t\u00191+Z9\u000b\u0007\u0005%\u0001\u0006C\u00035)\u0001\u0007Q'\u0001\u0005wC2LG-\u0019;f)\t\tI\u0004E\u0002(\u0003wI1!!\u0010)\u0005\u0011)f.\u001b;\u0002\u0015\r{W\u000e]1sK*{'\r\u0005\u0002P/M\u0019qC\n\u0017\u0015\u0005\u0005\u0005\u0013a\u00069sS:$\u0018I\u001c3HKR\u0014\u0015m]5d\u001b\u0016$(/[2t)\u0019\tY%!\u0018\u0002bA1\u0011QEA'\u0003#JA!a\u0014\u00022\t!A*[:u!\u00199\u00131\u000b!\u0002X%\u0019\u0011Q\u000b\u0015\u0003\rQ+\b\u000f\\33!\r9\u0013\u0011L\u0005\u0004\u00037B#\u0001\u0002'p]\u001eDq!a\u0018\u001a\u0001\u0004\t\u0019\"A\u0004nKR\u0014\u0018nY:\t\u000f\u0005\r\u0014\u00041\u0001\u0002f\u0005i\u0001/\u0019:uSRLwN\\*qK\u000e\u00042ANA4\u0013\r\tIg\u000e\u0002\u000e!\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003_\u00022AXA9\u0013\r\t\u0019h\u0018\u0002\u0007\u001f\nTWm\u0019;")
public class CompareJob
implements scala.Serializable {
    private final TableUtils tableUtils;
    private final Join joinConf;
    private final StagingQuery stagingQueryConf;
    private final String startDate;
    private final String endDate;
    private final Map<String, String> tableProps;
    private final String namespace;
    private final String joinName;
    private final String stagingQueryName;
    private final String comparisonTableName;
    private final String metricsTableName;

    public static List<Tuple2<String, Object>> printAndGetBasicMetrics(DataMetrics dataMetrics, PartitionSpec partitionSpec) {
        return CompareJob$.MODULE$.printAndGetBasicMetrics(dataMetrics, partitionSpec);
    }

    public Map<String, String> tableProps() {
        return this.tableProps;
    }

    public String namespace() {
        return this.namespace;
    }

    public String joinName() {
        return this.joinName;
    }

    public String stagingQueryName() {
        return this.stagingQueryName;
    }

    public String comparisonTableName() {
        return this.comparisonTableName;
    }

    public String metricsTableName() {
        return this.metricsTableName;
    }

    public Tuple3<Dataset<Row>, Dataset<Row>, DataMetrics> run() {
        Dataset dataset;
        Dataset dataset2;
        DataMetrics metrics;
        block3: {
            Tuple3<Dataset<Row>, Dataset<Row>, DataMetrics> tuple3;
            block2: {
                Predef$.MODULE$.assert(this.endDate != null, (Function0 & Serializable & scala.Serializable)() -> "End date for the comparison should not be null");
                this.validate();
                PartitionRange partitionRange = new PartitionRange(this.startDate, this.endDate, this.tableUtils);
                Dataset<Row> leftDf = this.tableUtils.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n        |SELECT *\n        |FROM ").append(Extensions$.MODULE$.MetadataOps(this.joinConf.metaData).outputTable()).append("\n        |WHERE ").append(partitionRange.betweenClauses()).append("\n        |").toString())).stripMargin());
                Dataset<Row> rightDf = this.tableUtils.sql(StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate));
                Dataset<Row> x$1 = leftDf;
                Dataset<Row> x$2 = rightDf;
                Seq<String> x$3 = this.getJoinKeys(this.joinConf);
                TableUtils x$4 = this.tableUtils;
                boolean x$5 = true;
                Map<String, String> x$6 = CompareBaseJob$.MODULE$.compare$default$5();
                tuple3 = CompareBaseJob$.MODULE$.compare(x$1, x$2, x$3, x$4, x$6, x$5);
                if (tuple3 == null) break block2;
                Dataset compareDf = (Dataset)tuple3._1();
                Dataset metricsDf = (Dataset)tuple3._2();
                metrics = (DataMetrics)tuple3._3();
                if (compareDf == null) break block2;
                dataset2 = compareDf;
                if (metricsDf == null) break block2;
                dataset = metricsDf;
                if (metrics != null) break block3;
            }
            throw new MatchError(tuple3);
        }
        DataMetrics dataMetrics = metrics;
        Tuple3 tuple3 = new Tuple3((Object)dataset2, (Object)dataset, (Object)dataMetrics);
        Tuple3 tuple32 = tuple3;
        Dataset compareDf = (Dataset)tuple32._1();
        Dataset metricsDf = (Dataset)tuple32._2();
        DataMetrics metrics2 = (DataMetrics)tuple32._3();
        Predef$.MODULE$.println((Object)"Saving comparison output..");
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("Comparison schema ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compareDf.schema().fields())).map((Function1 & Serializable & scala.Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()).mkString("\n - ")).toString());
        this.tableUtils.insertUnPartitioned((Dataset<Row>)compareDf, this.comparisonTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
        Predef$.MODULE$.println((Object)"Saving metrics output..");
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("Metrics schema ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metricsDf.schema().fields())).map((Function1 & Serializable & scala.Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()).mkString("\n - ")).toString());
        this.tableUtils.insertUnPartitioned((Dataset<Row>)metricsDf, this.metricsTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
        Predef$.MODULE$.println((Object)"Printing basic comparison results..");
        Predef$.MODULE$.println((Object)"(Note: This is just an estimation and not a detailed analysis of results)");
        CompareJob$.MODULE$.printAndGetBasicMetrics(metrics2, this.tableUtils.partitionSpec());
        Predef$.MODULE$.println((Object)"Finished compare stats.");
        return new Tuple3((Object)compareDf, (Object)metricsDf, (Object)metrics2);
    }

    public Seq<String> getJoinKeys(Join joinConf) {
        List list;
        if (joinConf.isSetRowIds()) {
            list = ScalaVersionSpecificCollectionsConverter$.MODULE$.convertJavaListToScala(joinConf.rowIds);
        } else {
            String[] keyCols = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Extensions$.MODULE$.JoinOps(joinConf).leftKeyCols())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)this.tableUtils.partitionColumn(), (List)Nil$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            Enumeration.Value value = Extensions$.MODULE$.SourceOps(joinConf.left).dataModel();
            Enumeration.Value value2 = DataModel$.MODULE$.Events();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                keyCols = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyCols)).$plus$plus((GenTraversableOnce)new .colon.colon((Object)Constants$.MODULE$.TimeColumn(), (List)Nil$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
            list = Predef$.MODULE$.wrapRefArray((Object[])keyCols);
        }
        return list;
    }

    public void validate() {
        TableUtils x$1 = this.tableUtils;
        Join x$2 = this.joinConf;
        String x$3 = this.startDate;
        String x$4 = this.endDate;
        boolean x$5 = false;
        int x$6 = Analyzer$.MODULE$.$lessinit$greater$default$5();
        double x$7 = Analyzer$.MODULE$.$lessinit$greater$default$6();
        boolean x$8 = Analyzer$.MODULE$.$lessinit$greater$default$8();
        Analyzer analyzer = new Analyzer(x$1, x$2, x$3, x$4, x$6, x$7, x$5, x$8);
        Map joinChrononSchema = (Map)analyzer.analyzeJoin(this.joinConf, false)._1();
        Map joinSchema = ((Map)joinChrononSchema.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            ai.chronon.api.DataType v = (ai.chronon.api.DataType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)SparkConversions$.MODULE$.fromChrononType(v));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        String finalStagingQuery = StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate);
        Map stagingQuerySchema = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableUtils.sql(new StringBuilder(8).append(finalStagingQuery).append(" LIMIT 1").toString()).schema().fields())).map((Function1 & Serializable & scala.Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Map x$9 = joinSchema;
        Map x$10 = stagingQuerySchema;
        Seq<String> x$11 = this.getJoinKeys(this.joinConf);
        TableUtils x$12 = this.tableUtils;
        boolean x$13 = true;
        Map<String, String> x$14 = CompareBaseJob$.MODULE$.checkConsistency$default$5();
        CompareBaseJob$.MODULE$.checkConsistency((Map<String, DataType>)x$9, (Map<String, DataType>)x$10, x$11, x$12, x$14, x$13);
    }

    public CompareJob(TableUtils tableUtils, Join joinConf, StagingQuery stagingQueryConf, String startDate, String endDate) {
        this.tableUtils = tableUtils;
        this.joinConf = joinConf;
        this.stagingQueryConf = stagingQueryConf;
        this.startDate = startDate;
        this.endDate = endDate;
        this.tableProps = (Map)Option$.MODULE$.apply((Object)joinConf.metaData.tableProperties).map((Function1 & Serializable & scala.Serializable)x$1 -> ScalaVersionSpecificCollectionsConverter$.MODULE$.convertJavaMapToScala(x$1).toMap(Predef$.MODULE$.$conforms())).orNull(Predef$.MODULE$.$conforms());
        this.namespace = joinConf.metaData.outputNamespace;
        this.joinName = Extensions$.MODULE$.MetadataOps(joinConf.metaData).cleanName();
        this.stagingQueryName = Extensions$.MODULE$.MetadataOps(stagingQueryConf.metaData).cleanName();
        this.comparisonTableName = new StringBuilder(21).append(this.namespace()).append(".compare_join_query_").append(this.joinName()).append("_").append(this.stagingQueryName()).toString();
        this.metricsTableName = new StringBuilder(27).append(this.namespace()).append(".compare_stats_join_query_").append(this.joinName()).append("_").append(this.stagingQueryName()).toString();
    }
}

