/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.streaming;

import ai.chronon.online.KVStore;
import com.yahoo.sketches.kll.KllFloatsSketch;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.apache.commons.io.FileUtils;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u000e\u001d\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\tc\u0001\u0011\t\u0011)A\u0005]!)!\u0007\u0001C\u0001g!9q\u0007\u0001a\u0001\n\u0013A\u0004bB#\u0001\u0001\u0004%IA\u0012\u0005\u0007\u0019\u0002\u0001\u000b\u0015B\u001d\t\u000f5\u0003\u0001\u0019!C\u0005\u001d\"9!\u000b\u0001a\u0001\n\u0013\u0019\u0006BB+\u0001A\u0003&q\nC\u0004W\u0001\u0001\u0007I\u0011\u0002(\t\u000f]\u0003\u0001\u0019!C\u00051\"1!\f\u0001Q!\n=Cqa\u0017\u0001A\u0002\u0013%a\nC\u0004]\u0001\u0001\u0007I\u0011B/\t\r}\u0003\u0001\u0015)\u0003P\u0011\u001d\u0001\u0007\u00011A\u0005\n9Cq!\u0019\u0001A\u0002\u0013%!\r\u0003\u0004e\u0001\u0001\u0006Ka\u0014\u0005\bK\u0002\u0001\r\u0011\"\u0003O\u0011\u001d1\u0007\u00011A\u0005\n\u001dDa!\u001b\u0001!B\u0013y\u0005b\u00026\u0001\u0005\u0004%Ia\u001b\u0005\u0007m\u0002\u0001\u000b\u0011\u00027\t\u000b]\u0004A\u0011\u0002=\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!9\u00111\u0002\u0001\u0005\u0002\u00055!AD*ue\u0016\fW.\u001b8h'R\fGo\u001d\u0006\u0003;y\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005}\u0001\u0013!B:qCJ\\'BA\u0011#\u0003\u001d\u0019\u0007N]8o_:T\u0011aI\u0001\u0003C&\u001c\u0001a\u0005\u0002\u0001MA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t1\u0011I\\=SK\u001a\f1\u0003];cY&\u001c\b\u000eR3mCf\u001cVmY8oIN,\u0012A\f\t\u0003O=J!\u0001\r\u0015\u0003\u0007%sG/\u0001\u000bqk\nd\u0017n\u001d5EK2\f\u0017pU3d_:$7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005Q2\u0004CA\u001b\u0001\u001b\u0005a\u0002\"\u0002\u0017\u0004\u0001\u0004q\u0013\u0001\u00057bi\u0016t7-\u001f%jgR|wM]1n+\u0005I\u0004C\u0001\u001eD\u001b\u0005Y$B\u0001\u001f>\u0003\rYG\u000e\u001c\u0006\u0003}}\n\u0001b]6fi\u000eDWm\u001d\u0006\u0003\u0001\u0006\u000bQ!_1i_>T\u0011AQ\u0001\u0004G>l\u0017B\u0001#<\u0005=YE\u000e\u001c$m_\u0006$8oU6fi\u000eD\u0017\u0001\u00067bi\u0016t7-\u001f%jgR|wM]1n?\u0012*\u0017\u000f\u0006\u0002H\u0015B\u0011q\u0005S\u0005\u0003\u0013\"\u0012A!\u00168ji\"91*BA\u0001\u0002\u0004I\u0014a\u0001=%c\u0005\tB.\u0019;f]\u000eL\b*[:u_\u001e\u0014\u0018-\u001c\u0011\u0002\u001d1\fG/\u001a8ds6\u001bHk\u001c;bYV\tq\n\u0005\u0002(!&\u0011\u0011\u000b\u000b\u0002\u0005\u0019>tw-\u0001\nmCR,gnY=NgR{G/\u00197`I\u0015\fHCA$U\u0011\u001dY\u0005\"!AA\u0002=\u000bq\u0002\\1uK:\u001c\u00170T:U_R\fG\u000eI\u0001\foJLG/Z:U_R\fG.A\bxe&$Xm\u001d+pi\u0006dw\fJ3r)\t9\u0015\fC\u0004L\u0017\u0005\u0005\t\u0019A(\u0002\u0019]\u0014\u0018\u000e^3t)>$\u0018\r\u001c\u0011\u0002\u001b-,\u0017PQ=uKN$v\u000e^1m\u0003EYW-\u001f\"zi\u0016\u001cHk\u001c;bY~#S-\u001d\u000b\u0003\u000fzCqa\u0013\b\u0002\u0002\u0003\u0007q*\u0001\blKf\u0014\u0015\u0010^3t)>$\u0018\r\u001c\u0011\u0002\u001fY\fG.^3CsR,7\u000fV8uC2\f1C^1mk\u0016\u0014\u0015\u0010^3t)>$\u0018\r\\0%KF$\"aR2\t\u000f-\u000b\u0012\u0011!a\u0001\u001f\u0006\u0001b/\u00197vK\nKH/Z:U_R\fG\u000eI\u0001\bgR\f'\u000f^'t\u0003-\u0019H/\u0019:u\u001bN|F%Z9\u0015\u0005\u001dC\u0007bB&\u0015\u0003\u0003\u0005\raT\u0001\tgR\f'\u000f^'tA\u0005\u0019Q\u000f^2\u0016\u00031\u0004\"!\u001c;\u000e\u00039T!a\u001c9\u0002\r\u0019|'/\\1u\u0015\t\t(/\u0001\u0003uS6,'\"A:\u0002\t)\fg/Y\u0005\u0003k:\u0014\u0011\u0003R1uKRKW.\u001a$pe6\fG\u000f^3s\u0003\u0011)Ho\u0019\u0011\u0002\u0015QLW.Z*ue&tw\r\u0006\u0003z\u007f\u0006\r\u0001C\u0001>~\u001b\u0005Y(B\u0001?s\u0003\u0011a\u0017M\\4\n\u0005y\\(AB*ue&tw\r\u0003\u0004\u0002\u0002a\u0001\r\u0001\\\u0001\nM>\u0014X.\u0019;uKJDa!!\u0002\u0019\u0001\u0004y\u0015A\u0001;t\u0003-\u0001(/\u001b8u'R\fG/^:\u0015\u0003\u001d\u000b\u0011\"\u001b8de\u0016lWM\u001c;\u0015\u0007\u001d\u000by\u0001C\u0004\u0002\u0012i\u0001\r!a\u0005\u0002\u0015A,HOU3rk\u0016\u001cH\u000f\u0005\u0003\u0002\u0016\u0005Eb\u0002BA\f\u0003WqA!!\u0007\u0002(9!\u00111DA\u0013\u001d\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011I\u00051AH]8pizJ\u0011aI\u0005\u0003C\tJ1!!\u000b!\u0003\u0019yg\u000e\\5oK&!\u0011QFA\u0018\u0003\u001dYek\u0015;pe\u0016T1!!\u000b!\u0013\u0011\t\u0019$!\u000e\u0003\u0015A+HOU3rk\u0016\u001cHO\u0003\u0003\u0002.\u0005=\u0002")
public class StreamingStats {
    private final int publishDelaySeconds;
    private KllFloatsSketch latencyHistogram;
    private long latencyMsTotal;
    private long writesTotal;
    private long keyBytesTotal;
    private long valueBytesTotal;
    private long startMs;
    private final DateTimeFormatter utc;

    public int publishDelaySeconds() {
        return this.publishDelaySeconds;
    }

    private KllFloatsSketch latencyHistogram() {
        return this.latencyHistogram;
    }

    private void latencyHistogram_$eq(KllFloatsSketch x$1) {
        this.latencyHistogram = x$1;
    }

    private long latencyMsTotal() {
        return this.latencyMsTotal;
    }

    private void latencyMsTotal_$eq(long x$1) {
        this.latencyMsTotal = x$1;
    }

    private long writesTotal() {
        return this.writesTotal;
    }

    private void writesTotal_$eq(long x$1) {
        this.writesTotal = x$1;
    }

    private long keyBytesTotal() {
        return this.keyBytesTotal;
    }

    private void keyBytesTotal_$eq(long x$1) {
        this.keyBytesTotal = x$1;
    }

    private long valueBytesTotal() {
        return this.valueBytesTotal;
    }

    private void valueBytesTotal_$eq(long x$1) {
        this.valueBytesTotal = x$1;
    }

    private long startMs() {
        return this.startMs;
    }

    private void startMs_$eq(long x$1) {
        this.startMs = x$1;
    }

    private DateTimeFormatter utc() {
        return this.utc;
    }

    private String timeString(DateTimeFormatter formatter, long ts) {
        return formatter.format(Instant.ofEpochMilli(ts));
    }

    public void printStatus() {
        if (this.writesTotal() > 0L) {
            long now = System.currentTimeMillis();
            String threadName = new StringBuilder(7).append("Thread-").append(Thread.currentThread().getId()).toString();
            float medianLatency = this.latencyHistogram().getQuantile(0.5);
            float p95Latency = this.latencyHistogram().getQuantile(0.95);
            float p99Latency = this.latencyHistogram().getQuantile(0.99);
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(218).append("\n         |[").append(threadName).append("][").append(this.timeString(this.utc(), now)).append("] Wrote ").append(this.writesTotal()).append(" records in last ").append(now - this.startMs()).append(" ms.         \n         | Latency ms: ").append(this.latencyMsTotal() / this.writesTotal()).append(" (avg) / ").append(medianLatency).append(" (median) / ").append(p95Latency).append(" (p95) / ").append(p99Latency).append(" (p99) \n         |   Key Size: ").append(this.keyBytesTotal() / this.writesTotal()).append(" bytes (avg) / ").append(StreamingStats.readable$1().apply((Object)BoxesRunTime.boxToLong((long)this.keyBytesTotal()))).append(" (total)\n         | Value Size: ").append(this.valueBytesTotal() / this.writesTotal()).append(" bytes (avg) / ").append(StreamingStats.readable$1().apply((Object)BoxesRunTime.boxToLong((long)this.valueBytesTotal()))).append(" (total)\n         |").toString())).stripMargin());
            this.latencyMsTotal_$eq(0L);
            this.writesTotal_$eq(0L);
            this.keyBytesTotal_$eq(0L);
            this.valueBytesTotal_$eq(0L);
            this.latencyHistogram_$eq(new KllFloatsSketch());
            this.startMs_$eq(now);
        } else {
            Predef$.MODULE$.println((Object)"No writes registered");
        }
    }

    public void increment(KVStore.PutRequest putRequest) {
        block2: {
            putRequest.tsMillis().foreach((Function1)(JFunction1.mcVJ.sp & java.io.Serializable & Serializable)queryTime -> {
                long latency = System.currentTimeMillis() - queryTime;
                this.latencyMsTotal_$eq(this.latencyMsTotal() + latency);
                this.latencyHistogram().update((float)latency);
            });
            this.writesTotal_$eq(this.writesTotal() + 1L);
            if (putRequest.keyBytes() != null) {
                this.keyBytesTotal_$eq(this.keyBytesTotal() + (long)putRequest.keyBytes().length);
            }
            if (putRequest.valueBytes() != null) {
                this.valueBytesTotal_$eq(this.valueBytesTotal() + (long)putRequest.valueBytes().length);
            }
            if (System.currentTimeMillis() - this.startMs() <= (long)this.publishDelaySeconds() * 1000L) break block2;
            this.printStatus();
        }
    }

    public static final /* synthetic */ String $anonfun$printStatus$1(long x) {
        return FileUtils.byteCountToDisplaySize((long)x);
    }

    private static final Function1 readable$1() {
        return (Function1 & java.io.Serializable & Serializable)x -> StreamingStats.$anonfun$printStatus$1(BoxesRunTime.unboxToLong((Object)x));
    }

    public StreamingStats(int publishDelaySeconds) {
        this.publishDelaySeconds = publishDelaySeconds;
        this.latencyHistogram = new KllFloatsSketch();
        this.latencyMsTotal = 0L;
        this.writesTotal = 0L;
        this.keyBytesTotal = 0L;
        this.valueBytesTotal = 0L;
        this.startMs = System.currentTimeMillis();
        this.utc = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.from(ZoneOffset.UTC));
    }
}

