/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.stats;

import ai.chronon.api.Extensions$;
import ai.chronon.api.Join;
import ai.chronon.api.PartitionSpec;
import ai.chronon.api.StagingQuery;
import ai.chronon.online.DataMetrics;
import ai.chronon.online.SparkConversions$;
import ai.chronon.spark.Analyzer;
import ai.chronon.spark.Analyzer$;
import ai.chronon.spark.PartitionRange;
import ai.chronon.spark.StagingQuery$;
import ai.chronon.spark.TableUtils;
import ai.chronon.spark.TimedKvRdd;
import ai.chronon.spark.stats.CompareBaseJob$;
import ai.chronon.spark.stats.CompareJob$;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.ScalaJavaConversions$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001\u0002\u000f\u001e\u0001\u0019B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!a\u0005A!A!\u0002\u0013\t\u0005\"B'\u0001\t\u0003q\u0005b\u0002,\u0001\u0005\u0004%\ta\u0016\u0005\u00077\u0002\u0001\u000b\u0011\u0002-\t\u000fq\u0003!\u0019!C\u0001;\"1Q\r\u0001Q\u0001\nyCqA\u001a\u0001C\u0002\u0013\u0005q\r\u0003\u0004i\u0001\u0001\u0006I!\u0011\u0005\bS\u0002\u0011\r\u0011\"\u0001h\u0011\u0019Q\u0007\u0001)A\u0005\u0003\"91\u000e\u0001b\u0001\n\u00039\u0007B\u00027\u0001A\u0003%\u0011\tC\u0004n\u0001\t\u0007I\u0011A4\t\r9\u0004\u0001\u0015!\u0003B\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u001d\t\t\u0003\u0001C\u0001\u0003G9q!a\u000b\u001e\u0011\u0003\tiC\u0002\u0004\u001d;!\u0005\u0011q\u0006\u0005\u0007\u001bZ!\t!!\r\t\u000f\u0005Mb\u0003\"\u0001\u00026!9\u0011\u0011\r\f\u0005\u0002\u0005\r\u0004bBA5-\u0011\u0005\u00111\u000e\u0005\n\u0003o2\u0012\u0011!C\u0005\u0003s\u0012!bQ8na\u0006\u0014XMS8c\u0015\tqr$A\u0003ti\u0006$8O\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\bG\"\u0014xN\\8o\u0015\u0005!\u0013AA1j\u0007\u0001\u00192\u0001A\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011\u0001FL\u0005\u0003_%\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f!\u0002^1cY\u0016,F/\u001b7t!\t\u00114'D\u0001 \u0013\t!tD\u0001\u0006UC\ndW-\u0016;jYN\f\u0001B[8j]\u000e{gN\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0003s\u0005\n1!\u00199j\u0013\tY\u0004H\u0001\u0003K_&t\u0017\u0001E:uC\u001eLgnZ)vKJL8i\u001c8g!\t9d(\u0003\u0002@q\ta1\u000b^1hS:<\u0017+^3ss\u0006I1\u000f^1si\u0012\u000bG/\u001a\t\u0003\u0005&s!aQ$\u0011\u0005\u0011KS\"A#\u000b\u0005\u0019+\u0013A\u0002\u001fs_>$h(\u0003\u0002IS\u00051\u0001K]3eK\u001aL!AS&\u0003\rM#(/\u001b8h\u0015\tA\u0015&A\u0004f]\u0012$\u0015\r^3\u0002\rqJg.\u001b;?)\u0019y\u0015KU*U+B\u0011\u0001\u000bA\u0007\u0002;!)\u0001G\u0002a\u0001c!)QG\u0002a\u0001m!)AH\u0002a\u0001{!)\u0001I\u0002a\u0001\u0003\")AJ\u0002a\u0001\u0003\u0006QA/\u00192mKB\u0013x\u000e]:\u0016\u0003a\u0003BAQ-B\u0003&\u0011!l\u0013\u0002\u0004\u001b\u0006\u0004\u0018a\u0003;bE2,\u0007K]8qg\u0002\n\u0011B\\1nKN\u0004\u0018mY3\u0016\u0003y\u0003\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\t1\fgn\u001a\u0006\u0002G\u0006!!.\u0019<b\u0013\tQ\u0005-\u0001\u0006oC6,7\u000f]1dK\u0002\n\u0001B[8j]:\u000bW.Z\u000b\u0002\u0003\u0006I!n\\5o\u001d\u0006lW\rI\u0001\u0011gR\fw-\u001b8h#V,'/\u001f(b[\u0016\f\u0011c\u001d;bO&tw-U;feft\u0015-\\3!\u0003M\u0019w.\u001c9be&\u001cxN\u001c+bE2,g*Y7f\u0003Q\u0019w.\u001c9be&\u001cxN\u001c+bE2,g*Y7fA\u0005\u0001R.\u001a;sS\u000e\u001cH+\u00192mK:\u000bW.Z\u0001\u0012[\u0016$(/[2t)\u0006\u0014G.\u001a(b[\u0016\u0004\u0013a\u0001:v]R\t\u0011\u000f\u0005\u0004)eR$\u0018QC\u0005\u0003g&\u0012a\u0001V;qY\u0016\u001c\u0004cA;\u0002\u00109\u0019a/!\u0003\u000f\u0007]\f\u0019A\u0004\u0002y\u007f:\u0011\u0011\u0010 \b\u0003\tjL\u0011a_\u0001\u0004_J<\u0017BA?\u007f\u0003\u0019\t\u0007/Y2iK*\t10C\u0002!\u0003\u0003Q!! @\n\t\u0005\u0015\u0011qA\u0001\u0004gFd'b\u0001\u0011\u0002\u0002%!\u00111BA\u0007\u0003\u001d\u0001\u0018mY6bO\u0016TA!!\u0002\u0002\b%!\u0011\u0011CA\n\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0003\u0002\f\u00055\u0001\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005m\u0011%\u0001\u0004p]2Lg.Z\u0005\u0005\u0003?\tIBA\u0006ECR\fW*\u001a;sS\u000e\u001c\u0018\u0001\u0003<bY&$\u0017\r^3\u0015\u0005\u0005\u0015\u0002c\u0001\u0015\u0002(%\u0019\u0011\u0011F\u0015\u0003\tUs\u0017\u000e^\u0001\u000b\u0007>l\u0007/\u0019:f\u0015>\u0014\u0007C\u0001)\u0017'\r1r%\f\u000b\u0003\u0003[\t1cZ3u\u0007>t7o\u001c7jI\u0006$X\r\u001a#bi\u0006$b!a\u000e\u0002T\u0005]\u0003CBA\u001d\u0003\u0003\n9E\u0004\u0003\u0002<\u0005}bb\u0001#\u0002>%\t!&C\u0002\u0002\f%JA!a\u0011\u0002F\t!A*[:u\u0015\r\tY!\u000b\t\u0007Q\u0005%\u0013)!\u0014\n\u0007\u0005-\u0013F\u0001\u0004UkBdWM\r\t\u0004Q\u0005=\u0013bAA)S\t!Aj\u001c8h\u0011\u001d\t)\u0006\u0007a\u0001\u0003+\tq!\\3ue&\u001c7\u000fC\u0004\u0002Za\u0001\r!a\u0017\u0002\u001bA\f'\u000f^5uS>t7\u000b]3d!\r9\u0014QL\u0005\u0004\u0003?B$!\u0004)beRLG/[8o'B,7-A\fqe&tG/\u00118e\u000f\u0016$()Y:jG6+GO]5dgR1\u0011qGA3\u0003OBq!!\u0016\u001a\u0001\u0004\t)\u0002C\u0004\u0002Ze\u0001\r!a\u0017\u0002\u0017\u001d,GOS8j].+\u0017p\u001d\u000b\u0007\u0003[\n\u0019(!\u001e\u0011\u000b\u0005e\u0012qN!\n\t\u0005E\u0014Q\t\u0002\u0004'\u0016\f\b\"B\u001b\u001b\u0001\u00041\u0004\"\u0002\u0019\u001b\u0001\u0004\t\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u001f\u0011\u0007}\u000bi(C\u0002\u0002\u0000\u0001\u0014aa\u00142kK\u000e$\b")
public class CompareJob
implements scala.Serializable {
    private final TableUtils tableUtils;
    private final Join joinConf;
    private final StagingQuery stagingQueryConf;
    private final String startDate;
    private final String endDate;
    private final Map<String, String> tableProps;
    private final String namespace;
    private final String joinName;
    private final String stagingQueryName;
    private final String comparisonTableName;
    private final String metricsTableName;

    public static Seq<String> getJoinKeys(Join join, TableUtils tableUtils) {
        return CompareJob$.MODULE$.getJoinKeys(join, tableUtils);
    }

    public static List<Tuple2<String, Object>> printAndGetBasicMetrics(DataMetrics dataMetrics, PartitionSpec partitionSpec) {
        return CompareJob$.MODULE$.printAndGetBasicMetrics(dataMetrics, partitionSpec);
    }

    public static List<Tuple2<String, Object>> getConsolidatedData(DataMetrics dataMetrics, PartitionSpec partitionSpec) {
        return CompareJob$.MODULE$.getConsolidatedData(dataMetrics, partitionSpec);
    }

    public Map<String, String> tableProps() {
        return this.tableProps;
    }

    public String namespace() {
        return this.namespace;
    }

    public String joinName() {
        return this.joinName;
    }

    public String stagingQueryName() {
        return this.stagingQueryName;
    }

    public String comparisonTableName() {
        return this.comparisonTableName;
    }

    public String metricsTableName() {
        return this.metricsTableName;
    }

    public Tuple3<Dataset<Row>, Dataset<Row>, DataMetrics> run() {
        TimedKvRdd timedKvRdd;
        Dataset dataset;
        DataMetrics metrics;
        block3: {
            Tuple3<Dataset<Row>, TimedKvRdd, DataMetrics> tuple3;
            block2: {
                Predef$.MODULE$.assert(this.endDate != null, (Function0 & Serializable & scala.Serializable)() -> "End date for the comparison should not be null");
                this.validate();
                PartitionRange partitionRange = new PartitionRange(this.startDate, this.endDate, this.tableUtils);
                Dataset<Row> leftDf = this.tableUtils.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n        |SELECT *\n        |FROM ").append(Extensions$.MODULE$.MetadataOps(this.joinConf.metaData).outputTable()).append("\n        |WHERE ").append(partitionRange.betweenClauses()).append("\n        |").toString())).stripMargin());
                Dataset<Row> rightDf = this.tableUtils.sql(StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate));
                Dataset<Row> x$1 = leftDf;
                Dataset<Row> x$2 = rightDf;
                Seq<String> x$3 = CompareJob$.MODULE$.getJoinKeys(this.joinConf, this.tableUtils);
                TableUtils x$4 = this.tableUtils;
                boolean x$5 = true;
                Map<String, String> x$6 = CompareBaseJob$.MODULE$.compare$default$5();
                String x$7 = CompareBaseJob$.MODULE$.compare$default$7();
                tuple3 = CompareBaseJob$.MODULE$.compare(x$1, x$2, x$3, x$4, x$6, x$5, x$7);
                if (tuple3 == null) break block2;
                Dataset compareDf = (Dataset)tuple3._1();
                TimedKvRdd metricsTimedKvRdd = (TimedKvRdd)tuple3._2();
                metrics = (DataMetrics)tuple3._3();
                if (compareDf == null) break block2;
                dataset = compareDf;
                if (metricsTimedKvRdd == null) break block2;
                timedKvRdd = metricsTimedKvRdd;
                if (metrics != null) break block3;
            }
            throw new MatchError(tuple3);
        }
        DataMetrics dataMetrics = metrics;
        Tuple3 tuple3 = new Tuple3((Object)dataset, (Object)timedKvRdd, (Object)dataMetrics);
        Tuple3 tuple32 = tuple3;
        Dataset compareDf = (Dataset)tuple32._1();
        TimedKvRdd metricsTimedKvRdd = (TimedKvRdd)tuple32._2();
        DataMetrics metrics2 = (DataMetrics)tuple32._3();
        Predef$.MODULE$.println((Object)"Saving comparison output..");
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("Comparison schema ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compareDf.schema().fields())).map((Function1 & Serializable & scala.Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()).mkString("\n - ")).toString());
        this.tableUtils.insertUnPartitioned((Dataset<Row>)compareDf, this.comparisonTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
        Predef$.MODULE$.println((Object)"Saving metrics output..");
        Dataset<Row> metricsDf = metricsTimedKvRdd.toFlatDf();
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("Metrics schema ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metricsDf.schema().fields())).map((Function1 & Serializable & scala.Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()).mkString("\n - ")).toString());
        this.tableUtils.insertUnPartitioned(metricsDf, this.metricsTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
        Predef$.MODULE$.println((Object)"Printing basic comparison results..");
        Predef$.MODULE$.println((Object)"(Note: This is just an estimation and not a detailed analysis of results)");
        CompareJob$.MODULE$.printAndGetBasicMetrics(metrics2, this.tableUtils.partitionSpec());
        Predef$.MODULE$.println((Object)"Finished compare stats.");
        return new Tuple3((Object)compareDf, metricsDf, (Object)metrics2);
    }

    public void validate() {
        TableUtils x$1 = this.tableUtils;
        Join x$2 = this.joinConf;
        String x$3 = this.startDate;
        String x$4 = this.endDate;
        boolean x$5 = false;
        int x$6 = Analyzer$.MODULE$.$lessinit$greater$default$5();
        double x$7 = Analyzer$.MODULE$.$lessinit$greater$default$6();
        boolean x$8 = Analyzer$.MODULE$.$lessinit$greater$default$8();
        Analyzer analyzer = new Analyzer(x$1, x$2, x$3, x$4, x$6, x$7, x$5, x$8);
        Map joinChrononSchema = (Map)analyzer.analyzeJoin(this.joinConf, false, analyzer.analyzeJoin$default$3())._1();
        Map joinSchema = ((Map)joinChrononSchema.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            ai.chronon.api.DataType v = (ai.chronon.api.DataType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)SparkConversions$.MODULE$.fromChrononType(v));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        String finalStagingQuery = StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate);
        Map stagingQuerySchema = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableUtils.sql(new StringBuilder(8).append(finalStagingQuery).append(" LIMIT 1").toString()).schema().fields())).map((Function1 & Serializable & scala.Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Map x$9 = joinSchema;
        Map x$10 = stagingQuerySchema;
        Seq<String> x$11 = CompareJob$.MODULE$.getJoinKeys(this.joinConf, this.tableUtils);
        TableUtils x$12 = this.tableUtils;
        boolean x$13 = true;
        Map<String, String> x$14 = CompareBaseJob$.MODULE$.checkConsistency$default$5();
        CompareBaseJob$.MODULE$.checkConsistency((Map<String, DataType>)x$9, (Map<String, DataType>)x$10, x$11, x$12, x$14, x$13);
    }

    public CompareJob(TableUtils tableUtils, Join joinConf, StagingQuery stagingQueryConf, String startDate, String endDate) {
        this.tableUtils = tableUtils;
        this.joinConf = joinConf;
        this.stagingQueryConf = stagingQueryConf;
        this.startDate = startDate;
        this.endDate = endDate;
        this.tableProps = (Map)Option$.MODULE$.apply((Object)joinConf.metaData.tableProperties).map((Function1 & Serializable & scala.Serializable)x$1 -> ScalaJavaConversions$.MODULE$.MapOps(x$1).toScala()).orNull(Predef$.MODULE$.$conforms());
        this.namespace = joinConf.metaData.outputNamespace;
        this.joinName = Extensions$.MODULE$.MetadataOps(joinConf.metaData).cleanName();
        this.stagingQueryName = Extensions$.MODULE$.MetadataOps(stagingQueryConf.metaData).cleanName();
        this.comparisonTableName = new StringBuilder(21).append(this.namespace()).append(".compare_join_query_").append(this.joinName()).append("_").append(this.stagingQueryName()).toString();
        this.metricsTableName = new StringBuilder(27).append(this.namespace()).append(".compare_stats_join_query_").append(this.joinName()).append("_").append(this.stagingQueryName()).toString();
    }
}

