/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.stats;

import ai.chronon.api.Extensions$;
import ai.chronon.api.Join;
import ai.chronon.api.PartitionSpec;
import ai.chronon.api.StagingQuery;
import ai.chronon.online.DataMetrics;
import ai.chronon.online.SparkConversions$;
import ai.chronon.spark.Analyzer;
import ai.chronon.spark.Analyzer$;
import ai.chronon.spark.PartitionRange;
import ai.chronon.spark.StagingQuery$;
import ai.chronon.spark.TableUtils;
import ai.chronon.spark.stats.CompareBaseJob$;
import ai.chronon.spark.stats.CompareJob$;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.ScalaVersionSpecificCollectionsConverter$;

@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001\u0002\u000f\u001e\u0001\u0019B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!\u0011\u0006A!A!\u0002\u0013Q\u0005\"B*\u0001\t\u0003!\u0006b\u0002/\u0001\u0005\u0004%\t!\u0018\u0005\u0007C\u0002\u0001\u000b\u0011\u00020\t\u000f\t\u0004!\u0019!C\u0001G\"11\u000e\u0001Q\u0001\n\u0011Dq\u0001\u001c\u0001C\u0002\u0013\u0005Q\u000e\u0003\u0004o\u0001\u0001\u0006IA\u0013\u0005\b_\u0002\u0011\r\u0011\"\u0001n\u0011\u0019\u0001\b\u0001)A\u0005\u0015\"9\u0011\u000f\u0001b\u0001\n\u0003i\u0007B\u0002:\u0001A\u0003%!\nC\u0004t\u0001\t\u0007I\u0011A7\t\rQ\u0004\u0001\u0015!\u0003K\u0011\u0015)\b\u0001\"\u0001w\u0011\u001d\tY\u0003\u0001C\u0001\u0003[9q!!\u000e\u001e\u0011\u0003\t9D\u0002\u0004\u001d;!\u0005\u0011\u0011\b\u0005\u0007'Z!\t!!\u0012\t\u000f\u0005\u001dc\u0003\"\u0001\u0002J!9\u00111\u000e\f\u0005\u0002\u00055\u0004bBA:-\u0011\u0005\u0011Q\u000f\u0005\n\u0003\u00033\u0012\u0011!C\u0005\u0003\u0007\u0013!bQ8na\u0006\u0014XMS8c\u0015\tqr$A\u0003ti\u0006$8O\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\bG\"\u0014xN\\8o\u0015\u0005!\u0013AA1j\u0007\u0001\u00192\u0001A\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011aF\u000e\b\u0003_Qr!\u0001M\u001a\u000e\u0003ER!AM\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0013BA\u001b*\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u000e\u001d\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005UJ\u0013A\u0003;bE2,W\u000b^5mgB\u00111\bP\u0007\u0002?%\u0011Qh\b\u0002\u000b)\u0006\u0014G.Z+uS2\u001c\u0018\u0001\u00036pS:\u001cuN\u001c4\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t\u000b\u0013aA1qS&\u0011A)\u0011\u0002\u0005\u0015>Lg.\u0001\tti\u0006<\u0017N\\4Rk\u0016\u0014\u0018pQ8oMB\u0011\u0001iR\u0005\u0003\u0011\u0006\u0013Ab\u0015;bO&tw-U;fef\f\u0011b\u001d;beR$\u0015\r^3\u0011\u0005-{eB\u0001'N!\t\u0001\u0014&\u0003\u0002OS\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tq\u0015&A\u0004f]\u0012$\u0015\r^3\u0002\rqJg.\u001b;?)\u0019)v\u000bW-[7B\u0011a\u000bA\u0007\u0002;!)\u0011H\u0002a\u0001u!)aH\u0002a\u0001\u007f!)QI\u0002a\u0001\r\")\u0011J\u0002a\u0001\u0015\")!K\u0002a\u0001\u0015\u0006QA/\u00192mKB\u0013x\u000e]:\u0016\u0003y\u0003BaS0K\u0015&\u0011\u0001-\u0015\u0002\u0004\u001b\u0006\u0004\u0018a\u0003;bE2,\u0007K]8qg\u0002\n\u0011B\\1nKN\u0004\u0018mY3\u0016\u0003\u0011\u0004\"!\u001a6\u000e\u0003\u0019T!a\u001a5\u0002\t1\fgn\u001a\u0006\u0002S\u0006!!.\u0019<b\u0013\t\u0001f-\u0001\u0006oC6,7\u000f]1dK\u0002\n\u0001B[8j]:\u000bW.Z\u000b\u0002\u0015\u0006I!n\\5o\u001d\u0006lW\rI\u0001\u0011gR\fw-\u001b8h#V,'/\u001f(b[\u0016\f\u0011c\u001d;bO&tw-U;feft\u0015-\\3!\u0003M\u0019w.\u001c9be&\u001cxN\u001c+bE2,g*Y7f\u0003Q\u0019w.\u001c9be&\u001cxN\u001c+bE2,g*Y7fA\u0005\u0001R.\u001a;sS\u000e\u001cH+\u00192mK:\u000bW.Z\u0001\u0012[\u0016$(/[2t)\u0006\u0014G.\u001a(b[\u0016\u0004\u0013a\u0001:v]R\tq\u000f\u0005\u0004)qjT\u0018qD\u0005\u0003s&\u0012a\u0001V;qY\u0016\u001c\u0004cA>\u0002\u001a9\u0019A0!\u0006\u000f\u0007u\fyAD\u0002\u007f\u0003\u0017q1a`A\u0003\u001d\r\u0001\u0014\u0011A\u0005\u0003\u0003\u0007\t1a\u001c:h\u0013\u0011\t9!!\u0003\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\u0019!C\u0002!\u0003\u001bQA!a\u0002\u0002\n%!\u0011\u0011CA\n\u0003\r\u0019\u0018\u000f\u001c\u0006\u0004A\u00055\u0011bA\u001b\u0002\u0018)!\u0011\u0011CA\n\u0013\u0011\tY\"!\b\u0003\u0013\u0011\u000bG/\u0019$sC6,'bA\u001b\u0002\u0018A!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&\u0005\naa\u001c8mS:,\u0017\u0002BA\u0015\u0003G\u00111\u0002R1uC6+GO]5dg\u0006Aa/\u00197jI\u0006$X\r\u0006\u0002\u00020A\u0019\u0001&!\r\n\u0007\u0005M\u0012F\u0001\u0003V]&$\u0018AC\"p[B\f'/\u001a&pEB\u0011aKF\n\u0005-\u001d\nY\u0004\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\t\u0005[\u0001\u0003S>L1aNA )\t\t9$A\nhKR\u001cuN\\:pY&$\u0017\r^3e\t\u0006$\u0018\r\u0006\u0004\u0002L\u0005u\u0013\u0011\r\t\u0006]\u00055\u0013\u0011K\u0005\u0004\u0003\u001fB$\u0001\u0002'jgR\u0004b\u0001KA*\u0015\u0006]\u0013bAA+S\t1A+\u001e9mKJ\u00022\u0001KA-\u0013\r\tY&\u000b\u0002\u0005\u0019>tw\rC\u0004\u0002`a\u0001\r!a\b\u0002\u000f5,GO]5dg\"9\u00111\r\rA\u0002\u0005\u0015\u0014!\u00049beRLG/[8o'B,7\rE\u0002A\u0003OJ1!!\u001bB\u00055\u0001\u0016M\u001d;ji&|gn\u00159fG\u00069\u0002O]5oi\u0006sGmR3u\u0005\u0006\u001c\u0018nY'fiJL7m\u001d\u000b\u0007\u0003\u0017\ny'!\u001d\t\u000f\u0005}\u0013\u00041\u0001\u0002 !9\u00111M\rA\u0002\u0005\u0015\u0014aC4fi*{\u0017N\\&fsN$b!a\u001e\u0002~\u0005}\u0004\u0003\u0002\u0018\u0002z)K1!a\u001f9\u0005\r\u0019V-\u001d\u0005\u0006}i\u0001\ra\u0010\u0005\u0006si\u0001\rAO\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003\u000b\u00032!ZAD\u0013\r\tII\u001a\u0002\u0007\u001f\nTWm\u0019;")
public class CompareJob
implements Serializable {
    private final TableUtils tableUtils;
    private final Join joinConf;
    private final StagingQuery stagingQueryConf;
    private final String startDate;
    private final String endDate;
    private final Map<String, String> tableProps;
    private final String namespace;
    private final String joinName;
    private final String stagingQueryName;
    private final String comparisonTableName;
    private final String metricsTableName;

    public static Seq<String> getJoinKeys(Join joinConf, TableUtils tableUtils) {
        return CompareJob$.MODULE$.getJoinKeys(joinConf, tableUtils);
    }

    public static List<Tuple2<String, Object>> printAndGetBasicMetrics(DataMetrics metrics, PartitionSpec partitionSpec) {
        return CompareJob$.MODULE$.printAndGetBasicMetrics(metrics, partitionSpec);
    }

    public static List<Tuple2<String, Object>> getConsolidatedData(DataMetrics metrics, PartitionSpec partitionSpec) {
        return CompareJob$.MODULE$.getConsolidatedData(metrics, partitionSpec);
    }

    public Map<String, String> tableProps() {
        return this.tableProps;
    }

    public String namespace() {
        return this.namespace;
    }

    public String joinName() {
        return this.joinName;
    }

    public String stagingQueryName() {
        return this.stagingQueryName;
    }

    public String comparisonTableName() {
        return this.comparisonTableName;
    }

    public String metricsTableName() {
        return this.metricsTableName;
    }

    public Tuple3<Dataset<Row>, Dataset<Row>, DataMetrics> run() {
        Dataset dataset;
        Dataset dataset2;
        DataMetrics metrics;
        block3: {
            Tuple3<Dataset<Row>, Dataset<Row>, DataMetrics> tuple3;
            block2: {
                Predef$.MODULE$.assert(this.endDate != null, (Function0 & Serializable)() -> "End date for the comparison should not be null");
                this.validate();
                PartitionRange partitionRange = new PartitionRange(this.startDate, this.endDate, this.tableUtils);
                Dataset<Row> leftDf = this.tableUtils.sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n        |SELECT *\n        |FROM ").append(Extensions$.MODULE$.MetadataOps(this.joinConf.metaData).outputTable()).append("\n        |WHERE ").append(partitionRange.betweenClauses()).append("\n        |").toString())));
                Dataset<Row> rightDf = this.tableUtils.sql(StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate));
                Dataset<Row> x$1 = leftDf;
                Dataset<Row> x$2 = rightDf;
                Seq<String> x$3 = CompareJob$.MODULE$.getJoinKeys(this.joinConf, this.tableUtils);
                TableUtils x$4 = this.tableUtils;
                boolean x$5 = true;
                Map<String, String> x$6 = CompareBaseJob$.MODULE$.compare$default$5();
                tuple3 = CompareBaseJob$.MODULE$.compare(x$1, x$2, x$3, x$4, x$6, true);
                if (tuple3 == null) break block2;
                Dataset compareDf = (Dataset)tuple3._1();
                Dataset metricsDf = (Dataset)tuple3._2();
                metrics = (DataMetrics)tuple3._3();
                if (compareDf == null) break block2;
                dataset2 = compareDf;
                if (metricsDf == null) break block2;
                dataset = metricsDf;
                if (metrics != null) break block3;
            }
            throw new MatchError(tuple3);
        }
        DataMetrics dataMetrics = metrics;
        Tuple3 tuple3 = new Tuple3((Object)dataset2, (Object)dataset, (Object)dataMetrics);
        Tuple3 tuple32 = tuple3;
        Dataset compareDf = (Dataset)tuple32._1();
        Dataset metricsDf = (Dataset)tuple32._2();
        DataMetrics metrics2 = (DataMetrics)tuple32._3();
        Predef$.MODULE$.println((Object)"Saving comparison output..");
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("Comparison schema ").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])compareDf.schema().fields()), (Function1 & Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).mkString("\n - ")).toString());
        this.tableUtils.insertUnPartitioned((Dataset<Row>)compareDf, this.comparisonTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
        Predef$.MODULE$.println((Object)"Saving metrics output..");
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("Metrics schema ").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])metricsDf.schema().fields()), (Function1 & Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).mkString("\n - ")).toString());
        this.tableUtils.insertUnPartitioned((Dataset<Row>)metricsDf, this.metricsTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
        Predef$.MODULE$.println((Object)"Printing basic comparison results..");
        Predef$.MODULE$.println((Object)"(Note: This is just an estimation and not a detailed analysis of results)");
        CompareJob$.MODULE$.printAndGetBasicMetrics(metrics2, this.tableUtils.partitionSpec());
        Predef$.MODULE$.println((Object)"Finished compare stats.");
        return new Tuple3((Object)compareDf, (Object)metricsDf, (Object)metrics2);
    }

    public void validate() {
        TableUtils x$1 = this.tableUtils;
        Join x$2 = this.joinConf;
        String x$3 = this.startDate;
        String x$4 = this.endDate;
        boolean x$5 = false;
        int x$6 = Analyzer$.MODULE$.$lessinit$greater$default$5();
        double x$7 = Analyzer$.MODULE$.$lessinit$greater$default$6();
        boolean x$8 = Analyzer$.MODULE$.$lessinit$greater$default$8();
        Analyzer analyzer = new Analyzer(x$1, x$2, x$3, x$4, x$6, x$7, false, x$8);
        Map joinChrononSchema = (Map)analyzer.analyzeJoin(this.joinConf, false, analyzer.analyzeJoin$default$3())._1();
        Map joinSchema = ((Map)joinChrononSchema.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            ai.chronon.api.DataType v = (ai.chronon.api.DataType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)SparkConversions$.MODULE$.fromChrononType(v));
            return tuple22;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        String finalStagingQuery = StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate);
        Map stagingQuerySchema = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.tableUtils.sql(new StringBuilder(8).append(finalStagingQuery).append(" LIMIT 1").toString()).schema().fields()), (Function1 & Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map x$9 = joinSchema;
        Map x$10 = stagingQuerySchema;
        Seq<String> x$11 = CompareJob$.MODULE$.getJoinKeys(this.joinConf, this.tableUtils);
        TableUtils x$12 = this.tableUtils;
        boolean x$13 = true;
        Map<String, String> x$14 = CompareBaseJob$.MODULE$.checkConsistency$default$5();
        CompareBaseJob$.MODULE$.checkConsistency((Map<String, DataType>)x$9, (Map<String, DataType>)x$10, x$11, x$12, x$14, true);
    }

    public CompareJob(TableUtils tableUtils, Join joinConf, StagingQuery stagingQueryConf, String startDate, String endDate) {
        this.tableUtils = tableUtils;
        this.joinConf = joinConf;
        this.stagingQueryConf = stagingQueryConf;
        this.startDate = startDate;
        this.endDate = endDate;
        this.tableProps = (Map)Option$.MODULE$.apply((Object)joinConf.metaData.tableProperties).map((Function1 & Serializable)x$1 -> ScalaVersionSpecificCollectionsConverter$.MODULE$.convertJavaMapToScala(x$1).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.namespace = joinConf.metaData.outputNamespace;
        this.joinName = Extensions$.MODULE$.MetadataOps(joinConf.metaData).cleanName();
        this.stagingQueryName = Extensions$.MODULE$.MetadataOps(stagingQueryConf.metaData).cleanName();
        this.comparisonTableName = new StringBuilder(21).append(this.namespace()).append(".compare_join_query_").append(this.joinName()).append("_").append(this.stagingQueryName()).toString();
        this.metricsTableName = new StringBuilder(27).append(this.namespace()).append(".compare_stats_join_query_").append(this.joinName()).append("_").append(this.stagingQueryName()).toString();
    }
}

