/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.streaming;

import ai.chronon.aggregator.base.BottomK;
import ai.chronon.api.DataType;
import ai.chronon.api.Extensions$;
import ai.chronon.api.GroupBy;
import ai.chronon.api.Source;
import ai.chronon.api.UnknownType;
import ai.chronon.spark.Driver$;
import ai.chronon.spark.stats.EditDistance$;
import ai.chronon.spark.streaming.TopicChecker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaFuture;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class TopicChecker$ {
    public static final TopicChecker$ MODULE$ = new TopicChecker$();

    public int getPartitions(String topic, String bootstrap) {
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrap);
        AdminClient adminClient = AdminClient.create((Properties)props);
        KafkaFuture topicDescription = (KafkaFuture)adminClient.describeTopics(Arrays.asList((Object[])new String[]{topic})).values().get(topic);
        return ((TopicDescription)topicDescription.get()).partitions().size();
    }

    public void topicShouldExist(String topic, String bootstrap) {
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrap);
        try {
            AdminClient adminClient = AdminClient.create((Properties)props);
            ListTopicsOptions options = new ListTopicsOptions();
            options.listInternal(true);
            ListTopicsResult topicsList = adminClient.listTopics(options);
            Map topicsResult = (Map)topicsList.namesToListings().get();
            if (!topicsResult.containsKey(topic)) {
                BottomK closestK = new BottomK((DataType)new UnknownType((Object)BoxedUnit.UNIT), 5, Ordering$.MODULE$.Tuple2((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$, (Ordering)Ordering.String$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class));
                ArrayList result = new ArrayList();
                ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(topicsResult.entrySet().iterator()).asScala()).map((Function1 & Serializable)topicListing -> {
                    String existing = ((TopicListing)topicListing.getValue()).name();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)((double)EditDistance$.MODULE$.betweenStrings(existing, topic).total() / (double)existing.length()))), (Object)existing);
                }).foldLeft(result, (Function2 & Serializable)(cnt, elem) -> closestK.update(cnt, elem));
                closestK.finalize(result);
                throw new RuntimeException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(512).append("\n                                      |Requested topic: ").append(topic).append(" is not found in broker: ").append(bootstrap).append(".\n                                      |Either the bootstrap is incorrect or the topic is. \n                                      |\n                                      | ------ Most similar topics are ------\n                                      |\n                                      |  ").append(((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(result).asScala()).map((Function1 & Serializable)x$1 -> (String)x$1._2())).mkString("\n  ")).append("\n                                      |\n                                      | ------ End ------\n                                      |").toString())));
            }
            Predef$.MODULE$.println((Object)new StringBuilder(27).append("Found topic ").append(topic).append(" in bootstrap ").append(bootstrap).append(".").toString());
        }
        catch (Exception ex) {
            throw new RuntimeException(new StringBuilder(30).append("Failed to check for topic ").append(topic).append(" in ").append(bootstrap).toString(), ex);
        }
    }

    public void main(String[] argSeq) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        TopicChecker.Args args = new TopicChecker.Args((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)argSeq));
        if (args.conf().isDefined()) {
            LazyRef host$lzy = new LazyRef();
            LazyRef port$lzy = new LazyRef();
            LazyRef hostPort$lzy = new LazyRef();
            String confPath = (String)args.conf().apply();
            GroupBy groupBy = (GroupBy)Driver$.MODULE$.parseConf(confPath, ManifestFactory$.MODULE$.classType(GroupBy.class), ClassTag$.MODULE$.apply(GroupBy.class));
            Source source = (Source)Extensions$.MODULE$.GroupByOps(groupBy).streamingSource().get();
            String topic = Extensions$.MODULE$.SourceOps(source).cleanTopic();
            scala.collection.immutable.Map tokens = Extensions$.MODULE$.SourceOps(source).topicTokens();
            tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), args.bootstrap().getOrElse((Function0 & Serializable)() -> TopicChecker$.hostPort$1(hostPort$lzy, host$lzy, tokens, port$lzy)));
        } else {
            tuple22 = tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(args.topic().apply()), args.bootstrap().apply());
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String topic = (String)tuple2._1();
        String bootstrap = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)topic, (Object)bootstrap);
        Tuple2 tuple24 = tuple23;
        String topic2 = (String)tuple24._1();
        String bootstrap2 = (String)tuple24._2();
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)this.getPartitions(topic2, bootstrap2)));
        System.exit(0);
    }

    private static final /* synthetic */ Option host$lzycompute$1(LazyRef host$lzy$1, scala.collection.immutable.Map tokens$1) {
        Option option;
        LazyRef lazyRef = host$lzy$1;
        synchronized (lazyRef) {
            option = host$lzy$1.initialized() ? (Option)host$lzy$1.value() : (Option)host$lzy$1.initialize((Object)tokens$1.get((Object)"host"));
        }
        return option;
    }

    private static final Option host$1(LazyRef host$lzy$1, scala.collection.immutable.Map tokens$1) {
        return host$lzy$1.initialized() ? (Option)host$lzy$1.value() : TopicChecker$.host$lzycompute$1(host$lzy$1, tokens$1);
    }

    private static final /* synthetic */ Option port$lzycompute$1(LazyRef port$lzy$1, scala.collection.immutable.Map tokens$1) {
        Option option;
        LazyRef lazyRef = port$lzy$1;
        synchronized (lazyRef) {
            option = port$lzy$1.initialized() ? (Option)port$lzy$1.value() : (Option)port$lzy$1.initialize((Object)tokens$1.get((Object)"port"));
        }
        return option;
    }

    private static final Option port$1(LazyRef port$lzy$1, scala.collection.immutable.Map tokens$1) {
        return port$lzy$1.initialized() ? (Option)port$lzy$1.value() : TopicChecker$.port$lzycompute$1(port$lzy$1, tokens$1);
    }

    private static final /* synthetic */ String hostPort$lzycompute$1(LazyRef hostPort$lzy$1, LazyRef host$lzy$1, scala.collection.immutable.Map tokens$1, LazyRef port$lzy$1) {
        String string;
        LazyRef lazyRef = hostPort$lzy$1;
        synchronized (lazyRef) {
            string = hostPort$lzy$1.initialized() ? (String)hostPort$lzy$1.value() : (String)hostPort$lzy$1.initialize((Object)new StringBuilder(1).append(TopicChecker$.host$1(host$lzy$1, tokens$1).get()).append(":").append(TopicChecker$.port$1(port$lzy$1, tokens$1).get()).toString());
        }
        return string;
    }

    private static final String hostPort$1(LazyRef hostPort$lzy$1, LazyRef host$lzy$1, scala.collection.immutable.Map tokens$1, LazyRef port$lzy$1) {
        return hostPort$lzy$1.initialized() ? (String)hostPort$lzy$1.value() : TopicChecker$.hostPort$lzycompute$1(hostPort$lzy$1, host$lzy$1, tokens$1, port$lzy$1);
    }

    private TopicChecker$() {
    }
}

