/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark;

import ai.chronon.api.ThriftJsonCodec$;
import ai.chronon.online.Api;
import ai.chronon.spark.Driver;
import ai.chronon.spark.Driver$Analyzer$;
import ai.chronon.spark.Driver$CompareJoinQuery$;
import ai.chronon.spark.Driver$ConsistencyMetricsCompute$;
import ai.chronon.spark.Driver$DailyStats$;
import ai.chronon.spark.Driver$FetcherCli$;
import ai.chronon.spark.Driver$GroupByBackfill$;
import ai.chronon.spark.Driver$GroupByStreaming$;
import ai.chronon.spark.Driver$GroupByUploader$;
import ai.chronon.spark.Driver$JoinBackfill$;
import ai.chronon.spark.Driver$JoinBackfillFinal$;
import ai.chronon.spark.Driver$JoinBackfillLeft$;
import ai.chronon.spark.Driver$LabelJoin$;
import ai.chronon.spark.Driver$LogFlattener$;
import ai.chronon.spark.Driver$LogStats$;
import ai.chronon.spark.Driver$MetadataExport$;
import ai.chronon.spark.Driver$MetadataUploader$;
import ai.chronon.spark.Driver$StagingQueryBackfill$;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.thrift.TBase;
import org.rogach.scallop.ScallopConfBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.Manifest;
import scala.reflect.internal.util.ScalaClassLoader;
import scala.reflect.internal.util.ScalaClassLoader$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Driver$ {
    public static final Driver$ MODULE$ = new Driver$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        Driver$ driver$ = this;
        synchronized (driver$) {
            if (!bitmap$trans$0) {
                logger = LoggerFactory.getLogger(this.getClass());
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    /*
     * WARNING - void declaration
     */
    public Configuration createHadoopConf() {
        void var1_1;
        Configuration conf = new Configuration();
        conf.set("fs.gs.impl", "com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem");
        conf.set("fs.AbstractFileSystem.gs.impl", "com.google.cloud.hadoop.fs.gcs.GoogleHadoopFS");
        conf.set("fs.s3a.impl", "org.apache.hadoop.fs.s3a.S3AFileSystem");
        conf.set("fs.s3a.connection.ssl.enabled", "true");
        conf.set("fs.s3a.path.style.access", "true");
        conf.set("fs.wasb.impl", "org.apache.hadoop.fs.azure.NativeAzureFileSystem");
        conf.set("fs.wasbs.impl", "org.apache.hadoop.fs.azure.NativeAzureFileSystem");
        conf.set("fs.abfs.impl", "org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem");
        return var1_1;
    }

    public <T extends TBase<?, ?>> T parseConf(String confPath, Manifest<T> evidence$1, ClassTag<T> evidence$2) {
        TBase tBase;
        String string;
        block9: {
            List cloudPrefixes = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"gs://", "s3://", "s3a://", "wasb://", "abfs://"}));
            boolean isCloudPath = cloudPrefixes.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)confPath.startsWith(x$1)));
            try {
                if (isCloudPath) {
                    Path cloudFilePath;
                    URI uri = new URI(confPath);
                    FileSystem fs = FileSystem.get((URI)uri, (Configuration)this.createHadoopConf());
                    if (!fs.exists(cloudFilePath = new Path(confPath))) {
                        throw new IOException(new StringBuilder(31).append("Error: Cloud file not found at ").append(confPath).toString());
                    }
                    File tempFile = File.createTempFile("config", ".json");
                    try {
                        fs.copyToLocalFile(cloudFilePath, new Path(tempFile.getAbsolutePath()));
                        string = tempFile.getAbsolutePath();
                        break block9;
                    }
                    catch (IOException e) {
                        throw new IOException(new StringBuilder(35).append("Error downloading file from cloud: ").append(confPath).toString(), e);
                    }
                }
                File localFile = new File(confPath);
                if (!localFile.exists()) {
                    throw new IOException(new StringBuilder(31).append("Error: Local file not found at ").append(confPath).toString());
                }
                string = confPath;
            }
            catch (Exception e) {
                throw new RuntimeException(new StringBuilder(38).append("Failed to resolve configuration file: ").append(confPath).toString(), e);
            }
        }
        String localPath = string;
        try {
            tBase = ThriftJsonCodec$.MODULE$.fromJsonFile(localPath, true, evidence$1, evidence$1);
        }
        catch (Exception e) {
            throw new RuntimeException(new StringBuilder(36).append("Failed to parse configuration file: ").append(localPath).toString(), e);
        }
        return (T)tBase;
    }

    public Api onlineBuilder(Map<String, String> userConf, String onlineJar, String onlineClass) {
        URL[] urls = (URL[])((Object[])new URL[]{new File(onlineJar).toURI().toURL()});
        ScalaClassLoader.URLClassLoader cl = ScalaClassLoader$.MODULE$.fromURLs((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)urls), this.getClass().getClassLoader());
        Class cls = cl.loadClass(onlineClass);
        Constructor<?> constructor = cls.getConstructors()[0];
        Object onlineImpl = constructor.newInstance(userConf);
        return (Api)onlineImpl;
    }

    public void main(String[] baseArgs) {
        block38: {
            Driver.Args args = new Driver.Args(baseArgs);
            boolean shouldExit = true;
            Option option = args.subcommand();
            if (option instanceof Some) {
                ScallopConfBase x;
                Some some = (Some)option;
                ScallopConfBase scallopConfBase = x = (ScallopConfBase)some.value();
                if (args.JoinBackFillArgs().equals(scallopConfBase)) {
                    Driver$JoinBackfill$.MODULE$.run(args.JoinBackFillArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.GroupByBackfillArgs().equals(scallopConfBase)) {
                    Driver$GroupByBackfill$.MODULE$.run(args.GroupByBackfillArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.StagingQueryBackfillArgs().equals(scallopConfBase)) {
                    Driver$StagingQueryBackfill$.MODULE$.run(args.StagingQueryBackfillArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.GroupByUploadArgs().equals(scallopConfBase)) {
                    Driver$GroupByUploader$.MODULE$.run(args.GroupByUploadArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.GroupByStreamingArgs().equals(scallopConfBase)) {
                    shouldExit = false;
                    Driver$GroupByStreaming$.MODULE$.run(args.GroupByStreamingArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.MetadataUploaderArgs().equals(scallopConfBase)) {
                    Driver$MetadataUploader$.MODULE$.run(args.MetadataUploaderArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.FetcherCliArgs().equals(scallopConfBase)) {
                    Driver$FetcherCli$.MODULE$.run(args.FetcherCliArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.LogFlattenerArgs().equals(scallopConfBase)) {
                    Driver$LogFlattener$.MODULE$.run(args.LogFlattenerArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.ConsistencyMetricsArgs().equals(scallopConfBase)) {
                    Driver$ConsistencyMetricsCompute$.MODULE$.run(args.ConsistencyMetricsArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.CompareJoinQueryArgs().equals(scallopConfBase)) {
                    Driver$CompareJoinQuery$.MODULE$.run(args.CompareJoinQueryArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.AnalyzerArgs().equals(scallopConfBase)) {
                    Driver$Analyzer$.MODULE$.run(args.AnalyzerArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.DailyStatsArgs().equals(scallopConfBase)) {
                    Driver$DailyStats$.MODULE$.run(args.DailyStatsArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.LogStatsArgs().equals(scallopConfBase)) {
                    Driver$LogStats$.MODULE$.run(args.LogStatsArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.MetadataExportArgs().equals(scallopConfBase)) {
                    Driver$MetadataExport$.MODULE$.run(args.MetadataExportArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.LabelJoinArgs().equals(scallopConfBase)) {
                    Driver$LabelJoin$.MODULE$.run(args.LabelJoinArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.JoinBackfillLeftArgs().equals(scallopConfBase)) {
                    Driver$JoinBackfillLeft$.MODULE$.run(args.JoinBackfillLeftArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (args.JoinBackfillFinalArgs().equals(scallopConfBase)) {
                    Driver$JoinBackfillFinal$.MODULE$.run(args.JoinBackfillFinalArgs());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.logger().info(new StringBuilder(20).append("Unknown subcommand: ").append(x).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.logger().info("specify a subcommand please");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            if (!shouldExit) break block38;
            System.exit(0);
        }
    }

    private Driver$() {
    }
}

