/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.stats;

import ai.chronon.api.Extensions$;
import ai.chronon.api.Join;
import ai.chronon.api.PartitionSpec;
import ai.chronon.api.StagingQuery;
import ai.chronon.online.DataMetrics;
import ai.chronon.online.SparkConversions$;
import ai.chronon.spark.Analyzer;
import ai.chronon.spark.Analyzer$;
import ai.chronon.spark.PartitionRange;
import ai.chronon.spark.StagingQuery$;
import ai.chronon.spark.TableUtils;
import ai.chronon.spark.TimedKvRdd;
import ai.chronon.spark.stats.CompareBaseJob$;
import ai.chronon.spark.stats.CompareJob$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.ScalaJavaConversions$;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u0001-\u0011!bQ8na\u0006\u0014XMS8c\u0015\t\u0019A!A\u0003ti\u0006$8O\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\bG\"\u0014xN\\8o\u0015\u0005I\u0011AA1j\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u0011QbE\u0005\u0003)9\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\u0006\u0001\u0003\u0002\u0003\u0006IaF\u0001\u000bi\u0006\u0014G.Z+uS2\u001c\bC\u0001\r\u001a\u001b\u0005!\u0011B\u0001\u000e\u0005\u0005)!\u0016M\u00197f+RLGn\u001d\u0005\t9\u0001\u0011\t\u0011)A\u0005;\u0005A!n\\5o\u0007>tg\r\u0005\u0002\u001fC5\tqD\u0003\u0002!\r\u0005\u0019\u0011\r]5\n\u0005\tz\"\u0001\u0002&pS:D\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0011gR\fw-\u001b8h#V,'/_\"p]\u001a\u0004\"A\b\u0014\n\u0005\u001dz\"\u0001D*uC\u001eLgnZ)vKJL\b\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u0013M$\u0018M\u001d;ECR,\u0007CA\u0016/\u001d\tiA&\u0003\u0002.\u001d\u00051\u0001K]3eK\u001aL!a\f\u0019\u0003\rM#(/\u001b8h\u0015\tic\u0002\u0003\u00053\u0001\t\u0005\t\u0015!\u0003+\u0003\u001d)g\u000e\u001a#bi\u0016DQ\u0001\u000e\u0001\u0005\u0002U\na\u0001P5oSRtDC\u0002\u001c9siZD\b\u0005\u00028\u00015\t!\u0001C\u0003\u0017g\u0001\u0007q\u0003C\u0003\u001dg\u0001\u0007Q\u0004C\u0003%g\u0001\u0007Q\u0005C\u0003*g\u0001\u0007!\u0006C\u00033g\u0001\u0007!\u0006C\u0004?\u0001\t\u0007I\u0011A \u0002\u0015Q\f'\r\\3Qe>\u00048/F\u0001A!\u0011Y\u0013I\u000b\u0016\n\u0005\t\u0003$aA'ba\"1A\t\u0001Q\u0001\n\u0001\u000b1\u0002^1cY\u0016\u0004&o\u001c9tA!9a\t\u0001b\u0001\n\u00039\u0015!\u00038b[\u0016\u001c\b/Y2f+\u0005A\u0005CA%O\u001b\u0005Q%BA&M\u0003\u0011a\u0017M\\4\u000b\u00035\u000bAA[1wC&\u0011qF\u0013\u0005\u0007!\u0002\u0001\u000b\u0011\u0002%\u0002\u00159\fW.Z:qC\u000e,\u0007\u0005C\u0004S\u0001\t\u0007I\u0011A*\u0002\u0011)|\u0017N\u001c(b[\u0016,\u0012A\u000b\u0005\u0007+\u0002\u0001\u000b\u0011\u0002\u0016\u0002\u0013)|\u0017N\u001c(b[\u0016\u0004\u0003bB,\u0001\u0005\u0004%\taU\u0001\u0011gR\fw-\u001b8h#V,'/\u001f(b[\u0016Da!\u0017\u0001!\u0002\u0013Q\u0013!E:uC\u001eLgnZ)vKJLh*Y7fA!91\f\u0001b\u0001\n\u0003\u0019\u0016aE2p[B\f'/[:p]R\u000b'\r\\3OC6,\u0007BB/\u0001A\u0003%!&\u0001\u000bd_6\u0004\u0018M]5t_:$\u0016M\u00197f\u001d\u0006lW\r\t\u0005\b?\u0002\u0011\r\u0011\"\u0001T\u0003AiW\r\u001e:jGN$\u0016M\u00197f\u001d\u0006lW\r\u0003\u0004b\u0001\u0001\u0006IAK\u0001\u0012[\u0016$(/[2t)\u0006\u0014G.\u001a(b[\u0016\u0004\u0003\"B2\u0001\t\u0003!\u0017a\u0001:v]R\tQ\r\u0005\u0004\u000eM\"D\u00171A\u0005\u0003O:\u0011a\u0001V;qY\u0016\u001c\u0004CA5\u007f\u001d\tQ7P\u0004\u0002lq:\u0011AN\u001e\b\u0003[Nt!A\\9\u000e\u0003=T!\u0001\u001d\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0018aA8sO&\u0011A/^\u0001\u0007CB\f7\r[3\u000b\u0003IL!!B<\u000b\u0005Q,\u0018BA={\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b]L!\u0001`?\u0002\u000fA\f7m[1hK*\u0011\u0011P_\u0005\u0004\u007f\u0006\u0005!!\u0003#bi\u00064%/Y7f\u0015\taX\u0010\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIAB\u0001\u0007_:d\u0017N\\3\n\t\u00055\u0011q\u0001\u0002\f\t\u0006$\u0018-T3ue&\u001c7\u000fC\u0004\u0002\u0012\u0001!\t!a\u0005\u0002\u0011Y\fG.\u001b3bi\u0016$\"!!\u0006\u0011\u00075\t9\"C\u0002\u0002\u001a9\u0011A!\u00168ji\u001e9\u0011Q\u0004\u0002\t\u0002\u0005}\u0011AC\"p[B\f'/\u001a&pEB\u0019q'!\t\u0007\r\u0005\u0011\u0001\u0012AA\u0012'\u0011\t\t\u0003\u0004\n\t\u000fQ\n\t\u0003\"\u0001\u0002(Q\u0011\u0011q\u0004\u0005\t\u0003W\t\t\u0003\"\u0001\u0002.\u0005\u0019r-\u001a;D_:\u001cx\u000e\\5eCR,G\rR1uCR1\u0011qFA&\u0003\u001f\u0002b!!\r\u0002:\u0005}b\u0002BA\u001a\u0003oq1A\\A\u001b\u0013\u0005y\u0011B\u0001?\u000f\u0013\u0011\tY$!\u0010\u0003\t1K7\u000f\u001e\u0006\u0003y:\u0001b!DA!U\u0005\u0015\u0013bAA\"\u001d\t1A+\u001e9mKJ\u00022!DA$\u0013\r\tIE\u0004\u0002\u0005\u0019>tw\r\u0003\u0005\u0002N\u0005%\u0002\u0019AA\u0002\u0003\u001diW\r\u001e:jGND\u0001\"!\u0015\u0002*\u0001\u0007\u00111K\u0001\u000ea\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u0011\u0007y\t)&C\u0002\u0002X}\u0011Q\u0002U1si&$\u0018n\u001c8Ta\u0016\u001c\u0007\u0002CA.\u0003C!\t!!\u0018\u0002/A\u0014\u0018N\u001c;B]\u0012<U\r\u001e\"bg&\u001cW*\u001a;sS\u000e\u001cHCBA\u0018\u0003?\n\t\u0007\u0003\u0005\u0002N\u0005e\u0003\u0019AA\u0002\u0011!\t\t&!\u0017A\u0002\u0005M\u0003\u0002CA3\u0003C!\t!a\u001a\u0002\u0017\u001d,GOS8j].+\u0017p\u001d\u000b\u0007\u0003S\ny'!\u001d\u0011\u000b\u0005E\u00121\u000e\u0016\n\t\u00055\u0014Q\b\u0002\u0004'\u0016\f\bB\u0002\u000f\u0002d\u0001\u0007Q\u0004\u0003\u0004\u0017\u0003G\u0002\ra\u0006\u0005\u000b\u0003k\n\t#!A\u0005\n\u0005]\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u001f\u0011\u0007%\u000bY(C\u0002\u0002~)\u0013aa\u00142kK\u000e$\b")
public class CompareJob
implements Serializable {
    private final TableUtils tableUtils;
    private final Join joinConf;
    private final StagingQuery stagingQueryConf;
    private final String startDate;
    private final String endDate;
    private final Map<String, String> tableProps;
    private final String namespace;
    private final String joinName;
    private final String stagingQueryName;
    private final String comparisonTableName;
    private final String metricsTableName;

    public static Seq<String> getJoinKeys(Join join, TableUtils tableUtils) {
        return CompareJob$.MODULE$.getJoinKeys(join, tableUtils);
    }

    public static List<Tuple2<String, Object>> printAndGetBasicMetrics(DataMetrics dataMetrics, PartitionSpec partitionSpec) {
        return CompareJob$.MODULE$.printAndGetBasicMetrics(dataMetrics, partitionSpec);
    }

    public static List<Tuple2<String, Object>> getConsolidatedData(DataMetrics dataMetrics, PartitionSpec partitionSpec) {
        return CompareJob$.MODULE$.getConsolidatedData(dataMetrics, partitionSpec);
    }

    public Map<String, String> tableProps() {
        return this.tableProps;
    }

    public String namespace() {
        return this.namespace;
    }

    public String joinName() {
        return this.joinName;
    }

    public String stagingQueryName() {
        return this.stagingQueryName;
    }

    public String comparisonTableName() {
        return this.comparisonTableName;
    }

    public String metricsTableName() {
        return this.metricsTableName;
    }

    public Tuple3<Dataset<Row>, Dataset<Row>, DataMetrics> run() {
        Predef$.MODULE$.assert(this.endDate != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "End date for the comparison should not be null";
            }
        });
        this.validate();
        PartitionRange partitionRange = new PartitionRange(this.startDate, this.endDate, this.tableUtils);
        Dataset<Row> leftDf = this.tableUtils.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |SELECT *\n        |FROM ", "\n        |WHERE ", "\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Extensions$.MODULE$.MetadataOps(this.joinConf.metaData).outputTable(), partitionRange.betweenClauses()})))).stripMargin());
        Dataset<Row> rightDf = this.tableUtils.sql(StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate));
        Dataset<Row> x$19 = leftDf;
        Dataset<Row> x$20 = rightDf;
        Seq<String> x$21 = CompareJob$.MODULE$.getJoinKeys(this.joinConf, this.tableUtils);
        TableUtils x$22 = this.tableUtils;
        boolean x$23 = true;
        Map<String, String> x$24 = CompareBaseJob$.MODULE$.compare$default$5();
        String x$25 = CompareBaseJob$.MODULE$.compare$default$7();
        Tuple3<Dataset<Row>, TimedKvRdd, DataMetrics> tuple3 = CompareBaseJob$.MODULE$.compare(x$19, x$20, x$21, x$22, x$24, x$23, x$25);
        if (tuple3 != null) {
            Dataset compareDf = (Dataset)tuple3._1();
            TimedKvRdd metricsTimedKvRdd = (TimedKvRdd)tuple3._2();
            DataMetrics metrics = (DataMetrics)tuple3._3();
            if (compareDf != null) {
                Dataset dataset = compareDf;
                if (metricsTimedKvRdd != null) {
                    TimedKvRdd timedKvRdd = metricsTimedKvRdd;
                    if (metrics != null) {
                        Tuple3 tuple32;
                        DataMetrics dataMetrics = metrics;
                        Tuple3 tuple33 = tuple32 = new Tuple3((Object)dataset, (Object)timedKvRdd, (Object)dataMetrics);
                        Dataset compareDf2 = (Dataset)tuple33._1();
                        TimedKvRdd metricsTimedKvRdd2 = (TimedKvRdd)tuple33._2();
                        DataMetrics metrics2 = (DataMetrics)tuple33._3();
                        Predef$.MODULE$.println((Object)"Saving comparison output..");
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Comparison schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])compareDf2.schema().fields()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, DataType> apply(StructField sb) {
                                return new Tuple2((Object)sb.name(), (Object)sb.dataType());
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms()).mkString("\n - ")})));
                        this.tableUtils.insertUnPartitioned((Dataset<Row>)compareDf2, this.comparisonTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
                        Predef$.MODULE$.println((Object)"Saving metrics output..");
                        Dataset<Row> metricsDf = metricsTimedKvRdd2.toFlatDf();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metrics schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])metricsDf.schema().fields()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, DataType> apply(StructField sb) {
                                return new Tuple2((Object)sb.name(), (Object)sb.dataType());
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms()).mkString("\n - ")})));
                        this.tableUtils.insertUnPartitioned(metricsDf, this.metricsTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
                        Predef$.MODULE$.println((Object)"Printing basic comparison results..");
                        Predef$.MODULE$.println((Object)"(Note: This is just an estimation and not a detailed analysis of results)");
                        CompareJob$.MODULE$.printAndGetBasicMetrics(metrics2, this.tableUtils.partitionSpec());
                        Predef$.MODULE$.println((Object)"Finished compare stats.");
                        return new Tuple3((Object)compareDf2, metricsDf, (Object)metrics2);
                    }
                }
            }
        }
        throw new MatchError(tuple3);
    }

    public void validate() {
        TableUtils x$26 = this.tableUtils;
        Join x$27 = this.joinConf;
        String x$28 = this.startDate;
        String x$29 = this.endDate;
        boolean x$30 = false;
        int x$31 = Analyzer$.MODULE$.$lessinit$greater$default$5();
        double x$32 = Analyzer$.MODULE$.$lessinit$greater$default$6();
        boolean x$33 = Analyzer$.MODULE$.$lessinit$greater$default$8();
        Analyzer analyzer = new Analyzer(x$26, x$27, x$28, x$29, x$31, x$32, x$30, x$33);
        Map joinChrononSchema = (Map)analyzer.analyzeJoin(this.joinConf, false, analyzer.analyzeJoin$default$3())._1();
        Map joinSchema = ((Map)joinChrononSchema.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, DataType> apply(Tuple2<String, ai.chronon.api.DataType> x0$1) {
                Tuple2<String, ai.chronon.api.DataType> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    ai.chronon.api.DataType v = (ai.chronon.api.DataType)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)k, (Object)SparkConversions$.MODULE$.fromChrononType(v));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        String finalStagingQuery = StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate);
        Map stagingQuerySchema = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.tableUtils.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LIMIT 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{finalStagingQuery}))).schema().fields()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, DataType> apply(StructField sb) {
                return new Tuple2((Object)sb.name(), (Object)sb.dataType());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        Map x$34 = joinSchema;
        Map x$35 = stagingQuerySchema;
        Seq<String> x$36 = CompareJob$.MODULE$.getJoinKeys(this.joinConf, this.tableUtils);
        TableUtils x$37 = this.tableUtils;
        boolean x$38 = true;
        Map<String, String> x$39 = CompareBaseJob$.MODULE$.checkConsistency$default$5();
        CompareBaseJob$.MODULE$.checkConsistency((Map<String, DataType>)x$34, (Map<String, DataType>)x$35, x$36, x$37, x$39, x$38);
    }

    public CompareJob(TableUtils tableUtils, Join joinConf, StagingQuery stagingQueryConf, String startDate, String endDate2) {
        this.tableUtils = tableUtils;
        this.joinConf = joinConf;
        this.stagingQueryConf = stagingQueryConf;
        this.startDate = startDate;
        this.endDate = endDate2;
        this.tableProps = (Map)Option$.MODULE$.apply((Object)joinConf.metaData.tableProperties).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, String> apply(java.util.Map<String, String> x$1) {
                return ScalaJavaConversions$.MODULE$.MapOps(x$1).toScala();
            }
        }).orNull(Predef$.MODULE$.$conforms());
        this.namespace = joinConf.metaData.outputNamespace;
        this.joinName = Extensions$.MODULE$.MetadataOps(joinConf.metaData).cleanName();
        this.stagingQueryName = Extensions$.MODULE$.MetadataOps(stagingQueryConf.metaData).cleanName();
        this.comparisonTableName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".compare_join_query_", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.namespace(), this.joinName(), this.stagingQueryName()}));
        this.metricsTableName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".compare_stats_join_query_", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.namespace(), this.joinName(), this.stagingQueryName()}));
    }
}

