/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.streaming;

import ai.chronon.aggregator.base.BottomK;
import ai.chronon.api.DataType;
import ai.chronon.api.Extensions$;
import ai.chronon.api.GroupBy;
import ai.chronon.api.Source;
import ai.chronon.api.UnknownType;
import ai.chronon.spark.Driver$;
import ai.chronon.spark.stats.EditDistance$;
import ai.chronon.spark.streaming.TopicChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaFuture;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class TopicChecker$ {
    public static final TopicChecker$ MODULE$;

    static {
        new TopicChecker$();
    }

    public int getPartitions(String topic, String bootstrap) {
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrap);
        AdminClient adminClient = AdminClient.create((Properties)props);
        KafkaFuture topicDescription = (KafkaFuture)adminClient.describeTopics(Arrays.asList((Object[])new String[]{topic})).values().get(topic);
        return ((TopicDescription)topicDescription.get()).partitions().size();
    }

    public void topicShouldExist(String topic, String bootstrap) {
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrap);
        try {
            AdminClient adminClient = AdminClient.create((Properties)props);
            ListTopicsOptions options = new ListTopicsOptions();
            options.listInternal(true);
            ListTopicsResult topicsList = adminClient.listTopics(options);
            Map topicsResult = (Map)topicsList.namesToListings().get();
            if (topicsResult.containsKey(topic)) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found topic ", " in bootstrap ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, bootstrap})));
                return;
            }
            BottomK closestK = new BottomK((DataType)new UnknownType((Object)BoxedUnit.UNIT), 5, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.String$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class));
            ArrayList result = new ArrayList();
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(topicsResult.entrySet().iterator()).asScala()).map((Function1)new Serializable(topic){
                public static final long serialVersionUID = 0L;
                private final String topic$1;

                public final Tuple2<Object, String> apply(Map.Entry<String, TopicListing> topicListing) {
                    String existing = topicListing.getValue().name();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)((double)EditDistance$.MODULE$.betweenStrings(existing, this.topic$1).total() / (double)existing.length()))), (Object)existing);
                }
                {
                    this.topic$1 = topic$1;
                }
            }).foldLeft(result, (Function2)new Serializable(closestK){
                public static final long serialVersionUID = 0L;
                private final BottomK closestK$1;

                public final ArrayList<Tuple2<Object, String>> apply(ArrayList<Tuple2<Object, String>> cnt, Tuple2<Object, String> elem) {
                    return this.closestK$1.update(cnt, elem);
                }
                {
                    this.closestK$1 = closestK$1;
                }
            });
            closestK.finalize(result);
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                                      |Requested topic: ", " is not found in broker: ", ".\n                                      |Either the bootstrap is incorrect or the topic is. \n                                      |\n                                      | ------ Most similar topics are ------\n                                      |\n                                      |  ", "\n                                      |\n                                      | ------ End ------\n                                      |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, bootstrap, ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<Object, String> x$1) {
                    return (String)x$1._2();
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString("\n  ")})))).stripMargin());
        }
        catch (Exception exception) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to check for topic ", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, bootstrap})), exception);
        }
    }

    public void main(String[] argSeq) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        TopicChecker.Args args = new TopicChecker.Args((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])argSeq));
        if (args.conf().isDefined()) {
            ObjectRef host$lzy = ObjectRef.zero();
            ObjectRef port$lzy = ObjectRef.zero();
            ObjectRef hostPort$lzy = ObjectRef.zero();
            String confPath = (String)args.conf().apply();
            GroupBy groupBy = (GroupBy)Driver$.MODULE$.parseConf(confPath, ManifestFactory$.MODULE$.classType(GroupBy.class), ClassTag$.MODULE$.apply(GroupBy.class));
            Source source = (Source)Extensions$.MODULE$.GroupByOps(groupBy).streamingSource().get();
            String topic = Extensions$.MODULE$.SourceOps(source).cleanTopic();
            scala.collection.immutable.Map tokens = Extensions$.MODULE$.SourceOps(source).topicTokens();
            tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), args.bootstrap().getOrElse((Function0)new Serializable(tokens, host$lzy, port$lzy, hostPort$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map tokens$1;
                private final ObjectRef host$lzy$1;
                private final ObjectRef port$lzy$1;
                private final ObjectRef hostPort$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final String apply() {
                    return TopicChecker$.MODULE$.ai$chronon$spark$streaming$TopicChecker$$hostPort$1(this.tokens$1, this.host$lzy$1, this.port$lzy$1, this.hostPort$lzy$1, this.bitmap$0$1);
                }
                {
                    this.tokens$1 = tokens$1;
                    this.host$lzy$1 = host$lzy$1;
                    this.port$lzy$1 = port$lzy$1;
                    this.hostPort$lzy$1 = hostPort$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }));
        } else {
            tuple22 = tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(args.topic().apply()), args.bootstrap().apply());
        }
        if (tuple2 != null) {
            Tuple2 tuple23;
            String topic = (String)tuple2._1();
            String bootstrap = (String)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)topic, (Object)bootstrap);
            String topic2 = (String)tuple24._1();
            String bootstrap2 = (String)tuple24._2();
            Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)this.getPartitions(topic2, bootstrap2)));
            System.exit(0);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final Option host$lzycompute$1(scala.collection.immutable.Map tokens$1, ObjectRef host$lzy$1, VolatileByteRef bitmap$0$1) {
        TopicChecker$ topicChecker$ = this;
        synchronized (topicChecker$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                host$lzy$1.elem = tokens$1.get((Object)"host");
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Option)host$lzy$1.elem;
        }
    }

    private final Option host$1(scala.collection.immutable.Map tokens$1, ObjectRef host$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.host$lzycompute$1(tokens$1, host$lzy$1, bitmap$0$1) : (Option)host$lzy$1.elem;
    }

    private final Option port$lzycompute$1(scala.collection.immutable.Map tokens$1, ObjectRef port$lzy$1, VolatileByteRef bitmap$0$1) {
        TopicChecker$ topicChecker$ = this;
        synchronized (topicChecker$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                port$lzy$1.elem = tokens$1.get((Object)"port");
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (Option)port$lzy$1.elem;
        }
    }

    private final Option port$1(scala.collection.immutable.Map tokens$1, ObjectRef port$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.port$lzycompute$1(tokens$1, port$lzy$1, bitmap$0$1) : (Option)port$lzy$1.elem;
    }

    private final String hostPort$lzycompute$1(scala.collection.immutable.Map tokens$1, ObjectRef host$lzy$1, ObjectRef port$lzy$1, ObjectRef hostPort$lzy$1, VolatileByteRef bitmap$0$1) {
        TopicChecker$ topicChecker$ = this;
        synchronized (topicChecker$) {
            if ((byte)(bitmap$0$1.elem & 4) == 0) {
                hostPort$lzy$1.elem = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host$1(tokens$1, host$lzy$1, bitmap$0$1).get(), this.port$1(tokens$1, port$lzy$1, bitmap$0$1).get()}));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 4);
            }
            return (String)hostPort$lzy$1.elem;
        }
    }

    public final String ai$chronon$spark$streaming$TopicChecker$$hostPort$1(scala.collection.immutable.Map tokens$1, ObjectRef host$lzy$1, ObjectRef port$lzy$1, ObjectRef hostPort$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 4) == 0 ? this.hostPort$lzycompute$1(tokens$1, host$lzy$1, port$lzy$1, hostPort$lzy$1, bitmap$0$1) : (String)hostPort$lzy$1.elem;
    }

    private TopicChecker$() {
        MODULE$ = this;
    }
}

