/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark;

import ai.chronon.api.DataType;
import ai.chronon.api.GroupBy;
import ai.chronon.api.Join;
import ai.chronon.api.ThriftJsonCodec$;
import ai.chronon.spark.Analyzer;
import ai.chronon.spark.Analyzer$;
import ai.chronon.spark.SparkSessionBuilder$;
import ai.chronon.spark.TableUtils;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MetadataExporter$ {
    public static final MetadataExporter$ MODULE$;
    private transient Logger logger;
    private final String GROUPBY_PATH_SUFFIX;
    private final String JOIN_PATH_SUFFIX;
    private final ObjectMapper mapper;
    private final TableUtils tableUtils;
    private final String today;
    private final String yesterday;
    private volatile transient boolean bitmap$trans$0;

    static {
        new MetadataExporter$();
    }

    private Logger logger$lzycompute() {
        MetadataExporter$ metadataExporter$ = this;
        synchronized (metadataExporter$) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger(this.getClass());
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public String GROUPBY_PATH_SUFFIX() {
        return this.GROUPBY_PATH_SUFFIX;
    }

    public String JOIN_PATH_SUFFIX() {
        return this.JOIN_PATH_SUFFIX;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public TableUtils tableUtils() {
        return this.tableUtils;
    }

    private String today() {
        return this.today;
    }

    private String yesterday() {
        return this.yesterday;
    }

    public Seq<String> getFilePaths(String inputPath) {
        File rootDir = new File(inputPath);
        if (rootDir.exists()) {
            ListBuffer fileBuffer = new ListBuffer();
            this.ai$chronon$spark$MetadataExporter$$traverseDirectory$1(rootDir, fileBuffer);
            return fileBuffer.toList();
        }
        String arg$macro$1 = inputPath;
        throw new Exception(new StringOps("Directory %s does not exist!").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
    }

    public String enrichMetadata(String path) {
        Map map;
        block4: {
            Map configData = (Map)this.mapper().readValue(new File(path), Map.class);
            TableUtils x$5 = this.tableUtils();
            String x$6 = path;
            String x$7 = this.yesterday();
            String x$8 = this.today();
            boolean x$9 = true;
            boolean x$10 = true;
            int x$11 = Analyzer$.MODULE$.$lessinit$greater$default$5();
            double x$12 = Analyzer$.MODULE$.$lessinit$greater$default$6();
            boolean x$13 = Analyzer$.MODULE$.$lessinit$greater$default$7();
            Analyzer analyzer = new Analyzer(x$5, x$6, x$7, x$8, x$11, x$12, x$13, x$9, x$10);
            try {
                if (path.contains(this.GROUPBY_PATH_SUFFIX())) {
                    GroupBy groupBy = (GroupBy)ThriftJsonCodec$.MODULE$.fromJsonFile(path, false, ManifestFactory$.MODULE$.classType(GroupBy.class), ClassTag$.MODULE$.apply(GroupBy.class));
                    map = configData.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), Predef$.MODULE$.refArrayOps((Object[])analyzer.analyzeGroupBy(groupBy, analyzer.analyzeGroupBy$default$2(), analyzer.analyzeGroupBy$default$3(), analyzer.analyzeGroupBy$default$4(), analyzer.analyzeGroupBy$default$5())._1()).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Map<String, String> apply(Analyzer.AggregationMetadata x$1) {
                            return x$1.asMap();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class)))));
                    break block4;
                }
                if (path.contains(this.JOIN_PATH_SUFFIX())) {
                    Join join;
                    Join x$14 = join = (Join)ThriftJsonCodec$.MODULE$.fromJsonFile(path, false, ManifestFactory$.MODULE$.classType(Join.class), ClassTag$.MODULE$.apply(Join.class));
                    boolean x$15 = false;
                    boolean x$16 = analyzer.analyzeJoin$default$2();
                    boolean x$17 = analyzer.analyzeJoin$default$4();
                    boolean x$18 = analyzer.analyzeJoin$default$5();
                    Tuple2<Map<String, DataType>, ListBuffer<Analyzer.AggregationMetadata>> joinAnalysis = analyzer.analyzeJoin(x$14, x$16, x$15, x$17, x$18);
                    Seq featureMetadata = (Seq)((TraversableForwarder)joinAnalysis._2()).toSeq().map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Map<String, String> apply(Analyzer.AggregationMetadata x$2) {
                            return x$2.asMap();
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    map = configData.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), (Object)featureMetadata));
                    break block4;
                }
                String arg$macro$2 = path;
                throw new Exception(new StringOps("Unknown entity type for %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$2})));
            }
            catch (Throwable throwable) {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while processing entity ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, ExceptionUtils.getStackTrace((Throwable)throwable)})));
                map = configData;
            }
        }
        Map enrichedData = map;
        return this.mapper().writeValueAsString((Object)enrichedData);
    }

    public void writeOutput(String data, String path, String outputDirectory) {
        Files.createDirectories(Paths.get(outputDirectory, new String[0]), new FileAttribute[0]);
        File file = new File(new StringBuilder().append((Object)outputDirectory).append((Object)"/").append(Predef$.MODULE$.refArrayOps((Object[])path.split("/")).last()).toString());
        file.createNewFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(data);
        writer.close();
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : Wrote to output directory successfully"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
    }

    public void processEntities(String inputPath, String outputPath) {
        Seq processSuccess = (Seq)this.getFilePaths(inputPath).map((Function1)new Serializable(outputPath){
            public static final long serialVersionUID = 0L;
            private final String outputPath$1;

            public final Tuple3<String, Object, Object> apply(String path) {
                Tuple3 tuple3;
                try {
                    String data = MetadataExporter$.MODULE$.enrichMetadata(path);
                    if (path.contains(MetadataExporter$.MODULE$.GROUPBY_PATH_SUFFIX())) {
                        MetadataExporter$.MODULE$.writeOutput(data, path, new StringBuilder().append((Object)this.outputPath$1).append((Object)MetadataExporter$.MODULE$.GROUPBY_PATH_SUFFIX()).toString());
                    } else if (path.contains(MetadataExporter$.MODULE$.JOIN_PATH_SUFFIX())) {
                        MetadataExporter$.MODULE$.writeOutput(data, path, new StringBuilder().append((Object)this.outputPath$1).append((Object)MetadataExporter$.MODULE$.JOIN_PATH_SUFFIX()).toString());
                    }
                    tuple3 = new Tuple3((Object)path, (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$);
                }
                catch (Throwable throwable) {
                    tuple3 = new Tuple3((Object)path, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)ExceptionUtils.getStackTrace((Throwable)throwable));
                }
                return tuple3;
            }
            {
                this.outputPath$1 = outputPath$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq failuresAndTraces = (Seq)processSuccess.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple3<String, Object, Object> x$3) {
                return !BoxesRunTime.unboxToBoolean((Object)x$3._2());
            }
        });
        this.logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully processed ", " from ", " \\n "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((SeqLike)processSuccess.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple3<String, Object, Object> x$4) {
                return BoxesRunTime.unboxToBoolean((Object)x$4._2());
            }
        })).length()), inputPath}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to process ", ": \\n ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)failuresAndTraces.length()), failuresAndTraces.mkString("\n")}))).toString());
    }

    public void run(String inputPath, String outputPath) {
        this.processEntities(inputPath, outputPath);
    }

    public final void ai$chronon$spark$MetadataExporter$$traverseDirectory$1(File currentDir, ListBuffer fileBuffer$1) {
        if (currentDir.isDirectory()) {
            File[] files = currentDir.listFiles();
            if (files != null) {
                Predef$.MODULE$.refArrayOps((Object[])files).foreach((Function1)new Serializable(fileBuffer$1){
                    public static final long serialVersionUID = 0L;
                    private final ListBuffer fileBuffer$1;

                    public final Object apply(File file) {
                        BoxedUnit boxedUnit;
                        if (file.isFile()) {
                            boxedUnit = this.fileBuffer$1.$plus$eq((Object)file.getAbsolutePath());
                        } else if (file.isDirectory()) {
                            MetadataExporter$.MODULE$.ai$chronon$spark$MetadataExporter$$traverseDirectory$1(file, this.fileBuffer$1);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                    {
                        this.fileBuffer$1 = fileBuffer$1;
                    }
                });
            }
        } else {
            fileBuffer$1.$plus$eq((Object)currentDir.getAbsolutePath());
        }
    }

    private MetadataExporter$() {
        MODULE$ = this;
        this.GROUPBY_PATH_SUFFIX = "/group_bys";
        this.JOIN_PATH_SUFFIX = "/joins";
        this.mapper = new ObjectMapper();
        this.mapper().registerModule((Module)DefaultScalaModule$.MODULE$);
        this.tableUtils = new TableUtils(SparkSessionBuilder$.MODULE$.build("metadata_exporter", SparkSessionBuilder$.MODULE$.build$default$2(), SparkSessionBuilder$.MODULE$.build$default$3(), SparkSessionBuilder$.MODULE$.build$default$4(), SparkSessionBuilder$.MODULE$.build$default$5()));
        this.today = this.tableUtils().partitionSpec().at(System.currentTimeMillis());
        this.yesterday = this.tableUtils().partitionSpec().before(this.today());
    }
}

