/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.stats;

import ai.chronon.api.Extensions$;
import ai.chronon.api.Join;
import ai.chronon.api.PartitionSpec;
import ai.chronon.api.StagingQuery;
import ai.chronon.online.DataMetrics;
import ai.chronon.online.SparkConversions$;
import ai.chronon.spark.Analyzer;
import ai.chronon.spark.Analyzer$;
import ai.chronon.spark.PartitionRange;
import ai.chronon.spark.StagingQuery$;
import ai.chronon.spark.TableUtils;
import ai.chronon.spark.TimedKvRdd;
import ai.chronon.spark.stats.CompareBaseJob$;
import ai.chronon.spark.stats.CompareJob$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.ScalaJavaConversions$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u0001-\u0011!bQ8na\u0006\u0014XMS8c\u0015\t\u0019A!A\u0003ti\u0006$8O\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\bG\"\u0014xN\\8o\u0015\u0005I\u0011AA1j\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u0011QbE\u0005\u0003)9\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\u0006\u0001\u0003\u0002\u0003\u0006IaF\u0001\u000bi\u0006\u0014G.Z+uS2\u001c\bC\u0001\r\u001a\u001b\u0005!\u0011B\u0001\u000e\u0005\u0005)!\u0016M\u00197f+RLGn\u001d\u0005\t9\u0001\u0011\t\u0011)A\u0005;\u0005A!n\\5o\u0007>tg\r\u0005\u0002\u001fC5\tqD\u0003\u0002!\r\u0005\u0019\u0011\r]5\n\u0005\tz\"\u0001\u0002&pS:D\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0011gR\fw-\u001b8h#V,'/_\"p]\u001a\u0004\"A\b\u0014\n\u0005\u001dz\"\u0001D*uC\u001eLgnZ)vKJL\b\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u0013M$\u0018M\u001d;ECR,\u0007CA\u0016/\u001d\tiA&\u0003\u0002.\u001d\u00051\u0001K]3eK\u001aL!a\f\u0019\u0003\rM#(/\u001b8h\u0015\tic\u0002\u0003\u00053\u0001\t\u0005\t\u0015!\u0003+\u0003\u001d)g\u000e\u001a#bi\u0016DQ\u0001\u000e\u0001\u0005\u0002U\na\u0001P5oSRtDC\u0002\u001c9siZD\b\u0005\u00028\u00015\t!\u0001C\u0003\u0017g\u0001\u0007q\u0003C\u0003\u001dg\u0001\u0007Q\u0004C\u0003%g\u0001\u0007Q\u0005C\u0003*g\u0001\u0007!\u0006C\u00033g\u0001\u0007!\u0006\u0003\u0005?\u0001!\u0015\r\u0011\"\u0001@\u0003\u0019awnZ4feV\t\u0001\t\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006)1\u000f\u001c45U*\tQ)A\u0002pe\u001eL!a\u0012\"\u0003\r1{wmZ3s\u0011!I\u0005\u0001#A!B\u0013\u0001\u0015a\u00027pO\u001e,'\u000f\t\u0015\u0003\u0011.\u0003\"!\u0004'\n\u00055s!!\u0003;sC:\u001c\u0018.\u001a8u\u0011\u001dy\u0005A1A\u0005\u0002A\u000b!\u0002^1cY\u0016\u0004&o\u001c9t+\u0005\t\u0006\u0003B\u0016SU)J!a\u0015\u0019\u0003\u00075\u000b\u0007\u000f\u0003\u0004V\u0001\u0001\u0006I!U\u0001\fi\u0006\u0014G.\u001a)s_B\u001c\b\u0005C\u0004X\u0001\t\u0007I\u0011\u0001-\u0002\u00139\fW.Z:qC\u000e,W#A-\u0011\u0005i{V\"A.\u000b\u0005qk\u0016\u0001\u00027b]\u001eT\u0011AX\u0001\u0005U\u00064\u0018-\u0003\u000207\"1\u0011\r\u0001Q\u0001\ne\u000b!B\\1nKN\u0004\u0018mY3!\u0011\u001d\u0019\u0007A1A\u0005\u0002\u0011\f\u0001B[8j]:\u000bW.Z\u000b\u0002U!1a\r\u0001Q\u0001\n)\n\u0011B[8j]:\u000bW.\u001a\u0011\t\u000f!\u0004!\u0019!C\u0001I\u0006\u00012\u000f^1hS:<\u0017+^3ss:\u000bW.\u001a\u0005\u0007U\u0002\u0001\u000b\u0011\u0002\u0016\u0002#M$\u0018mZ5oOF+XM]=OC6,\u0007\u0005C\u0004m\u0001\t\u0007I\u0011\u00013\u0002'\r|W\u000e]1sSN|g\u000eV1cY\u0016t\u0015-\\3\t\r9\u0004\u0001\u0015!\u0003+\u0003Q\u0019w.\u001c9be&\u001cxN\u001c+bE2,g*Y7fA!9\u0001\u000f\u0001b\u0001\n\u0003!\u0017\u0001E7fiJL7m\u001d+bE2,g*Y7f\u0011\u0019\u0011\b\u0001)A\u0005U\u0005\tR.\u001a;sS\u000e\u001cH+\u00192mK:\u000bW.\u001a\u0011\t\u000bQ\u0004A\u0011A;\u0002\u0007I,h\u000eF\u0001w!\u0019iq/_=\u0002\"%\u0011\u0001P\u0004\u0002\u0007)V\u0004H.Z\u001a\u0011\u0007i\fYBD\u0002|\u0003+q1\u0001`A\b\u001d\ri\u00181\u0002\b\u0004}\u0006\u001dabA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007Q\u0011A\u0002\u001fs_>$h(C\u0001F\u0013\r\tI\u0001R\u0001\u0007CB\f7\r[3\n\u0007\u0015\tiAC\u0002\u0002\n\u0011KA!!\u0005\u0002\u0014\u0005\u00191/\u001d7\u000b\u0007\u0015\ti!\u0003\u0003\u0002\u0018\u0005e\u0011a\u00029bG.\fw-\u001a\u0006\u0005\u0003#\t\u0019\"\u0003\u0003\u0002\u001e\u0005}!!\u0003#bi\u00064%/Y7f\u0015\u0011\t9\"!\u0007\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\n\u0007\u0003\u0019yg\u000e\\5oK&!\u00111FA\u0013\u0005-!\u0015\r^1NKR\u0014\u0018nY:\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\u0005Aa/\u00197jI\u0006$X\r\u0006\u0002\u00024A\u0019Q\"!\u000e\n\u0007\u0005]bB\u0001\u0003V]&$xaBA\u001e\u0005!\u0005\u0011QH\u0001\u000b\u0007>l\u0007/\u0019:f\u0015>\u0014\u0007cA\u001c\u0002@\u00191\u0011A\u0001E\u0001\u0003\u0003\u001aB!a\u0010\r%!9A'a\u0010\u0005\u0002\u0005\u0015CCAA\u001f\u0011%q\u0014q\bEC\u0002\u0013\u0005q\bC\u0005J\u0003\u007fA\t\u0011)Q\u0005\u0001\"\u001a\u0011\u0011J&\t\u0011\u0005=\u0013q\bC\u0001\u0003#\n1cZ3u\u0007>t7o\u001c7jI\u0006$X\r\u001a#bi\u0006$b!a\u0015\u0002p\u0005M\u0004CBA+\u0003;\n\u0019G\u0004\u0003\u0002X\u0005mcbA@\u0002Z%\tq\"C\u0002\u0002\u00189IA!a\u0018\u0002b\t!A*[:u\u0015\r\t9B\u0004\t\u0007\u001b\u0005\u0015$&!\u001b\n\u0007\u0005\u001ddB\u0001\u0004UkBdWM\r\t\u0004\u001b\u0005-\u0014bAA7\u001d\t!Aj\u001c8h\u0011!\t\t(!\u0014A\u0002\u0005\u0005\u0012aB7fiJL7m\u001d\u0005\t\u0003k\ni\u00051\u0001\u0002x\u0005i\u0001/\u0019:uSRLwN\\*qK\u000e\u00042AHA=\u0013\r\tYh\b\u0002\u000e!\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\t\u0011\u0005}\u0014q\bC\u0001\u0003\u0003\u000bq\u0003\u001d:j]R\fe\u000eZ$fi\n\u000b7/[2NKR\u0014\u0018nY:\u0015\r\u0005M\u00131QAC\u0011!\t\t(! A\u0002\u0005\u0005\u0002\u0002CA;\u0003{\u0002\r!a\u001e\t\u0011\u0005%\u0015q\bC\u0001\u0003\u0017\u000b1bZ3u\u0015>LgnS3zgR1\u0011QRAJ\u0003+\u0003R!!\u0016\u0002\u0010*JA!!%\u0002b\t\u00191+Z9\t\rq\t9\t1\u0001\u001e\u0011\u00191\u0012q\u0011a\u0001/!Q\u0011\u0011TA \u0003\u0003%I!a'\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003;\u00032AWAP\u0013\r\t\tk\u0017\u0002\u0007\u001f\nTWm\u0019;")
public class CompareJob
implements Serializable {
    private final TableUtils tableUtils;
    private final Join joinConf;
    private final StagingQuery stagingQueryConf;
    private final String startDate;
    private final String endDate;
    private transient Logger logger;
    private final Map<String, String> tableProps;
    private final String namespace;
    private final String joinName;
    private final String stagingQueryName;
    private final String comparisonTableName;
    private final String metricsTableName;
    private volatile transient boolean bitmap$trans$0;

    public static Seq<String> getJoinKeys(Join join, TableUtils tableUtils) {
        return CompareJob$.MODULE$.getJoinKeys(join, tableUtils);
    }

    public static List<Tuple2<String, Object>> printAndGetBasicMetrics(DataMetrics dataMetrics, PartitionSpec partitionSpec) {
        return CompareJob$.MODULE$.printAndGetBasicMetrics(dataMetrics, partitionSpec);
    }

    public static List<Tuple2<String, Object>> getConsolidatedData(DataMetrics dataMetrics, PartitionSpec partitionSpec) {
        return CompareJob$.MODULE$.getConsolidatedData(dataMetrics, partitionSpec);
    }

    private Logger logger$lzycompute() {
        CompareJob compareJob = this;
        synchronized (compareJob) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger(this.getClass());
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public Map<String, String> tableProps() {
        return this.tableProps;
    }

    public String namespace() {
        return this.namespace;
    }

    public String joinName() {
        return this.joinName;
    }

    public String stagingQueryName() {
        return this.stagingQueryName;
    }

    public String comparisonTableName() {
        return this.comparisonTableName;
    }

    public String metricsTableName() {
        return this.metricsTableName;
    }

    public Tuple3<Dataset<Row>, Dataset<Row>, DataMetrics> run() {
        Predef$.MODULE$.assert(this.endDate != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "End date for the comparison should not be null";
            }
        });
        this.validate();
        PartitionRange partitionRange = new PartitionRange(this.startDate, this.endDate, this.tableUtils);
        Dataset<Row> leftDf = this.tableUtils.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |SELECT *\n        |FROM ", "\n        |WHERE ", "\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Extensions$.MODULE$.MetadataOps(this.joinConf.metaData).outputTable(), partitionRange.betweenClauses()})))).stripMargin());
        Dataset<Row> rightDf = this.tableUtils.sql(StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate));
        Dataset<Row> x$19 = leftDf;
        Dataset<Row> x$20 = rightDf;
        Seq<String> x$21 = CompareJob$.MODULE$.getJoinKeys(this.joinConf, this.tableUtils);
        TableUtils x$22 = this.tableUtils;
        boolean x$23 = true;
        Map<String, String> x$24 = CompareBaseJob$.MODULE$.compare$default$5();
        String x$25 = CompareBaseJob$.MODULE$.compare$default$7();
        Tuple3<Dataset<Row>, TimedKvRdd, DataMetrics> tuple3 = CompareBaseJob$.MODULE$.compare(x$19, x$20, x$21, x$22, x$24, x$23, x$25);
        if (tuple3 != null) {
            Dataset compareDf = (Dataset)tuple3._1();
            TimedKvRdd metricsTimedKvRdd = (TimedKvRdd)tuple3._2();
            DataMetrics metrics = (DataMetrics)tuple3._3();
            if (compareDf != null) {
                Dataset dataset = compareDf;
                if (metricsTimedKvRdd != null) {
                    TimedKvRdd timedKvRdd = metricsTimedKvRdd;
                    if (metrics != null) {
                        Tuple3 tuple32;
                        DataMetrics dataMetrics = metrics;
                        Tuple3 tuple33 = tuple32 = new Tuple3((Object)dataset, (Object)timedKvRdd, (Object)dataMetrics);
                        Dataset compareDf2 = (Dataset)tuple33._1();
                        TimedKvRdd metricsTimedKvRdd2 = (TimedKvRdd)tuple33._2();
                        DataMetrics metrics2 = (DataMetrics)tuple33._3();
                        this.logger().info("Saving comparison output..");
                        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Comparison schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])compareDf2.schema().fields()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, DataType> apply(StructField sb) {
                                return new Tuple2((Object)sb.name(), (Object)sb.dataType());
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms()).mkString("\n - ")})));
                        this.tableUtils.insertUnPartitioned((Dataset<Row>)compareDf2, this.comparisonTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
                        this.logger().info("Saving metrics output..");
                        Dataset<Row> metricsDf = metricsTimedKvRdd2.toFlatDf();
                        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metrics schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])metricsDf.schema().fields()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, DataType> apply(StructField sb) {
                                return new Tuple2((Object)sb.name(), (Object)sb.dataType());
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms()).mkString("\n - ")})));
                        this.tableUtils.insertUnPartitioned(metricsDf, this.metricsTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
                        this.logger().info("Printing basic comparison results..");
                        this.logger().info("(Note: This is just an estimation and not a detailed analysis of results)");
                        CompareJob$.MODULE$.printAndGetBasicMetrics(metrics2, this.tableUtils.partitionSpec());
                        this.logger().info("Finished compare stats.");
                        return new Tuple3((Object)compareDf2, metricsDf, (Object)metrics2);
                    }
                }
            }
        }
        throw new MatchError(tuple3);
    }

    public void validate() {
        TableUtils x$26 = this.tableUtils;
        Join x$27 = this.joinConf;
        String x$28 = this.startDate;
        String x$29 = this.endDate;
        boolean x$30 = false;
        int x$31 = Analyzer$.MODULE$.$lessinit$greater$default$5();
        double x$32 = Analyzer$.MODULE$.$lessinit$greater$default$6();
        boolean x$33 = Analyzer$.MODULE$.$lessinit$greater$default$8();
        boolean x$34 = Analyzer$.MODULE$.$lessinit$greater$default$9();
        Analyzer analyzer = new Analyzer(x$26, x$27, x$28, x$29, x$31, x$32, x$30, x$33, x$34);
        Map joinChrononSchema = (Map)analyzer.analyzeJoin(this.joinConf, false, analyzer.analyzeJoin$default$3(), analyzer.analyzeJoin$default$4(), analyzer.analyzeJoin$default$5())._1();
        Map joinSchema = ((Map)joinChrononSchema.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, DataType> apply(Tuple2<String, ai.chronon.api.DataType> x0$1) {
                Tuple2<String, ai.chronon.api.DataType> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    ai.chronon.api.DataType v = (ai.chronon.api.DataType)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)k, (Object)SparkConversions$.MODULE$.fromChrononType(v));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        String finalStagingQuery = StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate);
        Map stagingQuerySchema = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.tableUtils.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LIMIT 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{finalStagingQuery}))).schema().fields()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, DataType> apply(StructField sb) {
                return new Tuple2((Object)sb.name(), (Object)sb.dataType());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        Map x$35 = joinSchema;
        Map x$36 = stagingQuerySchema;
        Seq<String> x$37 = CompareJob$.MODULE$.getJoinKeys(this.joinConf, this.tableUtils);
        TableUtils x$38 = this.tableUtils;
        boolean x$39 = true;
        Map<String, String> x$40 = CompareBaseJob$.MODULE$.checkConsistency$default$5();
        CompareBaseJob$.MODULE$.checkConsistency((Map<String, DataType>)x$35, (Map<String, DataType>)x$36, x$37, x$38, x$40, x$39);
    }

    public CompareJob(TableUtils tableUtils, Join joinConf, StagingQuery stagingQueryConf, String startDate, String endDate2) {
        this.tableUtils = tableUtils;
        this.joinConf = joinConf;
        this.stagingQueryConf = stagingQueryConf;
        this.startDate = startDate;
        this.endDate = endDate2;
        this.tableProps = (Map)Option$.MODULE$.apply((Object)joinConf.metaData.tableProperties).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, String> apply(java.util.Map<String, String> x$1) {
                return ScalaJavaConversions$.MODULE$.MapOps(x$1).toScala();
            }
        }).orNull(Predef$.MODULE$.$conforms());
        this.namespace = joinConf.metaData.outputNamespace;
        this.joinName = Extensions$.MODULE$.MetadataOps(joinConf.metaData).cleanName();
        this.stagingQueryName = Extensions$.MODULE$.MetadataOps(stagingQueryConf.metaData).cleanName();
        this.comparisonTableName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".compare_join_query_", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.namespace(), this.joinName(), this.stagingQueryName()}));
        this.metricsTableName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".compare_stats_join_query_", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.namespace(), this.joinName(), this.stagingQueryName()}));
    }
}

