/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.streaming;

import ai.chronon.aggregator.base.BottomK;
import ai.chronon.api.DataType;
import ai.chronon.api.UnknownType;
import ai.chronon.spark.stats.EditDistance$;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicListing;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TopicChecker$ {
    public static TopicChecker$ MODULE$;

    static {
        new TopicChecker$();
    }

    public void topicShouldExist(String topic, String bootstrap) {
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrap);
        try {
            AdminClient adminClient = AdminClient.create((Properties)props);
            ListTopicsOptions options = new ListTopicsOptions();
            options.listInternal(true);
            ListTopicsResult topicsList = adminClient.listTopics(options);
            Map topicsResult = (Map)topicsList.namesToListings().get();
            if (!topicsResult.containsKey(topic)) {
                BottomK closestK = new BottomK((DataType)new UnknownType((Object)BoxedUnit.UNIT), 5, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.String$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class));
                ArrayList result = new ArrayList();
                ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(topicsResult.entrySet().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)topicListing -> {
                    String existing = ((TopicListing)topicListing.getValue()).name();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)((double)EditDistance$.MODULE$.betweenStrings(existing, topic).total() / (double)existing.length()))), (Object)existing);
                }).foldLeft(result, (Function2 & Serializable & scala.Serializable)(cnt, elem) -> closestK.update(cnt, elem));
                closestK.finalize(result);
                throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(512).append("\n                                      |Requested topic: ").append(topic).append(" is not found in broker: ").append(bootstrap).append(".\n                                      |Either the bootstrap is incorrect or the topic is. \n                                      |\n                                      | ------ Most similar topics are ------\n                                      |\n                                      |  ").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._2(), Buffer$.MODULE$.canBuildFrom())).mkString("\n  ")).append("\n                                      |\n                                      | ------ End ------\n                                      |").toString())).stripMargin());
            }
            Predef$.MODULE$.println((Object)new StringBuilder(27).append("Found topic ").append(topic).append(" in bootstrap ").append(bootstrap).append(".").toString());
        }
        catch (Exception ex) {
            throw new RuntimeException(new StringBuilder(30).append("Failed to check for topic ").append(topic).append(" in ").append(bootstrap).toString(), ex);
        }
    }

    public void main(String[] args) {
        this.topicShouldExist(args[0], args[1]);
    }

    private TopicChecker$() {
        MODULE$ = this;
    }
}

