/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.stats;

import ai.chronon.api.Constants$;
import ai.chronon.api.StructField;
import ai.chronon.api.StructType;
import ai.chronon.online.DataMetrics;
import ai.chronon.online.SparkConversions$;
import ai.chronon.spark.Extensions$;
import ai.chronon.spark.stats.CompareMetrics$;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CompareJob$ {
    public static CompareJob$ MODULE$;

    static {
        new CompareJob$();
    }

    public void checkConsistency(Dataset<Row> leftDf, Dataset<Row> rightDf, Seq<String> keys, Map<String, String> mapping) {
        Map leftFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftDf.schema().fields())).map((Function1 & Serializable & scala.Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Map rightFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightDf.schema().fields())).map((Function1 & Serializable & scala.Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Predef$.MODULE$.assert(leftFields.size() == rightFields.size(), (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(163).append("Inconsistent number of fields; left side: ").append(leftFields.size()).append(", right side: ").append(rightFields.size()).append("\n         |Left side fields:\n         | - ").append(leftFields.mkString("\n - ")).append("\n         |\n         |Right side fields:\n         | - ").append(rightFields.mkString("\n - ")).append("\n         |").toString())).stripMargin());
        leftFields.foreach((Function1 & Serializable & scala.Serializable)leftField -> {
            CompareJob$.$anonfun$checkConsistency$4(mapping, rightFields, leftField);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(mapping.keySet().subsetOf((GenSet)leftFields.keySet()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Invalid mapping provided missing fields; provided: ").append(mapping.keySet()).append(",").append(" expected to be subset of: ").append(leftFields.keySet()).toString());
        Predef$.MODULE$.assert(mapping.values().toSet().subsetOf((GenSet)rightFields.keySet()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Invalid mapping provided missing fields; provided: ").append(mapping.values().toSet()).append(",").append(" expected to be subset of: ").append(rightFields.keySet()).toString());
        Predef$.MODULE$.assert(((SeqLike)keys.intersect((GenSeq)Constants$.MODULE$.ReservedColumns())).length() != 0, (Function0 & Serializable & scala.Serializable)() -> "Ensure that one of the key columns is a time column");
    }

    public Map<String, String> checkConsistency$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public Tuple2<Dataset<Row>, DataMetrics> compare(Dataset<Row> leftDf, Dataset<Row> rightDf, Seq<String> keys, Map<String, String> mapping) {
        this.checkConsistency(leftDf, rightDf, keys, mapping);
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(106).append("Join keys: ").append(keys.mkString(", ")).append("\n        |Left Schema:\n        |").append(Extensions$.MODULE$.StructTypeOps(leftDf.schema()).pretty()).append("\n        |\n        |Right Schema:\n        |").append(Extensions$.MODULE$.StructTypeOps(rightDf.schema()).pretty()).append("\n        |\n        |").toString())).stripMargin());
        Dataset renamedLeftDf = (Dataset)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftDf.schema().fieldNames())).foldLeft(leftDf, (Function2 & Serializable & scala.Serializable)(df, field) -> !keys.contains(field) ? df.withColumnRenamed(field, new StringBuilder(0).append((String)field).append(CompareMetrics$.MODULE$.leftSuffix()).toString()) : df);
        Extensions$.MODULE$.DataframeOps((Dataset<Row>)renamedLeftDf).validateJoinKeys(rightDf, keys);
        Dataset joinedDf = renamedLeftDf.join(rightDf, keys, "full");
        Dataset compareDf = (Dataset)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightDf.schema().fieldNames())).foldLeft((Object)joinedDf, (Function2 & Serializable & scala.Serializable)(df, field) -> !keys.contains(field) ? df.withColumnRenamed(field, new StringBuilder(0).append((String)field).append(CompareMetrics$.MODULE$.rightSuffix()).toString()) : df);
        StructType leftChrononSchema = new StructType("input", (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SparkConversions$.MODULE$.toChrononSchema(leftDf.schema()))).filterNot((Function1 & Serializable & scala.Serializable)tup -> BoxesRunTime.boxToBoolean((boolean)keys.contains(tup._1()))))).map((Function1 & Serializable & scala.Serializable)tup -> new StructField((String)tup._1(), (ai.chronon.api.DataType)tup._2()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        return CompareMetrics$.MODULE$.compute(leftChrononSchema.fields(), (Dataset<Row>)compareDf, keys, mapping, CompareMetrics$.MODULE$.compute$default$5());
    }

    public Map<String, String> compare$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ void $anonfun$checkConsistency$4(Map mapping$1, Map rightFields$1, Tuple2 leftField) {
        String rightFieldName = mapping$1.contains(leftField._1()) ? (String)mapping$1.get(leftField._1()).get() : (String)leftField._1();
        Predef$.MODULE$.assert(rightFields$1.contains((Object)rightFieldName), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Mapping column on the right table is not present; column name: ").append(rightFieldName).toString());
        DataType rightFieldType = (DataType)rightFields$1.get((Object)rightFieldName).get();
        Object object = leftField._2();
        DataType dataType = rightFieldType;
        Predef$.MODULE$.assert(!(object != null ? !object.equals(dataType) : dataType != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Comparison data types do not match; left side: ").append(leftField._2()).append(", right side: ").append(rightFieldType).toString());
    }

    private CompareJob$() {
        MODULE$ = this;
    }
}

