/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark;

import ai.chronon.spark.Extensions$;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LocalDataLoader$ {
    public static LocalDataLoader$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new LocalDataLoader$();
    }

    private Logger logger$lzycompute() {
        LocalDataLoader$ localDataLoader$ = this;
        synchronized (localDataLoader$) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger(this.getClass());
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void writeTableFromFile(File file, String tableName, SparkSession session) {
        Dataset dataset;
        this.logger().info(new StringBuilder(16).append("Checking table: ").append(tableName).toString());
        if (session.catalog().tableExists(tableName)) {
            return;
        }
        String extension = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.getName().split("\\."))).last();
        if (!((SeqLike)new .colon.colon((Object)"csv", (List)new .colon.colon((Object)"json", (List)new .colon.colon((Object)"jsonl", (List)Nil$.MODULE$)))).contains((Object)extension)) {
            this.logger().error(new StringBuilder(56).append("Unable to load file due to invalid extension from file: ").append(file.getPath()).toString());
            return;
        }
        DataFrameReader reader = session.read().option("inferSchema", "true").option("mode", FailFastMode$.MODULE$.name());
        String string = extension;
        String string2 = "csv";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            dataset = reader.option("header", true).csv(file.getPath());
        } else {
            String string3 = extension;
            String string4 = "json";
            dataset = reader.option("multiLine", !(string3 != null ? !string3.equals(string4) : string4 != null)).option("allowComments", true).json(file.getPath());
        }
        Dataset df = dataset;
        StructType schema = df.schema();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).contains((Object)"ts")) {
            DataType dataType = schema.apply(schema.fieldIndex("ts")).dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null)) {
                df = df.withColumnRenamed("ts", "ts_string").withColumn("ts", functions$.MODULE$.unix_timestamp(functions$.MODULE$.date_format(functions$.MODULE$.col("ts_string"), "yyyy-MM-dd HH:mm:ss")).$times((Object)BoxesRunTime.boxToInteger((int)1000))).drop("ts_string");
            }
        }
        this.logger().info(new StringBuilder(60).append("Loading data from ").append(file.getPath()).append(" into ").append(tableName).append(". Sample data and schema shown below").toString());
        df.show(100);
        this.logger().info(Extensions$.MODULE$.StructTypeOps(df.schema()).pretty());
        if (((SeqLike)df.schema().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())).contains((Object)"ds")) {
            df.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ds"})).saveAsTable(tableName);
        } else {
            df.write().saveAsTable(tableName);
        }
    }

    public void loadDataRecursively(File fileOrDirectory, SparkSession session, Seq<String> namespaces) {
        Predef$.MODULE$.assert(fileOrDirectory.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Non existent file: ").append(fileOrDirectory.getPath()).toString());
        Seq nsFields = namespaces.isEmpty() ? (Seq)new .colon.colon((Object)"default", (List)Nil$.MODULE$) : namespaces;
        String[] splits = fileOrDirectory.getName().split("\\.");
        if (fileOrDirectory.isDirectory()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileOrDirectory.listFiles())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                LocalDataLoader$.MODULE$.loadDataRecursively(x$2, session, (Seq<String>)((Seq)namespaces.$colon$plus((Object)fileOrDirectory.getName(), Seq$.MODULE$.canBuildFrom())));
                return BoxedUnit.UNIT;
            });
        } else {
            Tuple2 tuple2;
            Tuple2 tuple22 = tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splits)).size() == 2 ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nsFields), (Object)splits[0]) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(nsFields.$colon$plus((Object)splits[0], Seq$.MODULE$.canBuildFrom())), (Object)splits[1]);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq ns = (Seq)tuple2._1();
            String table = (String)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)ns, (Object)table);
            Tuple2 tuple24 = tuple23;
            Seq ns2 = (Seq)tuple24._1();
            String table2 = (String)tuple24._2();
            String namespace = ns2.mkString("_");
            this.loadDataFile(fileOrDirectory, session, namespace, table2);
        }
    }

    public Seq<String> loadDataRecursively$default$3() {
        return (Seq)Nil$.MODULE$;
    }

    public void loadDataFileAsTable(File file, SparkSession session, String namespaceAndTable) {
        Tuple2 tuple2;
        String[] splits = namespaceAndTable.split("\\.");
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splits)).nonEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splits)).size() <= 2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Invalid table name ").append(namespaceAndTable).toString());
        Tuple2 tuple22 = tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splits)).size() == 1 ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"default"), (Object)splits[0]) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)splits[0]), (Object)splits[1]);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String namespace = (String)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)namespace, (Object)tableName);
        Tuple2 tuple24 = tuple23;
        String namespace2 = (String)tuple24._1();
        String tableName2 = (String)tuple24._2();
        this.loadDataFile(file, session, namespace2, tableName2);
    }

    private void loadDataFile(File file, SparkSession session, String namespace, String tableName) {
        Predef$.MODULE$.assert(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Non existent file: ").append(file.getPath()).toString());
        Predef$.MODULE$.assert(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Cannot load a directory as a local table: ").append(file.getPath()).toString());
        this.logger().info(new StringBuilder(19).append("Loading file(").append(file.getPath()).append(") as ").append(namespace).append(".").append(tableName).toString());
        Object object = !session.catalog().databaseExists(namespace) ? session.sql(new StringBuilder(16).append("CREATE DATABASE ").append(namespace).toString()) : BoxedUnit.UNIT;
        this.writeTableFromFile(file, new StringBuilder(1).append(namespace).append(".").append(tableName).toString(), session);
    }

    private LocalDataLoader$() {
        MODULE$ = this;
    }
}

