/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark;

import ai.chronon.api.Constants$;
import ai.chronon.api.Extensions$;
import ai.chronon.api.Join;
import ai.chronon.spark.JoinUtils$;
import ai.chronon.spark.SemanticHashHiveMetadata;
import ai.chronon.spark.TableUtils;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.HashMap;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.ScalaJavaConversions$;

public final class SemanticHashUtils$ {
    public static SemanticHashUtils$ MODULE$;

    static {
        new SemanticHashUtils$();
    }

    public Tuple2<Seq<String>, Object> tablesToRecompute(Join joinConf, String outputTable, TableUtils tableUtils, boolean unsetSemanticHash) {
        return this.computeDiff(joinConf, outputTable, tableUtils, unsetSemanticHash, (Function3 & Serializable & scala.Serializable)(oldSemanticHash, newSemanticHash, join) -> MODULE$.tableHashesChanged((Map<String, String>)oldSemanticHash, (Map<String, String>)newSemanticHash, (Join)join), (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    public Tuple2<Object, Object> shouldRecomputeLeft(Join joinConf, String outputTable, TableUtils tableUtils, boolean unsetSemanticHash) {
        return this.computeDiff(joinConf, outputTable, tableUtils, unsetSemanticHash, (Function3)(Function3 & Serializable & scala.Serializable)(oldSemanticHash, newSemanticHash, join) -> BoxesRunTime.boxToBoolean((boolean)SemanticHashUtils$.MODULE$.isLeftHashChanged((Map<String, String>)oldSemanticHash, (Map<String, String>)newSemanticHash, join)), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false);
    }

    private boolean canAutoArchive(SemanticHashHiveMetadata semanticHashHiveMetadata) {
        return semanticHashHiveMetadata.excludeTopic();
    }

    private <T> Tuple2<T, Object> computeDiff(Join joinConf, String outputTable, TableUtils tableUtils, boolean unsetSemanticHash, Function3<Map<String, String>, Map<String, String>, Join, T> computeDiffFunc, Function0<T> emptyFunc) {
        Option<SemanticHashHiveMetadata> semanticHashHiveMetadata;
        Option<SemanticHashHiveMetadata> option = semanticHashHiveMetadata = unsetSemanticHash ? None$.MODULE$ : this.getSemanticHashFromHive(outputTable, tableUtils);
        if (semanticHashHiveMetadata.isDefined()) {
            Map<String, String> oldSemanticHash = ((SemanticHashHiveMetadata)semanticHashHiveMetadata.get()).semanticHash();
            Map newSemanticHash = Extensions$.MODULE$.JoinOps(joinConf).semanticHash(((SemanticHashHiveMetadata)semanticHashHiveMetadata.get()).excludeTopic());
            JoinUtils$.MODULE$.logger().info(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(142).append("Comparing Hashes:\n           |Hive Flag:\n           |").append(Constants$.MODULE$.SemanticHashExcludeTopic()).append(": ").append(((SemanticHashHiveMetadata)semanticHashHiveMetadata.get()).excludeTopic()).append("\n           |Old Hashes:\n           |").append(SemanticHashUtils$.prettyPrintMap$1(oldSemanticHash)).append("\n           |New Hashes:\n           |").append(SemanticHashUtils$.prettyPrintMap$1(newSemanticHash)).append("\n           |").toString())).stripMargin());
            Object diff = computeDiffFunc.apply(oldSemanticHash, (Object)newSemanticHash, (Object)joinConf);
            boolean autoArchive = this.canAutoArchive((SemanticHashHiveMetadata)semanticHashHiveMetadata.get());
            return new Tuple2(diff, (Object)BoxesRunTime.boxToBoolean((boolean)autoArchive));
        }
        if (unsetSemanticHash) {
            JoinUtils$.MODULE$.logger().info(new StringBuilder(83).append("Semantic hash has been unset for table ").append(outputTable).append(". Proceed to computation and table creation.").toString());
        } else {
            JoinUtils$.MODULE$.logger().info(new StringBuilder(76).append("No semantic hash found in table ").append(outputTable).append(". Proceed to computation and table creation.").toString());
        }
        JoinUtils$.MODULE$.logger().info(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(33).append("New Hashes:\n         |").append(SemanticHashUtils$.prettyPrintMap$1(Extensions$.MODULE$.JoinOps(joinConf).semanticHash(true))).append("\n         |").toString())).stripMargin());
        return new Tuple2(emptyFunc.apply(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    private Option<SemanticHashHiveMetadata> getSemanticHashFromHive(String outputTable, TableUtils tableUtils) {
        Gson gson = new Gson();
        if (!tableUtils.tableExists(outputTable)) {
            JoinUtils$.MODULE$.logger().info(new StringBuilder(79).append("Getting semantic hash from table ").append(outputTable).append(" which does not exist. Proceed to computation.").toString());
        }
        Option<Map<String, String>> tablePropsOpt = tableUtils.getTableProperties(outputTable);
        Option oldSemanticJsonOpt = tablePropsOpt.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.get((Object)Constants$.MODULE$.SemanticHashKey()));
        Option oldSemanticHash = oldSemanticJsonOpt.map((Function1 & Serializable & scala.Serializable)json -> ScalaJavaConversions$.MODULE$.MapOps((java.util.Map)gson.fromJson(json, HashMap.class)).toScala());
        Map oldSemanticHashOptions = (Map)tablePropsOpt.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get((Object)Constants$.MODULE$.SemanticHashOptionsKey())).map((Function1 & Serializable & scala.Serializable)m -> ScalaJavaConversions$.MODULE$.MapOps((java.util.Map)gson.fromJson(m, HashMap.class)).toScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        boolean hasSemanticHashExcludeTopicFlag = oldSemanticHashOptions.get((Object)Constants$.MODULE$.SemanticHashExcludeTopic()).contains((Object)"true");
        return oldSemanticHash.map((Function1 & Serializable & scala.Serializable)hashes -> new SemanticHashHiveMetadata((Map<String, String>)hashes, hasSemanticHashExcludeTopicFlag));
    }

    /*
     * Unable to fully structure code
     */
    private boolean isLeftHashChanged(Map<String, String> oldSemanticHash, Map<String, String> newSemanticHash, Join join) {
        if (!oldSemanticHash.contains((Object)Extensions$.MODULE$.MetadataOps(join.metaData).bootstrapTable())) ** GOTO lbl-1000
        v0 = oldSemanticHash.get((Object)Extensions$.MODULE$.MetadataOps(join.metaData).bootstrapTable());
        var5_4 = newSemanticHash.get((Object)Extensions$.MODULE$.MetadataOps(join.metaData).bootstrapTable());
        if (v0 == null ? var5_4 != null : v0.equals(var5_4) == false) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        bootstrapExistsAndChanged = v1;
        JoinUtils$.MODULE$.logger().info(new StringBuilder(25).append("Bootstrap table changed: ").append(bootstrapExistsAndChanged).toString());
        v2 = oldSemanticHash.get((Object)Extensions$.MODULE$.JoinOps(join).leftSourceKey());
        var6_6 = newSemanticHash.get((Object)Extensions$.MODULE$.JoinOps(join).leftSourceKey());
        return (v2 != null ? v2.equals(var6_6) == false : var6_6 != null) || bootstrapExistsAndChanged != false;
    }

    public Seq<String> tableHashesChanged(Map<String, String> oldSemanticHash, Map<String, String> newSemanticHash, Join join) {
        Seq seq;
        if (this.isLeftHashChanged(oldSemanticHash, newSemanticHash, join)) {
            seq = SemanticHashUtils$.partHashes$1(oldSemanticHash, join).keys().toSeq();
        } else {
            scala.collection.immutable.Iterable changed = (scala.collection.immutable.Iterable)SemanticHashUtils$.partHashes$1(newSemanticHash, join).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String newVal = (String)tuple2._2();
                Iterable iterable = Option$.MODULE$.option2Iterable(oldSemanticHash.get((Object)key).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SemanticHashUtils$.$anonfun$tableHashesChanged$3(newVal, x$3))).map((Function1 & Serializable & scala.Serializable)x$4 -> key));
                return iterable;
            }, Iterable$.MODULE$.canBuildFrom());
            Iterable deleted = (Iterable)SemanticHashUtils$.partHashes$1(oldSemanticHash, join).keys().filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)newSemanticHash.contains((Object)key)));
            seq = ((TraversableOnce)changed.$plus$plus((GenTraversableOnce)deleted, Iterable$.MODULE$.canBuildFrom())).toSeq();
        }
        Seq partsToDrop = seq;
        Iterable added = (Iterable)((TraversableLike)newSemanticHash.keys().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SemanticHashUtils$.$anonfun$tableHashesChanged$6(oldSemanticHash, x$5)))).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)SemanticHashUtils$.$anonfun$tableHashesChanged$7(join, x0$2)));
        Option option = oldSemanticHash.get((Object)Extensions$.MODULE$.JoinOps(join).derivedKey());
        Option option2 = newSemanticHash.get((Object)Extensions$.MODULE$.JoinOps(join).derivedKey());
        boolean derivedChanges = option == null ? option2 != null : !option.equals(option2);
        Some mainTable = partsToDrop.nonEmpty() || added.nonEmpty() || derivedChanges ? new Some((Object)Extensions$.MODULE$.MetadataOps(join.metaData).outputTable()) : None$.MODULE$;
        return (Seq)partsToDrop.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)mainTable), Seq$.MODULE$.canBuildFrom());
    }

    private static final String prettyPrintMap$1(Map map) {
        return ((TraversableOnce)((TraversableLike)map.toSeq().sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            String string = new StringBuilder(4).append("- ").append(key).append(": ").append(value).toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$tableHashesChanged$1(Join join$1, Tuple2 x0$1) {
        String name;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String string = name = (String)tuple2._1();
        String string2 = Extensions$.MODULE$.JoinOps(join$1).leftSourceKey();
        if (string == null) {
            if (string2 == null) return false;
        } else if (string.equals(string2)) return false;
        String string3 = name;
        String string4 = Extensions$.MODULE$.JoinOps(join$1).derivedKey();
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    private static final Map partHashes$1(Map semanticHashMap, Join join$1) {
        return (Map)semanticHashMap.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SemanticHashUtils$.$anonfun$tableHashesChanged$1(join$1, x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$tableHashesChanged$3(String newVal$1, String x$3) {
        String string = x$3;
        String string2 = newVal$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$tableHashesChanged$6(Map oldSemanticHash$1, String x$5) {
        return !oldSemanticHash$1.contains((Object)x$5);
    }

    public static final /* synthetic */ boolean $anonfun$tableHashesChanged$7(Join join$1, String x0$2) {
        String string;
        String string2 = string = x0$2;
        String string3 = Extensions$.MODULE$.MetadataOps(join$1.metaData).bootstrapTable();
        boolean bl = !(string2 != null ? !string2.equals(string3) : string3 != null) ? join$1.isSetBootstrapParts() && !join$1.bootstrapParts.isEmpty() : true;
        return bl;
    }

    private SemanticHashUtils$() {
        MODULE$ = this;
    }
}

