/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.stats;

import ai.chronon.api.Extensions$;
import ai.chronon.api.Join;
import ai.chronon.api.PartitionSpec;
import ai.chronon.api.StagingQuery;
import ai.chronon.online.DataMetrics;
import ai.chronon.online.SparkConversions$;
import ai.chronon.spark.Analyzer;
import ai.chronon.spark.Analyzer$;
import ai.chronon.spark.PartitionRange;
import ai.chronon.spark.StagingQuery$;
import ai.chronon.spark.TableUtils;
import ai.chronon.spark.TimedKvRdd;
import ai.chronon.spark.stats.CompareBaseJob$;
import ai.chronon.spark.stats.CompareJob$;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.ScalaJavaConversions$;

@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001\u0002\u0010 \u0001!B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!q\u0005A!A!\u0002\u0013\u0019\u0005\"B(\u0001\t\u0003\u0001\u0006\u0002\u0003-\u0001\u0011\u000b\u0007I\u0011A-\t\u000f\u0019\u0004!\u0019!C\u0001O\"11\u000e\u0001Q\u0001\n!Dq\u0001\u001c\u0001C\u0002\u0013\u0005Q\u000e\u0003\u0004v\u0001\u0001\u0006IA\u001c\u0005\bm\u0002\u0011\r\u0011\"\u0001x\u0011\u0019A\b\u0001)A\u0005\u0007\"9\u0011\u0010\u0001b\u0001\n\u00039\bB\u0002>\u0001A\u0003%1\tC\u0004|\u0001\t\u0007I\u0011A<\t\rq\u0004\u0001\u0015!\u0003D\u0011\u001di\bA1A\u0005\u0002]DaA \u0001!\u0002\u0013\u0019\u0005BB@\u0001\t\u0003\t\t\u0001C\u0004\u0002>\u0001!\t!a\u0010\b\u000f\u0005\u001ds\u0004#\u0001\u0002J\u00191ad\bE\u0001\u0003\u0017BaaT\f\u0005\u0002\u00055\u0003\u0002\u0003-\u0018\u0011\u000b\u0007I\u0011A-\t\u000f\u0005Es\u0003\"\u0001\u0002T!9\u0011qP\f\u0005\u0002\u0005\u0005\u0005bBAD/\u0011\u0005\u0011\u0011\u0012\u0005\n\u0003+;\u0012\u0011!C\u0005\u0003/\u0013!bQ8na\u0006\u0014XMS8c\u0015\t\u0001\u0013%A\u0003ti\u0006$8O\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\bG\"\u0014xN\\8o\u0015\u00051\u0013AA1j\u0007\u0001\u00192\u0001A\u00150!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fMB\u0011!\u0006M\u0005\u0003c-\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f!\u0002^1cY\u0016,F/\u001b7t!\t!T'D\u0001\"\u0013\t1\u0014E\u0001\u0006UC\ndW-\u0016;jYN\f\u0001B[8j]\u000e{gN\u001a\t\u0003sqj\u0011A\u000f\u0006\u0003w\r\n1!\u00199j\u0013\ti$H\u0001\u0003K_&t\u0017\u0001E:uC\u001eLgnZ)vKJL8i\u001c8g!\tI\u0004)\u0003\u0002Bu\ta1\u000b^1hS:<\u0017+^3ss\u0006I1\u000f^1si\u0012\u000bG/\u001a\t\u0003\t.s!!R%\u0011\u0005\u0019[S\"A$\u000b\u0005!;\u0013A\u0002\u001fs_>$h(\u0003\u0002KW\u00051\u0001K]3eK\u001aL!\u0001T'\u0003\rM#(/\u001b8h\u0015\tQ5&A\u0004f]\u0012$\u0015\r^3\u0002\rqJg.\u001b;?)\u0019\t6\u000bV+W/B\u0011!\u000bA\u0007\u0002?!)!G\u0002a\u0001g!)qG\u0002a\u0001q!)aH\u0002a\u0001\u007f!)!I\u0002a\u0001\u0007\")aJ\u0002a\u0001\u0007\u00061An\\4hKJ,\u0012A\u0017\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000bQa\u001d7gi)T\u0011aX\u0001\u0004_J<\u0017BA1]\u0005\u0019aunZ4fe\"\u0012qa\u0019\t\u0003U\u0011L!!Z\u0016\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018A\u0003;bE2,\u0007K]8qgV\t\u0001\u000e\u0005\u0003ES\u000e\u001b\u0015B\u00016N\u0005\ri\u0015\r]\u0001\fi\u0006\u0014G.\u001a)s_B\u001c\b%A\u0005oC6,7\u000f]1dKV\ta\u000e\u0005\u0002pi6\t\u0001O\u0003\u0002re\u0006!A.\u00198h\u0015\u0005\u0019\u0018\u0001\u00026bm\u0006L!\u0001\u00149\u0002\u00159\fW.Z:qC\u000e,\u0007%\u0001\u0005k_&tg*Y7f+\u0005\u0019\u0015!\u00036pS:t\u0015-\\3!\u0003A\u0019H/Y4j]\u001e\fV/\u001a:z\u001d\u0006lW-A\tti\u0006<\u0017N\\4Rk\u0016\u0014\u0018PT1nK\u0002\n1cY8na\u0006\u0014\u0018n]8o)\u0006\u0014G.\u001a(b[\u0016\fAcY8na\u0006\u0014\u0018n]8o)\u0006\u0014G.\u001a(b[\u0016\u0004\u0013\u0001E7fiJL7m\u001d+bE2,g*Y7f\u0003EiW\r\u001e:jGN$\u0016M\u00197f\u001d\u0006lW\rI\u0001\u0004eVtGCAA\u0002!%Q\u0013QAA\u0005\u0003\u0013\t\t$C\u0002\u0002\b-\u0012a\u0001V;qY\u0016\u001c\u0004\u0003BA\u0006\u0003WqA!!\u0004\u0002&9!\u0011qBA\u0010\u001d\u0011\t\t\"a\u0007\u000f\t\u0005M\u0011q\u0003\b\u0004\r\u0006U\u0011\"A0\n\u0007\u0005ea,\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0004E\u0005u!bAA\r=&!\u0011\u0011EA\u0012\u0003\r\u0019\u0018\u000f\u001c\u0006\u0004E\u0005u\u0011\u0002BA\u0014\u0003S\tq\u0001]1dW\u0006<WM\u0003\u0003\u0002\"\u0005\r\u0012\u0002BA\u0017\u0003_\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\t\u0005\u001d\u0012\u0011\u0006\t\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011qG\u0012\u0002\r=tG.\u001b8f\u0013\u0011\tY$!\u000e\u0003\u0017\u0011\u000bG/Y'fiJL7m]\u0001\tm\u0006d\u0017\u000eZ1uKR\u0011\u0011\u0011\t\t\u0004U\u0005\r\u0013bAA#W\t!QK\\5u\u0003)\u0019u.\u001c9be\u0016TuN\u0019\t\u0003%^\u00192aF\u00150)\t\tI\u0005\u000b\u0002\u001aG\u0006\u0019r-\u001a;D_:\u001cx\u000e\\5eCR,G\rR1uCR1\u0011QKA9\u0003k\u0002b!a\u0016\u0002`\u0005\u0015d\u0002BA-\u0003;r1ARA.\u0013\u0005a\u0013bAA\u0014W%!\u0011\u0011MA2\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\u001d2\u0006\u0005\u0004+\u0003O\u001a\u00151N\u0005\u0004\u0003SZ#A\u0002+va2,'\u0007E\u0002+\u0003[J1!a\u001c,\u0005\u0011auN\\4\t\u000f\u0005M$\u00041\u0001\u00022\u00059Q.\u001a;sS\u000e\u001c\bbBA<5\u0001\u0007\u0011\u0011P\u0001\u000ea\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u0011\u0007e\nY(C\u0002\u0002~i\u0012Q\u0002U1si&$\u0018n\u001c8Ta\u0016\u001c\u0017a\u00069sS:$\u0018I\u001c3HKR\u0014\u0015m]5d\u001b\u0016$(/[2t)\u0019\t)&a!\u0002\u0006\"9\u00111O\u000eA\u0002\u0005E\u0002bBA<7\u0001\u0007\u0011\u0011P\u0001\fO\u0016$(j\\5o\u0017\u0016L8\u000f\u0006\u0004\u0002\f\u0006E\u00151\u0013\t\u0006\u0003/\niiQ\u0005\u0005\u0003\u001f\u000b\u0019GA\u0002TKFDQa\u000e\u000fA\u0002aBQA\r\u000fA\u0002M\n1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0014\t\u0004_\u0006m\u0015bAAOa\n1qJ\u00196fGR\u0004")
public class CompareJob
implements scala.Serializable {
    private transient Logger logger;
    private final TableUtils tableUtils;
    private final Join joinConf;
    private final StagingQuery stagingQueryConf;
    private final String startDate;
    private final String endDate;
    private final Map<String, String> tableProps;
    private final String namespace;
    private final String joinName;
    private final String stagingQueryName;
    private final String comparisonTableName;
    private final String metricsTableName;
    private volatile transient boolean bitmap$trans$0;

    public static Seq<String> getJoinKeys(Join join, TableUtils tableUtils) {
        return CompareJob$.MODULE$.getJoinKeys(join, tableUtils);
    }

    public static List<Tuple2<String, Object>> printAndGetBasicMetrics(DataMetrics dataMetrics, PartitionSpec partitionSpec) {
        return CompareJob$.MODULE$.printAndGetBasicMetrics(dataMetrics, partitionSpec);
    }

    public static List<Tuple2<String, Object>> getConsolidatedData(DataMetrics dataMetrics, PartitionSpec partitionSpec) {
        return CompareJob$.MODULE$.getConsolidatedData(dataMetrics, partitionSpec);
    }

    private Logger logger$lzycompute() {
        CompareJob compareJob = this;
        synchronized (compareJob) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger(this.getClass());
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Map<String, String> tableProps() {
        return this.tableProps;
    }

    public String namespace() {
        return this.namespace;
    }

    public String joinName() {
        return this.joinName;
    }

    public String stagingQueryName() {
        return this.stagingQueryName;
    }

    public String comparisonTableName() {
        return this.comparisonTableName;
    }

    public String metricsTableName() {
        return this.metricsTableName;
    }

    public Tuple3<Dataset<Row>, Dataset<Row>, DataMetrics> run() {
        TimedKvRdd timedKvRdd;
        Dataset dataset;
        DataMetrics metrics;
        block3: {
            Tuple3<Dataset<Row>, TimedKvRdd, DataMetrics> tuple3;
            block2: {
                Predef$.MODULE$.assert(this.endDate != null, (Function0 & Serializable & scala.Serializable)() -> "End date for the comparison should not be null");
                this.validate();
                PartitionRange partitionRange = new PartitionRange(this.startDate, this.endDate, this.tableUtils);
                Dataset<Row> leftDf = this.tableUtils.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n        |SELECT *\n        |FROM ").append(Extensions$.MODULE$.MetadataOps(this.joinConf.metaData).outputTable()).append("\n        |WHERE ").append(partitionRange.betweenClauses()).append("\n        |").toString())).stripMargin());
                Dataset<Row> rightDf = this.tableUtils.sql(StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate));
                Dataset<Row> x$1 = leftDf;
                Dataset<Row> x$2 = rightDf;
                Seq<String> x$3 = CompareJob$.MODULE$.getJoinKeys(this.joinConf, this.tableUtils);
                TableUtils x$4 = this.tableUtils;
                boolean x$5 = true;
                Map<String, String> x$6 = CompareBaseJob$.MODULE$.compare$default$5();
                String x$7 = CompareBaseJob$.MODULE$.compare$default$7();
                tuple3 = CompareBaseJob$.MODULE$.compare(x$1, x$2, x$3, x$4, x$6, x$5, x$7);
                if (tuple3 == null) break block2;
                Dataset compareDf = (Dataset)tuple3._1();
                TimedKvRdd metricsTimedKvRdd = (TimedKvRdd)tuple3._2();
                metrics = (DataMetrics)tuple3._3();
                if (compareDf == null) break block2;
                dataset = compareDf;
                if (metricsTimedKvRdd == null) break block2;
                timedKvRdd = metricsTimedKvRdd;
                if (metrics != null) break block3;
            }
            throw new MatchError(tuple3);
        }
        DataMetrics dataMetrics = metrics;
        Tuple3 tuple3 = new Tuple3((Object)dataset, (Object)timedKvRdd, (Object)dataMetrics);
        Tuple3 tuple32 = tuple3;
        Dataset compareDf = (Dataset)tuple32._1();
        TimedKvRdd metricsTimedKvRdd = (TimedKvRdd)tuple32._2();
        DataMetrics metrics2 = (DataMetrics)tuple32._3();
        this.logger().info("Saving comparison output..");
        this.logger().info(new StringBuilder(18).append("Comparison schema ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compareDf.schema().fields())).map((Function1 & Serializable & scala.Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()).mkString("\n - ")).toString());
        this.tableUtils.insertUnPartitioned((Dataset<Row>)compareDf, this.comparisonTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
        this.logger().info("Saving metrics output..");
        Dataset<Row> metricsDf = metricsTimedKvRdd.toFlatDf();
        this.logger().info(new StringBuilder(15).append("Metrics schema ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metricsDf.schema().fields())).map((Function1 & Serializable & scala.Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()).mkString("\n - ")).toString());
        this.tableUtils.insertUnPartitioned(metricsDf, this.metricsTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
        this.logger().info("Printing basic comparison results..");
        this.logger().info("(Note: This is just an estimation and not a detailed analysis of results)");
        CompareJob$.MODULE$.printAndGetBasicMetrics(metrics2, this.tableUtils.partitionSpec());
        this.logger().info("Finished compare stats.");
        return new Tuple3((Object)compareDf, metricsDf, (Object)metrics2);
    }

    public void validate() {
        TableUtils x$1 = this.tableUtils;
        Join x$2 = this.joinConf;
        String x$3 = this.startDate;
        String x$4 = this.endDate;
        boolean x$5 = false;
        int x$6 = Analyzer$.MODULE$.$lessinit$greater$default$5();
        double x$7 = Analyzer$.MODULE$.$lessinit$greater$default$6();
        boolean x$8 = Analyzer$.MODULE$.$lessinit$greater$default$8();
        boolean x$9 = Analyzer$.MODULE$.$lessinit$greater$default$9();
        Analyzer analyzer = new Analyzer(x$1, x$2, x$3, x$4, x$6, x$7, x$5, x$8, x$9);
        Map joinChrononSchema = (Map)analyzer.analyzeJoin(this.joinConf, false, analyzer.analyzeJoin$default$3(), analyzer.analyzeJoin$default$4(), analyzer.analyzeJoin$default$5())._1();
        Map joinSchema = ((Map)joinChrononSchema.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            ai.chronon.api.DataType v = (ai.chronon.api.DataType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)SparkConversions$.MODULE$.fromChrononType(v));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        String finalStagingQuery = StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate);
        Map stagingQuerySchema = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tableUtils.sql(new StringBuilder(8).append(finalStagingQuery).append(" LIMIT 1").toString()).schema().fields())).map((Function1 & Serializable & scala.Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Map x$10 = joinSchema;
        Map x$11 = stagingQuerySchema;
        Seq<String> x$12 = CompareJob$.MODULE$.getJoinKeys(this.joinConf, this.tableUtils);
        TableUtils x$13 = this.tableUtils;
        boolean x$14 = true;
        Map<String, String> x$15 = CompareBaseJob$.MODULE$.checkConsistency$default$5();
        CompareBaseJob$.MODULE$.checkConsistency((Map<String, DataType>)x$10, (Map<String, DataType>)x$11, x$12, x$13, x$15, x$14);
    }

    public CompareJob(TableUtils tableUtils, Join joinConf, StagingQuery stagingQueryConf, String startDate, String endDate) {
        this.tableUtils = tableUtils;
        this.joinConf = joinConf;
        this.stagingQueryConf = stagingQueryConf;
        this.startDate = startDate;
        this.endDate = endDate;
        this.tableProps = (Map)Option$.MODULE$.apply((Object)joinConf.metaData.tableProperties).map((Function1 & Serializable & scala.Serializable)x$1 -> ScalaJavaConversions$.MODULE$.MapOps(x$1).toScala()).orNull(Predef$.MODULE$.$conforms());
        this.namespace = joinConf.metaData.outputNamespace;
        this.joinName = Extensions$.MODULE$.MetadataOps(joinConf.metaData).cleanName();
        this.stagingQueryName = Extensions$.MODULE$.MetadataOps(stagingQueryConf.metaData).cleanName();
        this.comparisonTableName = new StringBuilder(21).append(this.namespace()).append(".compare_join_query_").append(this.joinName()).append("_").append(this.stagingQueryName()).toString();
        this.metricsTableName = new StringBuilder(27).append(this.namespace()).append(".compare_stats_join_query_").append(this.joinName()).append("_").append(this.stagingQueryName()).toString();
    }
}

