/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark;

import ai.chronon.api.DataType;
import ai.chronon.api.GroupBy;
import ai.chronon.api.Join;
import ai.chronon.api.ThriftJsonCodec$;
import ai.chronon.spark.Analyzer;
import ai.chronon.spark.Analyzer$;
import ai.chronon.spark.SparkSessionBuilder$;
import ai.chronon.spark.TableUtils;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MetadataExporter$ {
    public static MetadataExporter$ MODULE$;
    private transient Logger logger;
    private final String GROUPBY_PATH_SUFFIX;
    private final String JOIN_PATH_SUFFIX;
    private final ObjectMapper mapper;
    private final TableUtils tableUtils;
    private final String today;
    private final String yesterday;
    private volatile transient boolean bitmap$trans$0;

    static {
        new MetadataExporter$();
    }

    private Logger logger$lzycompute() {
        MetadataExporter$ metadataExporter$ = this;
        synchronized (metadataExporter$) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger(this.getClass());
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public String GROUPBY_PATH_SUFFIX() {
        return this.GROUPBY_PATH_SUFFIX;
    }

    public String JOIN_PATH_SUFFIX() {
        return this.JOIN_PATH_SUFFIX;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public TableUtils tableUtils() {
        return this.tableUtils;
    }

    private String today() {
        return this.today;
    }

    private String yesterday() {
        return this.yesterday;
    }

    public Seq<String> getFilePaths(String inputPath) {
        File rootDir = new File(inputPath);
        if (!rootDir.exists()) {
            String arg$macro$1 = inputPath;
            throw new Exception(new StringOps("Directory %s does not exist!").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
        }
        ListBuffer fileBuffer = new ListBuffer();
        MetadataExporter$.traverseDirectory$1(rootDir, fileBuffer);
        return fileBuffer.toList();
    }

    public String enrichMetadata(String path) {
        Map map;
        block4: {
            Map configData = (Map)this.mapper().readValue(new File(path), Map.class);
            TableUtils x$12 = this.tableUtils();
            String x$22 = path;
            String x$3 = this.yesterday();
            String x$4 = this.today();
            boolean x$5 = true;
            boolean x$6 = true;
            int x$7 = Analyzer$.MODULE$.$lessinit$greater$default$5();
            double x$8 = Analyzer$.MODULE$.$lessinit$greater$default$6();
            boolean x$9 = Analyzer$.MODULE$.$lessinit$greater$default$7();
            Analyzer analyzer = new Analyzer(x$12, x$22, x$3, x$4, x$7, x$8, x$9, x$5, x$6);
            try {
                if (path.contains(this.GROUPBY_PATH_SUFFIX())) {
                    GroupBy groupBy = (GroupBy)ThriftJsonCodec$.MODULE$.fromJsonFile(path, false, ManifestFactory$.MODULE$.classType(GroupBy.class), ClassTag$.MODULE$.apply(GroupBy.class));
                    map = configData.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])analyzer.analyzeGroupBy(groupBy, analyzer.analyzeGroupBy$default$2(), analyzer.analyzeGroupBy$default$3(), analyzer.analyzeGroupBy$default$4(), analyzer.analyzeGroupBy$default$5())._1())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asMap(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class)))));
                    break block4;
                }
                if (path.contains(this.JOIN_PATH_SUFFIX())) {
                    Join join;
                    Join x$10 = join = (Join)ThriftJsonCodec$.MODULE$.fromJsonFile(path, false, ManifestFactory$.MODULE$.classType(Join.class), ClassTag$.MODULE$.apply(Join.class));
                    boolean x$11 = false;
                    boolean x$122 = analyzer.analyzeJoin$default$2();
                    boolean x$13 = analyzer.analyzeJoin$default$4();
                    boolean x$14 = analyzer.analyzeJoin$default$5();
                    Tuple2<Map<String, DataType>, ListBuffer<Analyzer.AggregationMetadata>> joinAnalysis = analyzer.analyzeJoin(x$10, x$122, x$11, x$13, x$14);
                    Seq featureMetadata = (Seq)((ListBuffer)joinAnalysis._2()).toSeq().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.asMap(), Seq$.MODULE$.canBuildFrom());
                    map = configData.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), (Object)featureMetadata));
                    break block4;
                }
                String arg$macro$1 = path;
                throw new Exception(new StringOps("Unknown entity type for %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
            }
            catch (Throwable exception) {
                this.logger().error(new StringBuilder(36).append("Exception while processing entity ").append(path).append(": ").append(ExceptionUtils.getStackTrace((Throwable)exception)).toString());
                map = configData;
            }
        }
        Map enrichedData = map;
        return this.mapper().writeValueAsString((Object)enrichedData);
    }

    public void writeOutput(String data, String path, String outputDirectory) {
        Files.createDirectories(Paths.get(outputDirectory, new String[0]), new FileAttribute[0]);
        File file = new File(new StringBuilder(1).append(outputDirectory).append("/").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("/"))).last()).toString());
        file.createNewFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(data);
        writer.close();
        this.logger().info(new StringBuilder(41).append(path).append(" : Wrote to output directory successfully").toString());
    }

    public void processEntities(String inputPath, String outputPath) {
        Seq processSuccess = (Seq)this.getFilePaths(inputPath).map((Function1 & Serializable & scala.Serializable)path -> {
            Tuple3 tuple3;
            try {
                String data = MODULE$.enrichMetadata((String)path);
                if (path.contains(MODULE$.GROUPBY_PATH_SUFFIX())) {
                    MODULE$.writeOutput(data, (String)path, new StringBuilder(0).append(outputPath).append(MODULE$.GROUPBY_PATH_SUFFIX()).toString());
                } else if (path.contains(MODULE$.JOIN_PATH_SUFFIX())) {
                    MODULE$.writeOutput(data, (String)path, new StringBuilder(0).append(outputPath).append(MODULE$.JOIN_PATH_SUFFIX()).toString());
                }
                tuple3 = new Tuple3(path, (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$);
            }
            catch (Throwable exception) {
                tuple3 = new Tuple3(path, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)ExceptionUtils.getStackTrace((Throwable)exception));
            }
            return tuple3;
        }, Seq$.MODULE$.canBuildFrom());
        Seq failuresAndTraces = (Seq)processSuccess.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataExporter$.$anonfun$processEntities$2(x$3)));
        this.logger().info(new StringBuilder(54).append("Successfully processed ").append(((SeqLike)processSuccess.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataExporter$.$anonfun$processEntities$3(x$4)))).length()).append(" from ").append(inputPath).append(" \n ").append("Failed to process ").append(failuresAndTraces.length()).append(": \n ").append(failuresAndTraces.mkString("\n")).toString());
    }

    public void run(String inputPath, String outputPath) {
        this.processEntities(inputPath, outputPath);
    }

    private static final void traverseDirectory$1(File currentDir, ListBuffer fileBuffer$1) {
        if (currentDir.isDirectory()) {
            File[] files = currentDir.listFiles();
            if (files != null) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).foreach((Function1 & Serializable & scala.Serializable)file -> {
                    ListBuffer listBuffer;
                    if (file.isFile()) {
                        listBuffer = fileBuffer$1.$plus$eq((Object)file.getAbsolutePath());
                    } else if (file.isDirectory()) {
                        MetadataExporter$.traverseDirectory$1(file, fileBuffer$1);
                        listBuffer = BoxedUnit.UNIT;
                    } else {
                        listBuffer = BoxedUnit.UNIT;
                    }
                    return listBuffer;
                });
            }
        } else {
            fileBuffer$1.$plus$eq((Object)currentDir.getAbsolutePath());
        }
    }

    public static final /* synthetic */ boolean $anonfun$processEntities$2(Tuple3 x$3) {
        return !BoxesRunTime.unboxToBoolean((Object)x$3._2());
    }

    public static final /* synthetic */ boolean $anonfun$processEntities$3(Tuple3 x$4) {
        return BoxesRunTime.unboxToBoolean((Object)x$4._2());
    }

    private MetadataExporter$() {
        MODULE$ = this;
        this.GROUPBY_PATH_SUFFIX = "/group_bys";
        this.JOIN_PATH_SUFFIX = "/joins";
        this.mapper = new ObjectMapper();
        this.mapper().registerModule((Module)DefaultScalaModule$.MODULE$);
        this.tableUtils = new TableUtils(SparkSessionBuilder$.MODULE$.build("metadata_exporter", SparkSessionBuilder$.MODULE$.build$default$2(), SparkSessionBuilder$.MODULE$.build$default$3(), SparkSessionBuilder$.MODULE$.build$default$4(), SparkSessionBuilder$.MODULE$.build$default$5()));
        this.today = this.tableUtils().partitionSpec().at(System.currentTimeMillis());
        this.yesterday = this.tableUtils().partitionSpec().before(this.today());
    }
}

