/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark;

import java.io.File;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.spark.package$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Properties$;

public final class SparkSessionBuilder$ {
    public static final SparkSessionBuilder$ MODULE$ = new SparkSessionBuilder$();
    private static final File DefaultWarehouseDir = new File("spark-warehouse");

    public File DefaultWarehouseDir() {
        return DefaultWarehouseDir;
    }

    public String expandUser(String path) {
        return path.replaceFirst("~", System.getProperty("user.home"));
    }

    public SparkSession build(String name, boolean local, Option<String> localWarehouseLocation) {
        SparkSession.Builder builder;
        if (local) {
            System.setSecurityManager(null);
        }
        String userName = Properties$.MODULE$.userName();
        String warehouseDir = (String)localWarehouseLocation.map((Function1 & Serializable)path -> MODULE$.expandUser((String)path)).getOrElse((Function0 & Serializable)() -> MODULE$.DefaultWarehouseDir().getAbsolutePath());
        SparkSession.Builder baseBuilder = SparkSession$.MODULE$.builder().appName(name).enableHiveSupport().config("spark.sql.session.timeZone", "UTC").config("spark.sql.sources.partitionOverwriteMode", "dynamic").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.kryo.registrator", "ai.chronon.spark.ChrononKryoRegistrator").config("spark.kryoserializer.buffer.max", "2000m").config("spark.kryo.referenceTracking", "false").config("hive.exec.dynamic.partition", "true").config("hive.exec.dynamic.partition.mode", "nonstrict").config("spark.sql.catalogImplementation", "hive").config("spark.hadoop.hive.exec.max.dynamic.partitions", 30000L);
        Object object = package$.MODULE$.SPARK_VERSION().startsWith("2") ? baseBuilder.config("spark.sql.legacy.allowCreatingManagedTableUsingNonemptyLocation", "true") : BoxedUnit.UNIT;
        if (local) {
            Predef$.MODULE$.println((Object)new StringBuilder(47).append("Building local spark session with warehouse at ").append(warehouseDir).toString());
            String metastoreDb = localWarehouseLocation.isDefined() ? new StringBuilder(50).append("jdbc:derby:;databaseName=").append(warehouseDir).append("/metastore_db;create=true").toString() : "jdbc:derby:memory:myInMemDB;create=true";
            builder = baseBuilder.master("local[*]").config("spark.kryo.registrationRequired", String.valueOf(BoxesRunTime.boxToBoolean((boolean)localWarehouseLocation.isEmpty()))).config("spark.local.dir", new StringBuilder(6).append("/tmp/").append(userName).append("/").append(name).toString()).config("spark.sql.warehouse.dir", new StringBuilder(5).append(warehouseDir).append("/data").toString()).config("spark.hadoop.javax.jdo.option.ConnectionURL", metastoreDb);
        } else {
            builder = baseBuilder;
        }
        SparkSession.Builder builder2 = builder;
        SparkSession spark = builder2.getOrCreate();
        spark.sparkContext().setLogLevel("ERROR");
        Logger.getLogger("parquet.hadoop").setLevel(Level.SEVERE);
        return spark;
    }

    public boolean build$default$2() {
        return false;
    }

    public Option<String> build$default$3() {
        return None$.MODULE$;
    }

    public SparkSession buildStreaming(boolean local) {
        String userName = Properties$.MODULE$.userName();
        SparkSession.Builder baseBuilder = SparkSession$.MODULE$.builder().config("spark.sql.session.timeZone", "UTC").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.kryo.registrator", "ai.chronon.spark.ChrononKryoRegistrator").config("spark.kryoserializer.buffer.max", "2000m").config("spark.kryo.referenceTracking", "false");
        SparkSession.Builder builder = local ? baseBuilder.master("local[*]").config("spark.local.dir", new StringBuilder(29).append("/tmp/").append(userName).append("/chronon-spark-streaming").toString()).config("spark.kryo.registrationRequired", "true") : baseBuilder;
        SparkSession spark = builder.getOrCreate();
        spark.sparkContext().setLogLevel("ERROR");
        Logger.getLogger("parquet.hadoop").setLevel(Level.SEVERE);
        return spark;
    }

    private SparkSessionBuilder$() {
    }
}

