/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.stats;

import ai.chronon.api.Constants$;
import ai.chronon.api.StructField;
import ai.chronon.api.StructType;
import ai.chronon.online.DataMetrics;
import ai.chronon.online.SparkConversions$;
import ai.chronon.spark.Extensions$;
import ai.chronon.spark.stats.CompareMetrics$;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CompareJob$ {
    public static final CompareJob$ MODULE$ = new CompareJob$();

    public void checkConsistency(Dataset<Row> leftDf, Dataset<Row> rightDf, scala.collection.immutable.Seq<String> keys, Map<String, String> mapping) {
        Map leftFields = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])leftDf.schema().fields()), (Function1 & Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map rightFields = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])rightDf.schema().fields()), (Function1 & Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Predef$.MODULE$.assert(leftFields.size() == rightFields.size(), (Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(163).append("Inconsistent number of fields; left side: ").append(leftFields.size()).append(", right side: ").append(rightFields.size()).append("\n         |Left side fields:\n         | - ").append(leftFields.mkString("\n - ")).append("\n         |\n         |Right side fields:\n         | - ").append(rightFields.mkString("\n - ")).append("\n         |").toString())));
        leftFields.foreach((Function1 & Serializable)leftField -> {
            CompareJob$.$anonfun$checkConsistency$4(mapping, rightFields, leftField);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(mapping.keySet().subsetOf((Set)leftFields.keySet()), (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(52).append("Invalid mapping provided missing fields; provided: ").append(mapping.keySet()).append(",").toString()).append(new StringBuilder(27).append(" expected to be subset of: ").append(leftFields.keySet()).toString()).toString());
        Predef$.MODULE$.assert(mapping.values().toSet().subsetOf((Set)rightFields.keySet()), (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(52).append("Invalid mapping provided missing fields; provided: ").append(mapping.values().toSet()).append(",").toString()).append(new StringBuilder(27).append(" expected to be subset of: ").append(rightFields.keySet()).toString()).toString());
        Predef$.MODULE$.assert(((SeqOps)keys.intersect((Seq)Constants$.MODULE$.ReservedColumns())).length() != 0, (Function0 & Serializable)() -> "Ensure that one of the key columns is a time column");
    }

    public Map<String, String> checkConsistency$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public Tuple2<Dataset<Row>, DataMetrics> compare(Dataset<Row> leftDf, Dataset<Row> rightDf, scala.collection.immutable.Seq<String> keys, Map<String, String> mapping) {
        this.checkConsistency(leftDf, rightDf, keys, mapping);
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(106).append("Join keys: ").append(keys.mkString(", ")).append("\n        |Left Schema:\n        |").append(Extensions$.MODULE$.StructTypeOps(leftDf.schema()).pretty()).append("\n        |\n        |Right Schema:\n        |").append(Extensions$.MODULE$.StructTypeOps(rightDf.schema()).pretty()).append("\n        |\n        |").toString())));
        Dataset renamedLeftDf = (Dataset)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])leftDf.schema().fieldNames()), leftDf, (Function2 & Serializable)(df, field) -> !keys.contains(field) ? df.withColumnRenamed(field, new StringBuilder(0).append((String)field).append(CompareMetrics$.MODULE$.leftSuffix()).toString()) : df);
        Extensions$.MODULE$.DataframeOps((Dataset<Row>)renamedLeftDf).validateJoinKeys(rightDf, (Seq<String>)keys);
        Dataset joinedDf = renamedLeftDf.join(rightDf, keys, "full");
        Dataset compareDf = (Dataset)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])rightDf.schema().fieldNames()), (Object)joinedDf, (Function2 & Serializable)(df, field) -> !keys.contains(field) ? df.withColumnRenamed(field, new StringBuilder(0).append((String)field).append(CompareMetrics$.MODULE$.rightSuffix()).toString()) : df);
        StructType leftChrononSchema = new StructType("input", (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])SparkConversions$.MODULE$.toChrononSchema(leftDf.schema())), (Function1 & Serializable)tup -> BoxesRunTime.boxToBoolean((boolean)keys.contains(tup._1())))), (Function1 & Serializable)tup -> new StructField((String)tup._1(), (ai.chronon.api.DataType)tup._2()), ClassTag$.MODULE$.apply(StructField.class)));
        return CompareMetrics$.MODULE$.compute(leftChrononSchema.fields(), (Dataset<Row>)compareDf, keys, mapping, CompareMetrics$.MODULE$.compute$default$5());
    }

    public Map<String, String> compare$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ void $anonfun$checkConsistency$4(Map mapping$1, Map rightFields$1, Tuple2 leftField) {
        String rightFieldName = mapping$1.contains(leftField._1()) ? (String)mapping$1.get(leftField._1()).get() : (String)leftField._1();
        Predef$.MODULE$.assert(rightFields$1.contains((Object)rightFieldName), (Function0 & Serializable)() -> new StringBuilder(63).append("Mapping column on the right table is not present; column name: ").append(rightFieldName).toString());
        DataType rightFieldType = (DataType)rightFields$1.get((Object)rightFieldName).get();
        Object object = leftField._2();
        DataType dataType = rightFieldType;
        Predef$.MODULE$.assert(!(object != null ? !object.equals(dataType) : dataType != null), (Function0 & Serializable)() -> new StringBuilder(61).append("Comparison data types do not match; left side: ").append(leftField._2()).append(", right side: ").append(rightFieldType).toString());
    }

    private CompareJob$() {
    }
}

