/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark;

import ai.chronon.spark.Extensions$;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class LocalDataLoader$ {
    public static final LocalDataLoader$ MODULE$ = new LocalDataLoader$();

    public void writeTableFromFile(File file, String tableName, SparkSession session) {
        Dataset dataset;
        Predef$.MODULE$.println((Object)new StringBuilder(16).append("Checking table: ").append(tableName).toString());
        if (session.catalog().tableExists(tableName)) {
            return;
        }
        String extension = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])file.getName().split("\\.")));
        if (!package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"csv", "json", "jsonl"})).contains((Object)extension)) {
            Predef$.MODULE$.println((Object)new StringBuilder(56).append("Unable to load file due to invalid extension from file: ").append(file.getPath()).toString());
            return;
        }
        DataFrameReader reader = session.read().option("inferSchema", "true").option("mode", FailFastMode$.MODULE$.name());
        String string = extension;
        String string2 = "csv";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            dataset = reader.option("header", true).csv(file.getPath());
        } else {
            String string3 = extension;
            String string4 = "json";
            dataset = reader.option("multiLine", !(string3 != null ? !string3.equals(string4) : string4 != null)).option("allowComments", true).json(file.getPath());
        }
        Dataset df = dataset;
        StructType schema = df.schema();
        if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()), (Object)"ts")) {
            DataType dataType = schema.apply(schema.fieldIndex("ts")).dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null)) {
                df = df.withColumnRenamed("ts", "ts_string").withColumn("ts", functions$.MODULE$.unix_timestamp(functions$.MODULE$.col("ts_string")).$times((Object)BoxesRunTime.boxToInteger((int)1000))).drop("ts_string");
            }
        }
        Predef$.MODULE$.println((Object)new StringBuilder(60).append("Loading data from ").append(file.getPath()).append(" into ").append(tableName).append(". Sample data and schema shown below").toString());
        df.show(100);
        Predef$.MODULE$.println((Object)Extensions$.MODULE$.StructTypeOps(df.schema()).pretty());
        if (((SeqOps)df.schema().map((Function1 & Serializable)x$1 -> x$1.name())).contains((Object)"ds")) {
            df.write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ds"})).saveAsTable(tableName);
        } else {
            df.write().saveAsTable(tableName);
        }
    }

    public void loadData(File f, SparkSession session, Seq<String> namespaces) {
        Predef$.MODULE$.assert(f.exists(), (Function0 & Serializable)() -> new StringBuilder(19).append("Non existent file: ").append(f.getPath()).toString());
        Seq nsFields = namespaces.isEmpty() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"default"})) : namespaces;
        String[] splits = f.getName().split("\\.");
        if (f.isDirectory()) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])f.listFiles()), (Function1 & Serializable)x$2 -> {
                LocalDataLoader$.MODULE$.loadData(x$2, session, (Seq<String>)((Seq)namespaces.$colon$plus((Object)f.getName())));
                return BoxedUnit.UNIT;
            });
        } else {
            Tuple2 tuple2;
            Tuple2 tuple22 = tuple2 = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])splits)) == 2 ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nsFields), (Object)splits[0]) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(nsFields.$colon$plus((Object)splits[0])), (Object)splits[1]);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq ns = (Seq)tuple2._1();
            String table = (String)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)ns, (Object)table);
            Tuple2 tuple24 = tuple23;
            Seq ns2 = (Seq)tuple24._1();
            String table2 = (String)tuple24._2();
            String namespace = ns2.mkString("_");
            Predef$.MODULE$.println((Object)new StringBuilder(6).append("File: ").append(f.getPath()).toString());
            Object object = !session.catalog().databaseExists(namespace) ? session.sql(new StringBuilder(16).append("CREATE DATABASE ").append(namespace).toString()) : BoxedUnit.UNIT;
            this.writeTableFromFile(f, new StringBuilder(1).append(namespace).append(".").append(table2).toString(), session);
        }
    }

    public Seq<String> loadData$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private LocalDataLoader$() {
    }
}

