/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.stats;

import ai.chronon.api.Constants$;
import ai.chronon.api.DataModel$;
import ai.chronon.api.Extensions$;
import ai.chronon.api.Join;
import ai.chronon.api.PartitionSpec;
import ai.chronon.api.StagingQuery;
import ai.chronon.online.DataMetrics;
import ai.chronon.online.SparkConversions$;
import ai.chronon.spark.Analyzer;
import ai.chronon.spark.Analyzer$;
import ai.chronon.spark.PartitionRange;
import ai.chronon.spark.StagingQuery$;
import ai.chronon.spark.TableUtils;
import ai.chronon.spark.stats.CompareBaseJob$;
import ai.chronon.spark.stats.CompareJob$;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.ScalaVersionSpecificCollectionsConverter$;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001B\u000e\u001d\u0001\u0015B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011!\t\u0006A!A!\u0002\u0013I\u0005\"\u0002*\u0001\t\u0003\u0019\u0006bB.\u0001\u0005\u0004%\t\u0001\u0018\u0005\u0007A\u0002\u0001\u000b\u0011B/\t\u000f\u0005\u0004!\u0019!C\u0001E\"1!\u000e\u0001Q\u0001\n\rDqa\u001b\u0001C\u0002\u0013\u0005A\u000e\u0003\u0004n\u0001\u0001\u0006I!\u0013\u0005\b]\u0002\u0011\r\u0011\"\u0001m\u0011\u0019y\u0007\u0001)A\u0005\u0013\"9\u0001\u000f\u0001b\u0001\n\u0003a\u0007BB9\u0001A\u0003%\u0011\nC\u0004s\u0001\t\u0007I\u0011\u00017\t\rM\u0004\u0001\u0015!\u0003J\u0011\u0015!\b\u0001\"\u0001v\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!!\u000e\u0001\t\u0003\t9dB\u0004\u0002@qA\t!!\u0011\u0007\rma\u0002\u0012AA\"\u0011\u0019\u0011v\u0003\"\u0001\u0002P!9\u0011\u0011K\f\u0005\u0002\u0005M\u0003\"CA;/\u0005\u0005I\u0011BA<\u0005)\u0019u.\u001c9be\u0016TuN\u0019\u0006\u0003;y\tQa\u001d;biNT!a\b\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0005\u0012\u0013aB2ie>twN\u001c\u0006\u0002G\u0005\u0011\u0011-[\u0002\u0001'\r\u0001a\u0005\f\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00055*dB\u0001\u00184\u001d\ty#'D\u00011\u0015\t\tD%\u0001\u0004=e>|GOP\u0005\u0002S%\u0011A\u0007K\u0001\ba\u0006\u001c7.Y4f\u0013\t1tG\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u00025Q\u0005QA/\u00192mKV#\u0018\u000e\\:\u0011\u0005iZT\"\u0001\u0010\n\u0005qr\"A\u0003+bE2,W\u000b^5mg\u0006A!n\\5o\u0007>tg\r\u0005\u0002@\u00056\t\u0001I\u0003\u0002BA\u0005\u0019\u0011\r]5\n\u0005\r\u0003%\u0001\u0002&pS:\f\u0001c\u001d;bO&tw-U;fef\u001cuN\u001c4\u0011\u0005}2\u0015BA$A\u00051\u0019F/Y4j]\u001e\fV/\u001a:z\u0003%\u0019H/\u0019:u\t\u0006$X\r\u0005\u0002K\u001d:\u00111\n\u0014\t\u0003_!J!!\u0014\u0015\u0002\rA\u0013X\rZ3g\u0013\ty\u0005K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001b\"\nq!\u001a8e\t\u0006$X-\u0001\u0004=S:LGO\u0010\u000b\u0007)Z;\u0006,\u0017.\u0011\u0005U\u0003Q\"\u0001\u000f\t\u000ba2\u0001\u0019A\u001d\t\u000bu2\u0001\u0019\u0001 \t\u000b\u00113\u0001\u0019A#\t\u000b!3\u0001\u0019A%\t\u000bE3\u0001\u0019A%\u0002\u0015Q\f'\r\\3Qe>\u00048/F\u0001^!\u0011Qe,S%\n\u0005}\u0003&aA'ba\u0006YA/\u00192mKB\u0013x\u000e]:!\u0003%q\u0017-\\3ta\u0006\u001cW-F\u0001d!\t!\u0017.D\u0001f\u0015\t1w-\u0001\u0003mC:<'\"\u00015\u0002\t)\fg/Y\u0005\u0003\u001f\u0016\f!B\\1nKN\u0004\u0018mY3!\u0003!Qw.\u001b8OC6,W#A%\u0002\u0013)|\u0017N\u001c(b[\u0016\u0004\u0013\u0001E:uC\u001eLgnZ)vKJLh*Y7f\u0003E\u0019H/Y4j]\u001e\fV/\u001a:z\u001d\u0006lW\rI\u0001\u0014G>l\u0007/\u0019:jg>tG+\u00192mK:\u000bW.Z\u0001\u0015G>l\u0007/\u0019:jg>tG+\u00192mK:\u000bW.\u001a\u0011\u0002!5,GO]5dgR\u000b'\r\\3OC6,\u0017!E7fiJL7m\u001d+bE2,g*Y7fA\u0005\u0019!/\u001e8\u0015\u0003Y\u0004baJ<zs\u0006u\u0011B\u0001=)\u0005\u0019!V\u000f\u001d7fgA\u0019!0a\u0006\u000f\u0007m\f\u0019BD\u0002}\u0003\u001bq1!`A\u0005\u001d\rq\u00181\u0001\b\u0003_}L!!!\u0001\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0006\u0005\u001d\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u0002%\u0019q$a\u0003\u000b\t\u0005\u0015\u0011qA\u0005\u0005\u0003\u001f\t\t\"A\u0002tc2T1aHA\u0006\u0013\r!\u0014Q\u0003\u0006\u0005\u0003\u001f\t\t\"\u0003\u0003\u0002\u001a\u0005m!!\u0003#bi\u00064%/Y7f\u0015\r!\u0014Q\u0003\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111\u0005\u0011\u0002\r=tG.\u001b8f\u0013\u0011\t9#!\t\u0003\u0017\u0011\u000bG/Y'fiJL7m]\u0001\fO\u0016$(j\\5o\u0017\u0016L8\u000f\u0006\u0003\u0002.\u0005M\u0002\u0003B\u0017\u00020%K1!!\r8\u0005\r\u0019V-\u001d\u0005\u0006{Q\u0001\rAP\u0001\tm\u0006d\u0017\u000eZ1uKR\u0011\u0011\u0011\b\t\u0004O\u0005m\u0012bAA\u001fQ\t!QK\\5u\u0003)\u0019u.\u001c9be\u0016TuN\u0019\t\u0003+^\u0019Ba\u0006\u0014\u0002FA!\u0011qIA'\u001b\t\tIEC\u0002\u0002L\u001d\f!![8\n\u0007Y\nI\u0005\u0006\u0002\u0002B\u00059\u0002O]5oi\u0006sGmR3u\u0005\u0006\u001c\u0018nY'fiJL7m\u001d\u000b\u0007\u0003+\n9'a\u001b\u0011\u000b5\n9&a\u0017\n\u0007\u0005esG\u0001\u0003MSN$\bCB\u0014\u0002^%\u000b\t'C\u0002\u0002`!\u0012a\u0001V;qY\u0016\u0014\u0004cA\u0014\u0002d%\u0019\u0011Q\r\u0015\u0003\t1{gn\u001a\u0005\b\u0003SJ\u0002\u0019AA\u000f\u0003\u001diW\r\u001e:jGNDq!!\u001c\u001a\u0001\u0004\ty'A\u0007qCJ$\u0018\u000e^5p]N\u0003Xm\u0019\t\u0004\u007f\u0005E\u0014bAA:\u0001\ni\u0001+\u0019:uSRLwN\\*qK\u000e\fAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!\u001f\u0011\u0007\u0011\fY(C\u0002\u0002~\u0015\u0014aa\u00142kK\u000e$\b")
public class CompareJob
implements Serializable {
    private final TableUtils tableUtils;
    private final Join joinConf;
    private final StagingQuery stagingQueryConf;
    private final String startDate;
    private final String endDate;
    private final Map<String, String> tableProps;
    private final String namespace;
    private final String joinName;
    private final String stagingQueryName;
    private final String comparisonTableName;
    private final String metricsTableName;

    public static List<Tuple2<String, Object>> printAndGetBasicMetrics(DataMetrics metrics, PartitionSpec partitionSpec) {
        return CompareJob$.MODULE$.printAndGetBasicMetrics(metrics, partitionSpec);
    }

    public Map<String, String> tableProps() {
        return this.tableProps;
    }

    public String namespace() {
        return this.namespace;
    }

    public String joinName() {
        return this.joinName;
    }

    public String stagingQueryName() {
        return this.stagingQueryName;
    }

    public String comparisonTableName() {
        return this.comparisonTableName;
    }

    public String metricsTableName() {
        return this.metricsTableName;
    }

    public Tuple3<Dataset<Row>, Dataset<Row>, DataMetrics> run() {
        Dataset dataset;
        Dataset dataset2;
        DataMetrics metrics;
        block3: {
            Tuple3<Dataset<Row>, Dataset<Row>, DataMetrics> tuple3;
            block2: {
                Predef$.MODULE$.assert(this.endDate != null, (Function0 & Serializable)() -> "End date for the comparison should not be null");
                this.validate();
                PartitionRange partitionRange = new PartitionRange(this.startDate, this.endDate, this.tableUtils);
                Dataset<Row> leftDf = this.tableUtils.sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n        |SELECT *\n        |FROM ").append(Extensions$.MODULE$.MetadataOps(this.joinConf.metaData).outputTable()).append("\n        |WHERE ").append(partitionRange.betweenClauses()).append("\n        |").toString())));
                Dataset<Row> rightDf = this.tableUtils.sql(StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate));
                Dataset<Row> x$1 = leftDf;
                Dataset<Row> x$2 = rightDf;
                Seq<String> x$3 = this.getJoinKeys(this.joinConf);
                TableUtils x$4 = this.tableUtils;
                boolean x$5 = true;
                Map<String, String> x$6 = CompareBaseJob$.MODULE$.compare$default$5();
                tuple3 = CompareBaseJob$.MODULE$.compare(x$1, x$2, x$3, x$4, x$6, true);
                if (tuple3 == null) break block2;
                Dataset compareDf = (Dataset)tuple3._1();
                Dataset metricsDf = (Dataset)tuple3._2();
                metrics = (DataMetrics)tuple3._3();
                if (compareDf == null) break block2;
                dataset2 = compareDf;
                if (metricsDf == null) break block2;
                dataset = metricsDf;
                if (metrics != null) break block3;
            }
            throw new MatchError(tuple3);
        }
        DataMetrics dataMetrics = metrics;
        Tuple3 tuple3 = new Tuple3((Object)dataset2, (Object)dataset, (Object)dataMetrics);
        Tuple3 tuple32 = tuple3;
        Dataset compareDf = (Dataset)tuple32._1();
        Dataset metricsDf = (Dataset)tuple32._2();
        DataMetrics metrics2 = (DataMetrics)tuple32._3();
        Predef$.MODULE$.println((Object)"Saving comparison output..");
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("Comparison schema ").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])compareDf.schema().fields()), (Function1 & Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).mkString("\n - ")).toString());
        this.tableUtils.insertUnPartitioned((Dataset<Row>)compareDf, this.comparisonTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
        Predef$.MODULE$.println((Object)"Saving metrics output..");
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("Metrics schema ").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])metricsDf.schema().fields()), (Function1 & Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).mkString("\n - ")).toString());
        this.tableUtils.insertUnPartitioned((Dataset<Row>)metricsDf, this.metricsTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
        Predef$.MODULE$.println((Object)"Printing basic comparison results..");
        Predef$.MODULE$.println((Object)"(Note: This is just an estimation and not a detailed analysis of results)");
        CompareJob$.MODULE$.printAndGetBasicMetrics(metrics2, this.tableUtils.partitionSpec());
        Predef$.MODULE$.println((Object)"Finished compare stats.");
        return new Tuple3((Object)compareDf, (Object)metricsDf, (Object)metrics2);
    }

    public Seq<String> getJoinKeys(Join joinConf) {
        List list;
        if (joinConf.isSetRowIds()) {
            list = ScalaVersionSpecificCollectionsConverter$.MODULE$.convertJavaListToScala(joinConf.rowIds);
        } else {
            String[] keyCols = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])Extensions$.MODULE$.JoinOps(joinConf).leftKeyCols()), (IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.tableUtils.partitionColumn()})), ClassTag$.MODULE$.apply(String.class));
            Enumeration.Value value = Extensions$.MODULE$.SourceOps(joinConf.left).dataModel();
            Enumeration.Value value2 = DataModel$.MODULE$.Events();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                keyCols = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])keyCols), (IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Constants$.MODULE$.TimeColumn()})), ClassTag$.MODULE$.apply(String.class));
            }
            list = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)keyCols);
        }
        return list;
    }

    public void validate() {
        TableUtils x$1 = this.tableUtils;
        Join x$2 = this.joinConf;
        String x$3 = this.startDate;
        String x$4 = this.endDate;
        boolean x$5 = false;
        int x$6 = Analyzer$.MODULE$.$lessinit$greater$default$5();
        double x$7 = Analyzer$.MODULE$.$lessinit$greater$default$6();
        boolean x$8 = Analyzer$.MODULE$.$lessinit$greater$default$8();
        Analyzer analyzer = new Analyzer(x$1, x$2, x$3, x$4, x$6, x$7, false, x$8);
        Map joinChrononSchema = (Map)analyzer.analyzeJoin(this.joinConf, false)._1();
        Map joinSchema = ((Map)joinChrononSchema.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            ai.chronon.api.DataType v = (ai.chronon.api.DataType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)SparkConversions$.MODULE$.fromChrononType(v));
            return tuple22;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        String finalStagingQuery = StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate);
        Map stagingQuerySchema = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.tableUtils.sql(new StringBuilder(8).append(finalStagingQuery).append(" LIMIT 1").toString()).schema().fields()), (Function1 & Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map x$9 = joinSchema;
        Map x$10 = stagingQuerySchema;
        Seq<String> x$11 = this.getJoinKeys(this.joinConf);
        TableUtils x$12 = this.tableUtils;
        boolean x$13 = true;
        Map<String, String> x$14 = CompareBaseJob$.MODULE$.checkConsistency$default$5();
        CompareBaseJob$.MODULE$.checkConsistency((Map<String, DataType>)x$9, (Map<String, DataType>)x$10, x$11, x$12, x$14, true);
    }

    public CompareJob(TableUtils tableUtils, Join joinConf, StagingQuery stagingQueryConf, String startDate, String endDate) {
        this.tableUtils = tableUtils;
        this.joinConf = joinConf;
        this.stagingQueryConf = stagingQueryConf;
        this.startDate = startDate;
        this.endDate = endDate;
        this.tableProps = (Map)Option$.MODULE$.apply((Object)joinConf.metaData.tableProperties).map((Function1 & Serializable)x$1 -> ScalaVersionSpecificCollectionsConverter$.MODULE$.convertJavaMapToScala(x$1).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.namespace = joinConf.metaData.outputNamespace;
        this.joinName = Extensions$.MODULE$.MetadataOps(joinConf.metaData).cleanName();
        this.stagingQueryName = Extensions$.MODULE$.MetadataOps(stagingQueryConf.metaData).cleanName();
        this.comparisonTableName = new StringBuilder(21).append(this.namespace()).append(".compare_join_query_").append(this.joinName()).append("_").append(this.stagingQueryName()).toString();
        this.metricsTableName = new StringBuilder(27).append(this.namespace()).append(".compare_stats_join_query_").append(this.joinName()).append("_").append(this.stagingQueryName()).toString();
    }
}

