/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark;

import ai.chronon.api.DataType;
import ai.chronon.api.DataType$;
import ai.chronon.api.GroupBy;
import ai.chronon.api.Join;
import ai.chronon.api.ThriftJsonCodec$;
import ai.chronon.spark.Analyzer;
import ai.chronon.spark.Analyzer$;
import ai.chronon.spark.SparkSessionBuilder$;
import ai.chronon.spark.TableUtils;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang.exception.ExceptionUtils;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class MetadataExporter$ {
    public static final MetadataExporter$ MODULE$ = new MetadataExporter$();
    private static final String GROUPBY_PATH_SUFFIX = "/group_bys";
    private static final String JOIN_PATH_SUFFIX = "/joins";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TableUtils tableUtils;
    private static final String today;
    private static final String yesterday;

    static {
        MODULE$.mapper().registerModule((Module)DefaultScalaModule$.MODULE$);
        tableUtils = new TableUtils(SparkSessionBuilder$.MODULE$.build("metadata_exporter", SparkSessionBuilder$.MODULE$.build$default$2(), SparkSessionBuilder$.MODULE$.build$default$3(), SparkSessionBuilder$.MODULE$.build$default$4()));
        today = MODULE$.tableUtils().partitionSpec().at(System.currentTimeMillis());
        yesterday = MODULE$.tableUtils().partitionSpec().before(MODULE$.today());
    }

    public String GROUPBY_PATH_SUFFIX() {
        return GROUPBY_PATH_SUFFIX;
    }

    public String JOIN_PATH_SUFFIX() {
        return JOIN_PATH_SUFFIX;
    }

    public ObjectMapper mapper() {
        return mapper;
    }

    public TableUtils tableUtils() {
        return tableUtils;
    }

    private String today() {
        return today;
    }

    private String yesterday() {
        return yesterday;
    }

    public Seq<String> getFilePaths(String inputPath) {
        File rootDir = new File(inputPath);
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])rootDir.listFiles()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataExporter$.$anonfun$getFilePaths$1(x$1)))), (Function1 & Serializable)x$2 -> x$2.listFiles(), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(File.class))), (Function1 & Serializable)x$3 -> x$3.getPath(), ClassTag$.MODULE$.apply(String.class)));
    }

    public String enrichMetadata(String path) {
        Map map;
        Map configData = (Map)this.mapper().readValue(new File(path), Map.class);
        TableUtils x$1 = this.tableUtils();
        String x$2 = path;
        String x$3 = this.yesterday();
        String x$42 = this.today();
        boolean x$52 = true;
        int x$6 = Analyzer$.MODULE$.$lessinit$greater$default$5();
        double x$7 = Analyzer$.MODULE$.$lessinit$greater$default$6();
        boolean x$8 = Analyzer$.MODULE$.$lessinit$greater$default$7();
        Analyzer analyzer = new Analyzer(x$1, x$2, x$3, x$42, x$6, x$7, x$8, true);
        try {
            if (path.contains(this.GROUPBY_PATH_SUFFIX())) {
                GroupBy groupBy = (GroupBy)ThriftJsonCodec$.MODULE$.fromJsonFile(path, false, ManifestFactory$.MODULE$.classType(GroupBy.class), ClassTag$.MODULE$.apply(GroupBy.class));
                map = (Map)configData.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])analyzer.analyzeGroupBy(groupBy, analyzer.analyzeGroupBy$default$2(), analyzer.analyzeGroupBy$default$3(), analyzer.analyzeGroupBy$default$4())), (Function1 & Serializable)x$4 -> x$4.asMap(), ClassTag$.MODULE$.apply(Map.class))));
            } else {
                Join join = (Join)ThriftJsonCodec$.MODULE$.fromJsonFile(path, false, ManifestFactory$.MODULE$.classType(Join.class), ClassTag$.MODULE$.apply(Join.class));
                Tuple3<Map<String, DataType>, ListBuffer<Analyzer.AggregationMetadata>, Map<String, DataType>> joinAnalysis = analyzer.analyzeJoin(join, analyzer.analyzeJoin$default$2());
                Seq featureMetadata = (Seq)((IterableOnceOps)joinAnalysis._2()).toSeq().map((Function1 & Serializable)x$5 -> x$5.asMap());
                Map statsSchema = (Map)((MapOps)joinAnalysis._3()).map((Function1 & Serializable)st -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(st._1()), (Object)DataType$.MODULE$.toString((DataType)st._2())));
                map = (Map)configData.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), (Object)featureMetadata)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stats"), (Object)statsSchema));
            }
        }
        catch (Throwable exception) {
            Predef$.MODULE$.println((Object)new StringBuilder(36).append("Exception while processing entity ").append(path).append(": ").append(ExceptionUtils.getStackTrace((Throwable)exception)).toString());
            map = configData;
        }
        Map enrichedData = map;
        return this.mapper().writeValueAsString((Object)enrichedData);
    }

    public void writeOutput(String data, String path, String outputDirectory) {
        Files.createDirectories(Paths.get(outputDirectory, new String[0]), new FileAttribute[0]);
        File file = new File(new StringBuilder(1).append(outputDirectory).append("/").append(ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])path.split("/")))).toString());
        file.createNewFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(data);
        writer.close();
        Predef$.MODULE$.println((Object)new StringBuilder(41).append(path).append(" : Wrote to output directory successfully").toString());
    }

    public void processEntities(String inputPath, String outputPath, String suffix) {
        Seq processSuccess = (Seq)this.getFilePaths(new StringBuilder(0).append(inputPath).append(suffix).toString()).map((Function1 & Serializable)path -> {
            Tuple3 tuple3;
            try {
                String data = MODULE$.enrichMetadata((String)path);
                MODULE$.writeOutput(data, (String)path, new StringBuilder(0).append(outputPath).append(suffix).toString());
                tuple3 = new Tuple3(path, (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$);
            }
            catch (Throwable exception) {
                tuple3 = new Tuple3(path, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)ExceptionUtils.getStackTrace((Throwable)exception));
            }
            return tuple3;
        });
        Seq failuresAndTraces = (Seq)processSuccess.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetadataExporter$.$anonfun$processEntities$2(x$6)));
        Predef$.MODULE$.println((Object)new StringBuilder(0).append(new StringBuilder(32).append("Successfully processed ").append(((SeqOps)processSuccess.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MetadataExporter$.$anonfun$processEntities$3(x$7)))).length()).append(" from ").append(suffix).append(" \n ").toString()).append(new StringBuilder(22).append("Failed to process ").append(failuresAndTraces.length()).append(": \n ").append(failuresAndTraces.mkString("\n")).toString()).toString());
    }

    public void run(String inputPath, String outputPath) {
        this.processEntities(inputPath, outputPath, this.GROUPBY_PATH_SUFFIX());
        this.processEntities(inputPath, outputPath, this.JOIN_PATH_SUFFIX());
    }

    public static final /* synthetic */ boolean $anonfun$getFilePaths$1(File x$1) {
        return !x$1.isFile();
    }

    public static final /* synthetic */ boolean $anonfun$processEntities$2(Tuple3 x$6) {
        return !BoxesRunTime.unboxToBoolean((Object)x$6._2());
    }

    public static final /* synthetic */ boolean $anonfun$processEntities$3(Tuple3 x$7) {
        return BoxesRunTime.unboxToBoolean((Object)x$7._2());
    }

    private MetadataExporter$() {
    }
}

