/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.stats;

import ai.chronon.api.Constants$;
import ai.chronon.api.StructField;
import ai.chronon.api.StructType;
import ai.chronon.online.DataMetrics;
import ai.chronon.online.SparkConversions$;
import ai.chronon.spark.Extensions$;
import ai.chronon.spark.TableUtils;
import ai.chronon.spark.stats.CompareMetrics$;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CompareBaseJob$ {
    public static final CompareBaseJob$ MODULE$ = new CompareBaseJob$();

    public void checkConsistency(Map<String, DataType> leftFields, Map<String, DataType> rightFields, scala.collection.immutable.Seq<String> keys, TableUtils tableUtils, Map<String, String> mapping, boolean migrationCheck) {
        ListBuffer errors = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        boolean sizeCheck = migrationCheck ? leftFields.size() >= rightFields.size() : leftFields.size() == rightFields.size();
        Object object = !sizeCheck ? errors.$plus$eq((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(205).append("Inconsistent number of fields; left side: ").append(leftFields.size()).append(", right side: ").append(rightFields.size()).append("\n                |Left side fields:\n                | - ").append(((IterableOnceOps)leftFields.toSeq().sortBy((Function1 & Serializable)x$1 -> (String)x$1._1(), (Ordering)Ordering.String$.MODULE$)).mkString("\n - ")).append("\n                |\n                |Right side fields:\n                | - ").append(((IterableOnceOps)rightFields.toSeq().sortBy((Function1 & Serializable)x$2 -> (String)x$2._1(), (Ordering)Ordering.String$.MODULE$)).mkString("\n - ")).append("\n                |").toString()))) : BoxedUnit.UNIT;
        Map reverseMapping = (Map)mapping.map((Function1 & Serializable)x$3 -> x$3.swap());
        rightFields.foreach((Function1 & Serializable)rightField -> {
            Object object;
            String leftFieldName;
            String string = leftFieldName = reverseMapping.contains(rightField._1()) ? (String)reverseMapping.get(rightField._1()).get() : (String)rightField._1();
            if (leftFields.contains((Object)leftFieldName)) {
                DataType leftFieldType = (DataType)leftFields.get((Object)leftFieldName).get();
                Object object2 = rightField._2();
                DataType dataType = leftFieldType;
                object = (object2 == null ? dataType != null : !object2.equals(dataType)) ? errors.$plus$eq((Object)new StringBuilder(0).append(new StringBuilder(49).append("Comparison data types do not match for column '").append(leftFieldName).append("';").toString()).append(new StringBuilder(26).append(" left side: ").append(leftFieldType).append(", right side: ").append(rightField._2()).toString()).toString()) : BoxedUnit.UNIT;
            } else {
                object = errors.$plus$eq((Object)new StringBuilder(62).append("Mapping column on the left table is not present; column name: ").append(leftFieldName).toString());
            }
            return object;
        });
        Object object2 = mapping.size() != reverseMapping.size() ? errors.$plus$eq((Object)new StringBuilder(57).append("Mapping values contain duplicate values. Keys: ").append(mapping.keys()).append(", Values: ").append(mapping.values()).toString()) : BoxedUnit.UNIT;
        Object object3 = !mapping.keySet().subsetOf((Set)leftFields.keySet()) ? errors.$plus$eq((Object)new StringBuilder(0).append(new StringBuilder(52).append("Invalid mapping provided missing fields; provided: ").append(mapping.keySet()).append(",").toString()).append(new StringBuilder(27).append(" expected to be subset of: ").append(leftFields.keySet()).toString()).toString()) : BoxedUnit.UNIT;
        Object object4 = !mapping.values().toSet().subsetOf((Set)rightFields.keySet()) ? errors.$plus$eq((Object)new StringBuilder(0).append(new StringBuilder(52).append("Invalid mapping provided missing fields; provided: ").append(mapping.values().toSet()).append(",").toString()).append(new StringBuilder(27).append(" expected to be subset of: ").append(rightFields.keySet()).toString()).toString()) : BoxedUnit.UNIT;
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{leftFields, rightFields})).foreach((Function1 & Serializable)kset -> !keys.toSet().subsetOf((Set)kset.keySet()) ? errors.$plus$eq((Object)new StringBuilder(0).append(new StringBuilder(73).append("Some of the primary keys are missing in the source dataframe; provided: ").append(keys).append(",").toString()).append(new StringBuilder(27).append(" expected to be subset of: ").append(kset.keySet()).toString()).toString()) : BoxedUnit.UNIT);
        Object object5 = ((SeqOps)keys.intersect((Seq)Constants$.MODULE$.ReservedColumns(tableUtils.partitionColumn()))).length() == 0 ? errors.$plus$eq((Object)"Ensure that one of the key columns is a time column") : BoxedUnit.UNIT;
        Predef$.MODULE$.assert(errors.size() == 0, (Function0 & Serializable)() -> errors.mkString("\n-----------------------------------------------------------------\n"));
    }

    public Map<String, String> checkConsistency$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean checkConsistency$default$6() {
        return false;
    }

    public Tuple3<Dataset<Row>, Dataset<Row>, DataMetrics> compare(Dataset<Row> leftDf, Dataset<Row> rightDf, scala.collection.immutable.Seq<String> keys, TableUtils tableUtils, Map<String, String> mapping, boolean migrationCheck) {
        Map leftFields = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])leftDf.schema().fields()), (Function1 & Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map rightFields = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])rightDf.schema().fields()), (Function1 & Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.checkConsistency((Map<String, DataType>)leftFields, (Map<String, DataType>)rightFields, keys, tableUtils, mapping, migrationCheck);
        ListBuffer prunedColumns = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Dataset prunedLeftDf = migrationCheck ? (Dataset)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])leftDf.schema().fieldNames()), leftDf, (Function2 & Serializable)(df, field) -> {
            Dataset dataset;
            String rightFieldName;
            String string = rightFieldName = mapping.contains(field) ? (String)mapping.get(field).get() : field;
            if (!rightFields.contains((Object)rightFieldName)) {
                prunedColumns.$plus$eq(field);
                dataset = df.drop(field);
            } else {
                dataset = df;
            }
            return dataset;
        }) : leftDf;
        Predef$.MODULE$.println((Object)new StringBuilder(64).append("Pruning fields from the left source for equivalent comparison - ").append(prunedColumns.mkString(",")).toString());
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(106).append("Join keys: ").append(keys.mkString(", ")).append("\n        |Left Schema:\n        |").append(Extensions$.MODULE$.StructTypeOps(prunedLeftDf.schema()).pretty()).append("\n        |\n        |Right Schema:\n        |").append(Extensions$.MODULE$.StructTypeOps(rightDf.schema()).pretty()).append("\n        |\n        |").toString())));
        Dataset renamedLeftDf = (Dataset)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])prunedLeftDf.schema().fieldNames()), (Object)prunedLeftDf, (Function2 & Serializable)(df, field) -> !keys.contains(field) ? df.withColumnRenamed(field, new StringBuilder(0).append((String)field).append(CompareMetrics$.MODULE$.leftSuffix()).toString()) : df);
        Extensions$.MODULE$.DataframeOps((Dataset<Row>)renamedLeftDf).validateJoinKeys(rightDf, (Seq<String>)keys);
        Dataset joinedDf = renamedLeftDf.join(rightDf, keys, "full");
        Dataset compareDf = (Dataset)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])rightDf.schema().fieldNames()), (Object)joinedDf, (Function2 & Serializable)(df, field) -> !keys.contains(field) ? df.withColumnRenamed(field, new StringBuilder(0).append((String)field).append(CompareMetrics$.MODULE$.rightSuffix()).toString()) : df);
        StructType leftChrononSchema = new StructType("input", (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])SparkConversions$.MODULE$.toChrononSchema(prunedLeftDf.schema())), (Function1 & Serializable)tup -> BoxesRunTime.boxToBoolean((boolean)keys.contains(tup._1())))), (Function1 & Serializable)tup -> new StructField((String)tup._1(), (ai.chronon.api.DataType)tup._2()), ClassTag$.MODULE$.apply(StructField.class)));
        Tuple2<Dataset<Row>, DataMetrics> tuple2 = CompareMetrics$.MODULE$.compute(leftChrononSchema.fields(), (Dataset<Row>)compareDf, keys, mapping, CompareMetrics$.MODULE$.compute$default$5());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Dataset metricsDf = (Dataset)tuple2._1();
        DataMetrics metrics = (DataMetrics)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metricsDf, (Object)metrics);
        Tuple2 tuple23 = tuple22;
        Dataset metricsDf2 = (Dataset)tuple23._1();
        DataMetrics metrics2 = (DataMetrics)tuple23._2();
        return new Tuple3((Object)compareDf, (Object)metricsDf2, (Object)metrics2);
    }

    public Map<String, String> compare$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean compare$default$6() {
        return false;
    }

    private CompareBaseJob$() {
    }
}

