/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark;

import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.spark.package$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Properties$;

public final class SparkSessionBuilder$ {
    public static final SparkSessionBuilder$ MODULE$ = new SparkSessionBuilder$();
    private static transient Logger logger;
    private static final String warehouseId;
    private static final File DefaultWarehouseDir;
    private static volatile transient boolean bitmap$trans$0;

    static {
        warehouseId = StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(UUID.randomUUID().toString()), 6);
        DefaultWarehouseDir = new File(new StringBuilder(29).append("/tmp/chronon/spark-warehouse_").append(MODULE$.warehouseId()).toString());
    }

    private Logger logger$lzycompute() {
        SparkSessionBuilder$ sparkSessionBuilder$ = this;
        synchronized (sparkSessionBuilder$) {
            if (!bitmap$trans$0) {
                logger = LoggerFactory.getLogger(this.getClass());
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    private Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    private String warehouseId() {
        return warehouseId;
    }

    private File DefaultWarehouseDir() {
        return DefaultWarehouseDir;
    }

    public String expandUser(String path) {
        return path.replaceFirst("~", System.getProperty("user.home"));
    }

    public SparkSession build(String name, boolean local, Option<String> localWarehouseLocation, Option<Map<String, String>> additionalConfig, boolean enforceKryoSerializer) {
        SparkSession.Builder builder;
        if (local) {
            System.setSecurityManager(null);
        }
        String userName = Properties$.MODULE$.userName();
        String warehouseDir = (String)localWarehouseLocation.map((Function1 & Serializable)path -> MODULE$.expandUser((String)path)).getOrElse((Function0 & Serializable)() -> MODULE$.DefaultWarehouseDir().getAbsolutePath());
        ObjectRef baseBuilder = ObjectRef.create((Object)SparkSession$.MODULE$.builder().appName(name).enableHiveSupport().config("spark.sql.session.timeZone", "UTC").config("spark.sql.sources.partitionOverwriteMode", "dynamic").config("hive.exec.dynamic.partition", "true").config("hive.exec.dynamic.partition.mode", "nonstrict").config("spark.sql.catalogImplementation", "hive").config("spark.hadoop.hive.exec.max.dynamic.partitions", 30000L).config("spark.sql.legacy.timeParserPolicy", "LEGACY"));
        Object object = enforceKryoSerializer ? ((SparkSession.Builder)baseBuilder.elem).config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.kryo.registrator", "ai.chronon.spark.ChrononKryoRegistrator").config("spark.kryoserializer.buffer.max", "2000m").config("spark.kryo.referenceTracking", "false") : BoxedUnit.UNIT;
        additionalConfig.foreach((Function1 & Serializable)configMap -> {
            configMap.foreach((Function1 & Serializable)config -> {
                baseBuilder$1.elem = ((SparkSession.Builder)baseBuilder$1.elem).config((String)config._1(), (String)config._2());
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        Object object2 = package$.MODULE$.SPARK_VERSION().startsWith("2") ? ((SparkSession.Builder)baseBuilder.elem).config("spark.sql.legacy.allowCreatingManagedTableUsingNonemptyLocation", "true") : BoxedUnit.UNIT;
        if (local) {
            this.logger().info(new StringBuilder(47).append("Building local spark session with warehouse at ").append(warehouseDir).toString());
            String metastoreDb = new StringBuilder(50).append("jdbc:derby:;databaseName=").append(warehouseDir).append("/metastore_db;create=true").toString();
            builder = ((SparkSession.Builder)baseBuilder.elem).master("local[*]").config("spark.kryo.registrationRequired", String.valueOf(BoxesRunTime.boxToBoolean((boolean)localWarehouseLocation.isEmpty()))).config("spark.local.dir", new StringBuilder(6).append("/tmp/").append(userName).append("/").append(name).toString()).config("spark.sql.warehouse.dir", new StringBuilder(5).append(warehouseDir).append("/data").toString()).config("spark.hadoop.javax.jdo.option.ConnectionURL", metastoreDb).config("spark.driver.bindAddress", "127.0.0.1");
        } else {
            builder = (SparkSession.Builder)baseBuilder.elem;
        }
        SparkSession.Builder builder2 = builder;
        SparkSession spark = builder2.getOrCreate();
        spark.sparkContext().setLogLevel("ERROR");
        java.util.logging.Logger.getLogger("parquet.hadoop").setLevel(Level.SEVERE);
        return spark;
    }

    public boolean build$default$2() {
        return false;
    }

    public Option<String> build$default$3() {
        return None$.MODULE$;
    }

    public Option<Map<String, String>> build$default$4() {
        return None$.MODULE$;
    }

    public boolean build$default$5() {
        return true;
    }

    public SparkSession buildStreaming(boolean local) {
        String userName = Properties$.MODULE$.userName();
        SparkSession.Builder baseBuilder = SparkSession$.MODULE$.builder().config("spark.sql.session.timeZone", "UTC").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.kryo.registrator", "ai.chronon.spark.ChrononKryoRegistrator").config("spark.kryoserializer.buffer.max", "2000m").config("spark.kryo.referenceTracking", "false").config("spark.sql.legacy.timeParserPolicy", "LEGACY");
        SparkSession.Builder builder = local ? baseBuilder.master("local[*]").config("spark.local.dir", new StringBuilder(29).append("/tmp/").append(userName).append("/chronon-spark-streaming").toString()).config("spark.kryo.registrationRequired", "true") : baseBuilder;
        SparkSession spark = builder.getOrCreate();
        spark.sparkContext().setLogLevel("ERROR");
        java.util.logging.Logger.getLogger("parquet.hadoop").setLevel(Level.SEVERE);
        return spark;
    }

    private SparkSessionBuilder$() {
    }
}

