/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark;

import ai.chronon.api.DataType;
import ai.chronon.api.GroupBy;
import ai.chronon.api.Join;
import ai.chronon.api.ThriftJsonCodec$;
import ai.chronon.online.Metrics;
import ai.chronon.spark.Analyzer;
import ai.chronon.spark.Analyzer$;
import ai.chronon.spark.SparkSessionBuilder$;
import ai.chronon.spark.TableUtils;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class MetadataExporter$ {
    public static final MetadataExporter$ MODULE$ = new MetadataExporter$();
    private static transient Logger logger;
    private static final String GROUPBY_PATH_SUFFIX;
    private static final String JOIN_PATH_SUFFIX;
    private static final ObjectMapper mapper;
    private static final TableUtils tableUtils;
    private static final String today;
    private static final String yesterday;
    private static volatile transient boolean bitmap$trans$0;

    static {
        GROUPBY_PATH_SUFFIX = "/group_bys";
        JOIN_PATH_SUFFIX = "/joins";
        mapper = new ObjectMapper();
        MODULE$.mapper().registerModule((Module)DefaultScalaModule$.MODULE$);
        tableUtils = new TableUtils(SparkSessionBuilder$.MODULE$.build("metadata_exporter", SparkSessionBuilder$.MODULE$.build$default$2(), SparkSessionBuilder$.MODULE$.build$default$3(), SparkSessionBuilder$.MODULE$.build$default$4(), SparkSessionBuilder$.MODULE$.build$default$5()));
        today = MODULE$.tableUtils().partitionSpec().at(System.currentTimeMillis());
        yesterday = MODULE$.tableUtils().partitionSpec().before(MODULE$.today());
    }

    private Logger logger$lzycompute() {
        MetadataExporter$ metadataExporter$ = this;
        synchronized (metadataExporter$) {
            if (!bitmap$trans$0) {
                logger = LoggerFactory.getLogger(this.getClass());
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    public String GROUPBY_PATH_SUFFIX() {
        return GROUPBY_PATH_SUFFIX;
    }

    public String JOIN_PATH_SUFFIX() {
        return JOIN_PATH_SUFFIX;
    }

    public ObjectMapper mapper() {
        return mapper;
    }

    public TableUtils tableUtils() {
        return tableUtils;
    }

    private String today() {
        return today;
    }

    private String yesterday() {
        return yesterday;
    }

    public Seq<String> getFilePaths(String inputPath) {
        File rootDir = new File(inputPath);
        if (!rootDir.exists()) {
            String arg$macro$1 = inputPath;
            throw new Exception(StringOps$.MODULE$.format$extension("Directory %s does not exist!", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
        }
        ListBuffer fileBuffer = new ListBuffer();
        MetadataExporter$.traverseDirectory$1(rootDir, fileBuffer);
        return fileBuffer.toList();
    }

    public String enrichMetadata(String path) {
        Map map;
        Map map2;
        Map configData = (Map)this.mapper().readValue(new File(path), Map.class);
        TableUtils x$12 = this.tableUtils();
        String x$22 = path;
        String x$3 = this.yesterday();
        String x$4 = this.today();
        boolean x$5 = true;
        boolean x$6 = true;
        int x$7 = Analyzer$.MODULE$.$lessinit$greater$default$5();
        double x$8 = Analyzer$.MODULE$.$lessinit$greater$default$6();
        boolean x$9 = Analyzer$.MODULE$.$lessinit$greater$default$7();
        Analyzer analyzer = new Analyzer(x$12, x$22, x$3, x$4, x$7, x$8, x$9, true, true);
        String string = path;
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (string.contains(this.GROUPBY_PATH_SUFFIX())) {
            try {
                GroupBy groupBy = (GroupBy)ThriftJsonCodec$.MODULE$.fromJsonFile(path, false, ManifestFactory$.MODULE$.classType(GroupBy.class), ClassTag$.MODULE$.apply(GroupBy.class));
                try {
                    Map[] featureMetadata = (Map[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])analyzer.analyzeGroupBy(groupBy, analyzer.analyzeGroupBy$default$2(), analyzer.analyzeGroupBy$default$3(), analyzer.analyzeGroupBy$default$4(), analyzer.analyzeGroupBy$default$5(), analyzer.analyzeGroupBy$default$6())._1()), (Function1 & Serializable)x$1 -> x$1.asMap(), ClassTag$.MODULE$.apply(Map.class));
                    map2 = (Map)configData.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), (Object)featureMetadata));
                }
                catch (Throwable exception) {
                    Metrics.Context context = Metrics.Context$.MODULE$.apply(Metrics.Environment$.MODULE$.groupByMetadataExport(), groupBy);
                    context.incrementException(exception, this.logger());
                    map2 = this.handleException$1(exception, "group_by", path, configData);
                }
            }
            catch (Throwable exception) {
                map2 = this.handleException$1(exception, "group_by", path, configData);
            }
        } else if (string.contains(this.JOIN_PATH_SUFFIX())) {
            try {
                Join join = (Join)ThriftJsonCodec$.MODULE$.fromJsonFile(path, false, ManifestFactory$.MODULE$.classType(Join.class), ClassTag$.MODULE$.apply(Join.class));
                try {
                    Join x$10 = join;
                    boolean x$11 = false;
                    boolean x$122 = analyzer.analyzeJoin$default$2();
                    boolean x$13 = analyzer.analyzeJoin$default$4();
                    boolean x$14 = analyzer.analyzeJoin$default$5();
                    Tuple2<Map<String, DataType>, ListBuffer<Analyzer.AggregationMetadata>> joinAnalysis = analyzer.analyzeJoin(x$10, x$122, false, x$13, x$14);
                    Seq featureMetadata = (Seq)((IterableOnceOps)joinAnalysis._2()).toSeq().map((Function1 & Serializable)x$2 -> x$2.asMap());
                    map2 = (Map)configData.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), (Object)featureMetadata));
                }
                catch (Throwable exception) {
                    Metrics.Context context = Metrics.Context$.MODULE$.apply(Metrics.Environment$.MODULE$.joinMetadataExport(), join);
                    context.incrementException(exception, this.logger());
                    map2 = this.handleException$1(exception, "join", path, configData);
                }
            }
            catch (Throwable exception) {
                map2 = this.handleException$1(exception, "join", path, configData);
            }
        } else {
            String errorMessage = new StringBuilder(24).append("Unknown entity type for ").append(path).toString();
            this.logger().error(errorMessage);
            map2 = (Map)configData.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)errorMessage));
        }
        Map enrichedData = map = map2;
        return this.mapper().writeValueAsString((Object)enrichedData);
    }

    public void writeOutput(String data, String path, String outputDirectory) {
        Files.createDirectories(Paths.get(outputDirectory, new String[0]), new FileAttribute[0]);
        File file = new File(new StringBuilder(1).append(outputDirectory).append("/").append(ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])path.split("/")))).toString());
        file.createNewFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(data);
        writer.close();
        this.logger().info(new StringBuilder(41).append(path).append(" : Wrote to output directory successfully").toString());
    }

    public void processEntities(String inputPath, String outputPath) {
        Seq processSuccess = (Seq)this.getFilePaths(inputPath).map((Function1 & Serializable)path -> {
            Tuple3 tuple3;
            try {
                String data = MODULE$.enrichMetadata((String)path);
                if (path.contains(MODULE$.GROUPBY_PATH_SUFFIX())) {
                    MODULE$.writeOutput(data, (String)path, new StringBuilder(0).append(outputPath).append(MODULE$.GROUPBY_PATH_SUFFIX()).toString());
                } else if (path.contains(MODULE$.JOIN_PATH_SUFFIX())) {
                    MODULE$.writeOutput(data, (String)path, new StringBuilder(0).append(outputPath).append(MODULE$.JOIN_PATH_SUFFIX()).toString());
                }
                tuple3 = new Tuple3(path, (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$);
            }
            catch (Throwable exception) {
                tuple3 = new Tuple3(path, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)ExceptionUtils.getStackTrace((Throwable)exception));
            }
            return tuple3;
        });
        Seq failuresAndTraces = (Seq)processSuccess.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataExporter$.$anonfun$processEntities$2(x$3)));
        this.logger().info(new StringBuilder(0).append(new StringBuilder(32).append("Successfully processed ").append(((SeqOps)processSuccess.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataExporter$.$anonfun$processEntities$3(x$4)))).length()).append(" from ").append(inputPath).append(" \n ").toString()).append(new StringBuilder(22).append("Failed to process ").append(failuresAndTraces.length()).append(": \n ").append(failuresAndTraces.mkString("\n")).toString()).toString());
    }

    public void run(String inputPath, String outputPath) {
        this.processEntities(inputPath, outputPath);
    }

    private static final void traverseDirectory$1(File currentDir, ListBuffer fileBuffer$1) {
        if (currentDir.isDirectory()) {
            File[] files = currentDir.listFiles();
            if (files != null) {
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)file -> {
                    Growable growable;
                    if (file.isFile()) {
                        growable = fileBuffer$1.$plus$eq((Object)file.getAbsolutePath());
                    } else if (file.isDirectory()) {
                        MetadataExporter$.traverseDirectory$1(file, fileBuffer$1);
                        growable = BoxedUnit.UNIT;
                    } else {
                        growable = BoxedUnit.UNIT;
                    }
                    return growable;
                });
            }
        } else {
            fileBuffer$1.$plus$eq((Object)currentDir.getAbsolutePath());
        }
    }

    private final Map handleException$1(Throwable exception, String entityType, String path$1, Map configData$1) {
        String exceptionMessage = ExceptionUtils.getStackTrace((Throwable)exception);
        this.logger().error(new StringBuilder(30).append("Exception while processing ").append(entityType).append(" ").append(path$1).append(": ").append(exceptionMessage).toString());
        return (Map)configData$1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)exception.getMessage()));
    }

    public static final /* synthetic */ boolean $anonfun$processEntities$2(Tuple3 x$3) {
        return !BoxesRunTime.unboxToBoolean((Object)x$3._2());
    }

    public static final /* synthetic */ boolean $anonfun$processEntities$3(Tuple3 x$4) {
        return BoxesRunTime.unboxToBoolean((Object)x$4._2());
    }

    private MetadataExporter$() {
    }
}

