/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.stats;

import ai.chronon.api.Extensions$;
import ai.chronon.api.Join;
import ai.chronon.api.PartitionSpec;
import ai.chronon.api.StagingQuery;
import ai.chronon.online.DataMetrics;
import ai.chronon.online.SparkConversions$;
import ai.chronon.spark.Analyzer;
import ai.chronon.spark.Analyzer$;
import ai.chronon.spark.PartitionRange;
import ai.chronon.spark.StagingQuery$;
import ai.chronon.spark.TableUtils;
import ai.chronon.spark.TimedKvRdd;
import ai.chronon.spark.stats.CompareBaseJob$;
import ai.chronon.spark.stats.CompareJob$;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.ScalaJavaConversions$;

@ScalaSignature(bytes="\u0006\u0005\u0005%f\u0001\u0002\u0010 \u0001!B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!!\u0006A!A!\u0002\u0013a\u0005\"B+\u0001\t\u00031\u0006\u0002\u00030\u0001\u0011\u000b\u0007I\u0011A0\t\u000f1\u0004!\u0019!C\u0001[\"1\u0011\u000f\u0001Q\u0001\n9DqA\u001d\u0001C\u0002\u0013\u00051\u000f\u0003\u0004|\u0001\u0001\u0006I\u0001\u001e\u0005\by\u0002\u0011\r\u0011\"\u0001~\u0011\u0019q\b\u0001)A\u0005\u0019\"9q\u0010\u0001b\u0001\n\u0003i\bbBA\u0001\u0001\u0001\u0006I\u0001\u0014\u0005\t\u0003\u0007\u0001!\u0019!C\u0001{\"9\u0011Q\u0001\u0001!\u0002\u0013a\u0005\u0002CA\u0004\u0001\t\u0007I\u0011A?\t\u000f\u0005%\u0001\u0001)A\u0005\u0019\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA$\u0001\u0011\u0005\u0011\u0011J\u0004\b\u0003#z\u0002\u0012AA*\r\u0019qr\u0004#\u0001\u0002V!1Qk\u0006C\u0001\u0003CB\u0001BX\f\t\u0006\u0004%\ta\u0018\u0005\b\u0003K:B\u0011AA4\u0011\u001d\tIi\u0006C\u0001\u0003\u0017Cq!!%\u0018\t\u0003\t\u0019\nC\u0005\u0002 ^\t\t\u0011\"\u0003\u0002\"\nQ1i\\7qCJ,'j\u001c2\u000b\u0005\u0001\n\u0013!B:uCR\u001c(B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t!S%A\u0004dQJ|gn\u001c8\u000b\u0003\u0019\n!!Y5\u0004\u0001M\u0019\u0001!K\u0018\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g!\t\u0001\u0004H\u0004\u00022m9\u0011!'N\u0007\u0002g)\u0011AgJ\u0001\u0007yI|w\u000e\u001e \n\u00031J!aN\u0016\u0002\u000fA\f7m[1hK&\u0011\u0011H\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003o-\n!\u0002^1cY\u0016,F/\u001b7t!\tid(D\u0001\"\u0013\ty\u0014E\u0001\u0006UC\ndW-\u0016;jYN\f\u0001B[8j]\u000e{gN\u001a\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u000e\n1!\u00199j\u0013\t15I\u0001\u0003K_&t\u0017\u0001E:uC\u001eLgnZ)vKJL8i\u001c8g!\t\u0011\u0015*\u0003\u0002K\u0007\na1\u000b^1hS:<\u0017+^3ss\u0006I1\u000f^1si\u0012\u000bG/\u001a\t\u0003\u001bFs!AT(\u0011\u0005IZ\u0013B\u0001),\u0003\u0019\u0001&/\u001a3fM&\u0011!k\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A[\u0013aB3oI\u0012\u000bG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\r]K&l\u0017/^!\tA\u0006!D\u0001 \u0011\u0015Yd\u00011\u0001=\u0011\u0015\u0001e\u00011\u0001B\u0011\u00159e\u00011\u0001I\u0011\u0015Ye\u00011\u0001M\u0011\u0015!f\u00011\u0001M\u0003\u0019awnZ4feV\t\u0001\r\u0005\u0002bM6\t!M\u0003\u0002dI\u0006)1\u000f\u001c45U*\tQ-A\u0002pe\u001eL!a\u001a2\u0003\r1{wmZ3sQ\t9\u0011\u000e\u0005\u0002+U&\u00111n\u000b\u0002\niJ\fgn]5f]R\f!\u0002^1cY\u0016\u0004&o\u001c9t+\u0005q\u0007\u0003B'p\u00192K!\u0001]*\u0003\u00075\u000b\u0007/A\u0006uC\ndW\r\u0015:paN\u0004\u0013!\u00038b[\u0016\u001c\b/Y2f+\u0005!\bCA;{\u001b\u00051(BA<y\u0003\u0011a\u0017M\\4\u000b\u0003e\fAA[1wC&\u0011!K^\u0001\u000b]\u0006lWm\u001d9bG\u0016\u0004\u0013\u0001\u00036pS:t\u0015-\\3\u0016\u00031\u000b\u0011B[8j]:\u000bW.\u001a\u0011\u0002!M$\u0018mZ5oOF+XM]=OC6,\u0017!E:uC\u001eLgnZ)vKJLh*Y7fA\u0005\u00192m\\7qCJL7o\u001c8UC\ndWMT1nK\u0006!2m\\7qCJL7o\u001c8UC\ndWMT1nK\u0002\n\u0001#\\3ue&\u001c7\u000fV1cY\u0016t\u0015-\\3\u0002#5,GO]5dgR\u000b'\r\\3OC6,\u0007%A\u0002sk:$\"!a\u0004\u0011\u0013)\n\t\"!\u0006\u0002\u0016\u0005m\u0012bAA\nW\t1A+\u001e9mKN\u0002B!a\u0006\u000269!\u0011\u0011DA\u0019\u001d\u0011\tY\"a\u000b\u000f\t\u0005u\u0011q\u0005\b\u0005\u0003?\t\u0019CD\u00023\u0003CI\u0011!Z\u0005\u0004\u0003K!\u0017AB1qC\u000eDW-C\u0002#\u0003SQ1!!\ne\u0013\u0011\ti#a\f\u0002\u0007M\fHNC\u0002#\u0003SI1aNA\u001a\u0015\u0011\ti#a\f\n\t\u0005]\u0012\u0011\b\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1aNA\u001a!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!G\u00051qN\u001c7j]\u0016LA!!\u0012\u0002@\tYA)\u0019;b\u001b\u0016$(/[2t\u0003!1\u0018\r\\5eCR,GCAA&!\rQ\u0013QJ\u0005\u0004\u0003\u001fZ#\u0001B+oSR\f!bQ8na\u0006\u0014XMS8c!\tAvc\u0005\u0003\u0018S\u0005]\u0003\u0003BA-\u0003?j!!a\u0017\u000b\u0007\u0005u\u00030\u0001\u0002j_&\u0019\u0011(a\u0017\u0015\u0005\u0005M\u0003FA\rj\u0003M9W\r^\"p]N|G.\u001b3bi\u0016$G)\u0019;b)\u0019\tI'a\u001f\u0002\u0000A)\u0001'a\u001b\u0002p%\u0019\u0011Q\u000e\u001e\u0003\t1K7\u000f\u001e\t\u0007U\u0005ED*!\u001e\n\u0007\u0005M4F\u0001\u0004UkBdWM\r\t\u0004U\u0005]\u0014bAA=W\t!Aj\u001c8h\u0011\u001d\tiH\u0007a\u0001\u0003w\tq!\\3ue&\u001c7\u000fC\u0004\u0002\u0002j\u0001\r!a!\u0002\u001bA\f'\u000f^5uS>t7\u000b]3d!\r\u0011\u0015QQ\u0005\u0004\u0003\u000f\u001b%!\u0004)beRLG/[8o'B,7-A\fqe&tG/\u00118e\u000f\u0016$()Y:jG6+GO]5dgR1\u0011\u0011NAG\u0003\u001fCq!! \u001c\u0001\u0004\tY\u0004C\u0004\u0002\u0002n\u0001\r!a!\u0002\u0017\u001d,GOS8j].+\u0017p\u001d\u000b\u0007\u0003+\u000bY*!(\u0011\tA\n9\nT\u0005\u0004\u00033S$aA*fc\")\u0001\t\ba\u0001\u0003\")1\b\ba\u0001y\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u00111\u0015\t\u0004k\u0006\u0015\u0016bAATm\n1qJ\u00196fGR\u0004")
public class CompareJob
implements Serializable {
    private transient Logger logger;
    private final TableUtils tableUtils;
    private final Join joinConf;
    private final StagingQuery stagingQueryConf;
    private final String startDate;
    private final String endDate;
    private final Map<String, String> tableProps;
    private final String namespace;
    private final String joinName;
    private final String stagingQueryName;
    private final String comparisonTableName;
    private final String metricsTableName;
    private volatile transient boolean bitmap$trans$0;

    public static Seq<String> getJoinKeys(Join joinConf, TableUtils tableUtils) {
        return CompareJob$.MODULE$.getJoinKeys(joinConf, tableUtils);
    }

    public static List<Tuple2<String, Object>> printAndGetBasicMetrics(DataMetrics metrics, PartitionSpec partitionSpec) {
        return CompareJob$.MODULE$.printAndGetBasicMetrics(metrics, partitionSpec);
    }

    public static List<Tuple2<String, Object>> getConsolidatedData(DataMetrics metrics, PartitionSpec partitionSpec) {
        return CompareJob$.MODULE$.getConsolidatedData(metrics, partitionSpec);
    }

    private Logger logger$lzycompute() {
        CompareJob compareJob = this;
        synchronized (compareJob) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger(this.getClass());
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Map<String, String> tableProps() {
        return this.tableProps;
    }

    public String namespace() {
        return this.namespace;
    }

    public String joinName() {
        return this.joinName;
    }

    public String stagingQueryName() {
        return this.stagingQueryName;
    }

    public String comparisonTableName() {
        return this.comparisonTableName;
    }

    public String metricsTableName() {
        return this.metricsTableName;
    }

    public Tuple3<Dataset<Row>, Dataset<Row>, DataMetrics> run() {
        TimedKvRdd timedKvRdd;
        Dataset dataset;
        DataMetrics metrics;
        block3: {
            Tuple3<Dataset<Row>, TimedKvRdd, DataMetrics> tuple3;
            block2: {
                Predef$.MODULE$.assert(this.endDate != null, (Function0 & Serializable)() -> "End date for the comparison should not be null");
                this.validate();
                PartitionRange partitionRange = new PartitionRange(this.startDate, this.endDate, this.tableUtils);
                Dataset<Row> leftDf = this.tableUtils.sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n        |SELECT *\n        |FROM ").append(Extensions$.MODULE$.MetadataOps(this.joinConf.metaData).outputTable()).append("\n        |WHERE ").append(partitionRange.betweenClauses()).append("\n        |").toString())));
                Dataset<Row> rightDf = this.tableUtils.sql(StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate));
                Dataset<Row> x$1 = leftDf;
                Dataset<Row> x$2 = rightDf;
                Seq<String> x$3 = CompareJob$.MODULE$.getJoinKeys(this.joinConf, this.tableUtils);
                TableUtils x$4 = this.tableUtils;
                boolean x$5 = true;
                Map<String, String> x$6 = CompareBaseJob$.MODULE$.compare$default$5();
                String x$7 = CompareBaseJob$.MODULE$.compare$default$7();
                tuple3 = CompareBaseJob$.MODULE$.compare(x$1, x$2, x$3, x$4, x$6, true, x$7);
                if (tuple3 == null) break block2;
                Dataset compareDf = (Dataset)tuple3._1();
                TimedKvRdd metricsTimedKvRdd = (TimedKvRdd)tuple3._2();
                metrics = (DataMetrics)tuple3._3();
                if (compareDf == null) break block2;
                dataset = compareDf;
                if (metricsTimedKvRdd == null) break block2;
                timedKvRdd = metricsTimedKvRdd;
                if (metrics != null) break block3;
            }
            throw new MatchError(tuple3);
        }
        DataMetrics dataMetrics = metrics;
        Tuple3 tuple3 = new Tuple3((Object)dataset, (Object)timedKvRdd, (Object)dataMetrics);
        Tuple3 tuple32 = tuple3;
        Dataset compareDf = (Dataset)tuple32._1();
        TimedKvRdd metricsTimedKvRdd = (TimedKvRdd)tuple32._2();
        DataMetrics metrics2 = (DataMetrics)tuple32._3();
        this.logger().info("Saving comparison output..");
        this.logger().info(new StringBuilder(18).append("Comparison schema ").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])compareDf.schema().fields()), (Function1 & Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).mkString("\n - ")).toString());
        this.tableUtils.insertUnPartitioned((Dataset<Row>)compareDf, this.comparisonTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
        this.logger().info("Saving metrics output..");
        Dataset<Row> metricsDf = metricsTimedKvRdd.toFlatDf();
        this.logger().info(new StringBuilder(15).append("Metrics schema ").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])metricsDf.schema().fields()), (Function1 & Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).mkString("\n - ")).toString());
        this.tableUtils.insertUnPartitioned(metricsDf, this.metricsTableName(), this.tableProps(), SaveMode.Overwrite, this.tableUtils.insertUnPartitioned$default$5());
        this.logger().info("Printing basic comparison results..");
        this.logger().info("(Note: This is just an estimation and not a detailed analysis of results)");
        CompareJob$.MODULE$.printAndGetBasicMetrics(metrics2, this.tableUtils.partitionSpec());
        this.logger().info("Finished compare stats.");
        return new Tuple3((Object)compareDf, metricsDf, (Object)metrics2);
    }

    public void validate() {
        TableUtils x$1 = this.tableUtils;
        Join x$2 = this.joinConf;
        String x$3 = this.startDate;
        String x$4 = this.endDate;
        boolean x$5 = false;
        int x$6 = Analyzer$.MODULE$.$lessinit$greater$default$5();
        double x$7 = Analyzer$.MODULE$.$lessinit$greater$default$6();
        boolean x$8 = Analyzer$.MODULE$.$lessinit$greater$default$8();
        boolean x$9 = Analyzer$.MODULE$.$lessinit$greater$default$9();
        Analyzer analyzer = new Analyzer(x$1, x$2, x$3, x$4, x$6, x$7, false, x$8, x$9);
        Map joinChrononSchema = (Map)analyzer.analyzeJoin(this.joinConf, false, analyzer.analyzeJoin$default$3(), analyzer.analyzeJoin$default$4(), analyzer.analyzeJoin$default$5())._1();
        Map joinSchema = ((Map)joinChrononSchema.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            ai.chronon.api.DataType v = (ai.chronon.api.DataType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)SparkConversions$.MODULE$.fromChrononType(v));
            return tuple22;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        String finalStagingQuery = StagingQuery$.MODULE$.substitute(this.tableUtils, this.stagingQueryConf.query, this.startDate, this.endDate, this.endDate);
        Map stagingQuerySchema = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.tableUtils.sql(new StringBuilder(8).append(finalStagingQuery).append(" LIMIT 1").toString()).schema().fields()), (Function1 & Serializable)sb -> new Tuple2((Object)sb.name(), (Object)sb.dataType()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map x$10 = joinSchema;
        Map x$11 = stagingQuerySchema;
        Seq<String> x$12 = CompareJob$.MODULE$.getJoinKeys(this.joinConf, this.tableUtils);
        TableUtils x$13 = this.tableUtils;
        boolean x$14 = true;
        Map<String, String> x$15 = CompareBaseJob$.MODULE$.checkConsistency$default$5();
        CompareBaseJob$.MODULE$.checkConsistency((Map<String, DataType>)x$10, (Map<String, DataType>)x$11, x$12, x$13, x$15, true);
    }

    public CompareJob(TableUtils tableUtils, Join joinConf, StagingQuery stagingQueryConf, String startDate, String endDate) {
        this.tableUtils = tableUtils;
        this.joinConf = joinConf;
        this.stagingQueryConf = stagingQueryConf;
        this.startDate = startDate;
        this.endDate = endDate;
        this.tableProps = (Map)Option$.MODULE$.apply((Object)joinConf.metaData.tableProperties).map((Function1 & Serializable)x$1 -> ScalaJavaConversions$.MODULE$.MapOps(x$1).toScala()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.namespace = joinConf.metaData.outputNamespace;
        this.joinName = Extensions$.MODULE$.MetadataOps(joinConf.metaData).cleanName();
        this.stagingQueryName = Extensions$.MODULE$.MetadataOps(stagingQueryConf.metaData).cleanName();
        this.comparisonTableName = new StringBuilder(21).append(this.namespace()).append(".compare_join_query_").append(this.joinName()).append("_").append(this.stagingQueryName()).toString();
        this.metricsTableName = new StringBuilder(27).append(this.namespace()).append(".compare_stats_join_query_").append(this.joinName()).append("_").append(this.stagingQueryName()).toString();
    }
}

