package ai.connectif.sdk.dependency

import ai.connectif.sdk.Constants
import ai.connectif.sdk.data.repository.EventRepositoryImpl
import ai.connectif.sdk.data.repository.SettingRepository
import ai.connectif.sdk.data.repository.SettingRepositoryImpl
import ai.connectif.sdk.data.source.EventDataSourceImpl
import ai.connectif.sdk.data.source.LocalPushTokenDataSourceImpl
import ai.connectif.sdk.data.source.PushDataSourceImpl
import ai.connectif.sdk.data.source.SettingLocalDataSourceImpl
import ai.connectif.sdk.manager.BuildConfigWrapper
import ai.connectif.sdk.manager.DeviceInfoManager
import ai.connectif.sdk.manager.event.EventManager
import ai.connectif.sdk.manager.event.EventManagerImpl
import ai.connectif.sdk.manager.push.PushManager
import ai.connectif.sdk.manager.push.PushManagerImpl
import android.content.Context
import android.content.SharedPreferences

internal class ConnectifComponent internal constructor(
    val settingRepository: SettingRepository,
    val eventManager: EventManager,
    val pushManager: PushManager
) {
    companion object {
        fun create(context: Context, apiKey: String): ConnectifComponent {
            val buildConfigWrapper = BuildConfigWrapper()
            val deviceInfoManager = DeviceInfoManager(context, buildConfigWrapper)
            val sharedPreferences: SharedPreferences =
                context.getSharedPreferences(Constants.Global.PREFERENCE_NAME, Context.MODE_PRIVATE)
            val localPushTokenDataSource = LocalPushTokenDataSourceImpl(sharedPreferences)
            val userSettingDataSource =
                SettingLocalDataSourceImpl(deviceInfoManager, sharedPreferences)
            val userSettingRepository =
                SettingRepositoryImpl(userSettingDataSource, localPushTokenDataSource, apiKey)
            val eventDataSource = EventDataSourceImpl(userSettingRepository)
            val pushDataSource = PushDataSourceImpl(userSettingRepository, localPushTokenDataSource)
            val eventRepository = EventRepositoryImpl(eventDataSource, localPushTokenDataSource)

            val eventManager =
                EventManagerImpl(eventRepository, userSettingRepository, deviceInfoManager)
            val pushManager =
                PushManagerImpl(
                    pushDataSource,
                    userSettingRepository,
                    deviceInfoManager,
                    localPushTokenDataSource
                )

            return ConnectifComponent(
                userSettingRepository,
                eventManager,
                pushManager
            )
        }
    }
}
