package ai.connectif.sdk.manager

import ai.connectif.sdk.BuildConfig
import ai.connectif.sdk.manager.LogLevel.ERROR
import ai.connectif.sdk.manager.LogLevel.INFO
import ai.connectif.sdk.manager.LogLevel.NONE
import ai.connectif.sdk.manager.LogLevel.WARN
import android.util.Log

internal object Logger {

    private const val TAG = "ConnectifSDK"
    internal var logLevel: LogLevel = LogLevel.NONE

    fun e(message: String) {
        if (logLevel >= LogLevel.ERROR) Log.e(TAG, message)
    }

    fun w(message: String) {
        if (logLevel >= LogLevel.WARN) Log.w(TAG, message)
    }

    fun i(message: String) {
        if (logLevel >= LogLevel.INFO) Log.i(TAG, message)
    }

    fun d(message: String) {
        if (BuildConfig.DEV_LOG_ENABLED) Log.d(TAG, message)
    }

    fun setLogLevel(level: LogLevel) {
        logLevel = level
    }
}

/**
 * Defines different logging levels for the Connectif SDK.
 *
 * - [NONE] disables all logs.
 * - [ERROR] logs only error messages.
 * - [WARN] logs warning and error messages.
 * - [INFO] logs informational, warning, and error messages.
 */
enum class LogLevel {
    NONE,
    ERROR,
    WARN,
    INFO
}
