package ai.connectif.sdk.manager.event

import ai.connectif.sdk.model.Cart
import ai.connectif.sdk.model.ContactInfo
import ai.connectif.sdk.model.Login
import ai.connectif.sdk.model.PageVisit
import ai.connectif.sdk.model.ProductVisit
import ai.connectif.sdk.model.Purchase
import ai.connectif.sdk.model.Register
import ai.connectif.sdk.model.Search
import ai.connectif.sdk.model.customevent.CustomEvent

internal interface EventManager {
    suspend fun sendPageVisit(event: PageVisit)

    suspend fun sendSearch(event: Search)

    suspend fun sendProductVisit(event: ProductVisit)

    suspend fun sendLogin(event: Login)

    suspend fun sendRegister(event: Register)

    suspend fun sendCart(event: Cart)

    suspend fun sendPurchase(event: Purchase)

    suspend fun subscribeToNewsletter()

    suspend fun sendContactInfo(event: ContactInfo)

    suspend fun sendCustomEventById(eventId: String, event: CustomEvent)

    suspend fun sendCustomEventById(eventId: String, payload: Any)

    suspend fun sendCustomEventByAlias(eventAlias: String, event: CustomEvent)

    suspend fun sendCustomEventByAlias(eventAlias: String, payload: Any)
}
