/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.agent;

import ai.databand.DbndAppLog;
import ai.databand.agent.ActiveJobTransformer;
import ai.databand.agent.DbndTrackingTransformer;
import ai.databand.config.DbndAgentConfig;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import org.slf4j.event.Level;

public class DbndAgent {
    public static void premain(String agentArgs, Instrumentation inst) {
        Properties props = new Properties();
        try (InputStream input = DbndAgent.class.getClassLoader().getResourceAsStream("application.properties");){
            props.load(input);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Runtime.getRuntime();
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        DbndAppLog.printfln((Level)Level.INFO, (String)"Succesfully loaded Databand Agent v%s into JVM process '%s'. No Databand tracking is enabled at this moment.", (Object[])new Object[]{props.getProperty("version"), jvmName});
        try {
            Class.forName("java.lang.invoke.CallSite");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        DbndAgentConfig config = new DbndAgentConfig(agentArgs);
        inst.addTransformer(new DbndTrackingTransformer(config));
        if (config.sparkIoTrackingEnabled()) {
            inst.addTransformer(new ActiveJobTransformer());
        }
    }
}

