/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.deequ;

import com.amazon.deequ.analyzers.runners.AnalyzerContext;
import com.amazon.deequ.metrics.Distribution;
import com.amazon.deequ.metrics.DistributionValue;
import com.amazon.deequ.metrics.Metric;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

public class DeequToDbnd {
    private static final Logger LOG = LoggerFactory.getLogger(DeequToDbnd.class);
    private final String dfName;
    private final List<Metric<?>> deequMetrics;
    private static final java.util.Map<String, String> DEEQU_TO_SPARK = new HashMap<String, String>();
    private static final java.util.Map<String, String> DEEQU_TO_DBND;

    public DeequToDbnd(String dfName, AnalyzerContext analyzerContext) {
        this.dfName = dfName;
        this.deequMetrics = (List)JavaConverters.seqAsJavaListConverter((Seq)analyzerContext.metricMap().values().toSeq()).asJava();
    }

    public java.util.Map<String, Object> metrics() {
        HashMap<String, Object> metrics = new HashMap<String, Object>(1);
        for (Metric<?> m : this.deequMetrics) {
            if (m.value().isSuccess() && m.value().get() instanceof Distribution) continue;
            String metricKey = String.format("deequ.%s.%s.%s", this.dfName, m.instance(), m.name());
            if (m.value().isFailure()) {
                LOG.error("Deequ calculation failed for key [{}]. Reason: {}", (Object)metricKey, (Object)((Throwable)m.value().failed().get()).getMessage());
            }
            String value = m.value().isSuccess() ? m.value().get() : "Failure";
            metrics.put(metricKey, value);
        }
        return metrics;
    }

    public java.util.Map<String, Object> histograms() {
        return this.buildHistograms(this.dfName, this.deequMetrics);
    }

    public java.util.Map<String, Object> buildHistograms(String dfName, List<Metric<?>> deequMetrics) {
        Set histogrammedCols = deequMetrics.stream().filter(m -> "Histogram".equalsIgnoreCase(m.name())).map(Metric::instance).collect(Collectors.toSet());
        if (histogrammedCols.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        HashMap<String, Object[][]> histograms = new HashMap<String, Object[][]>(1);
        java.util.Map<String, java.util.Map> stats = histogrammedCols.stream().collect(Collectors.toMap(m -> m, m -> new HashMap(1)));
        for (Metric<?> m2 : deequMetrics) {
            String sparkMetric;
            String col = m2.instance();
            if (!histogrammedCols.contains(col) || (sparkMetric = DEEQU_TO_SPARK.get(m2.name())) == null) continue;
            if ("histogram".equalsIgnoreCase(sparkMetric)) {
                Distribution distribution = (Distribution)m2.value().get();
                java.util.Map binsAndValues = (java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)distribution.values()).asJava();
                if (this.isDistributionHistogram(binsAndValues)) {
                    String type = this.guessColumnTypeByDistribution(binsAndValues);
                    stats.get(col).put("type", type);
                    continue;
                }
                Object[][] histogram = this.distributionToHistogram(binsAndValues);
                histograms.put(col, histogram);
                if (stats.get(col).containsKey("type")) continue;
                Object[] bins = histogram[1];
                if (this.allBooleans(bins)) {
                    stats.get(col).put("type", "boolean");
                    continue;
                }
                if (this.allIntegers(bins)) {
                    stats.get(col).put("type", "integer");
                    continue;
                }
                if (this.allDoubles(bins)) {
                    stats.get(col).put("type", "double");
                    continue;
                }
                stats.get(col).put("type", "string");
                continue;
            }
            stats.get(col).put(sparkMetric, m2.value().get());
            result.put(String.format("%s.%s.%s", dfName, col, sparkMetric), m2.value().get());
        }
        result.put(String.format("%s.stats", dfName), stats);
        if (!histograms.isEmpty()) {
            result.put(String.format("%s.histograms", dfName), histograms);
        }
        return result;
    }

    public Object[][] distributionToHistogram(java.util.Map<String, DistributionValue> binsAndValues) {
        Object[] bins = new Object[binsAndValues.size()];
        Object[] values = new Object[binsAndValues.size()];
        int i = 0;
        for (Map.Entry<String, DistributionValue> entry : binsAndValues.entrySet()) {
            bins[i] = entry.getKey();
            values[i] = entry.getValue().absolute();
            ++i;
        }
        return new Object[][]{values, bins};
    }

    protected boolean isDistributionHistogram(java.util.Map<String, DistributionValue> binsAndValues) {
        for (String type : DEEQU_TO_DBND.keySet()) {
            if (binsAndValues.containsKey(type)) continue;
            return false;
        }
        return true;
    }

    protected String guessColumnTypeByDistribution(java.util.Map<String, DistributionValue> binsAndValues) {
        for (Map.Entry<String, String> entry : DEEQU_TO_DBND.entrySet()) {
            if (binsAndValues.get(entry.getKey()).absolute() <= 1L) continue;
            return entry.getValue();
        }
        return "string";
    }

    protected boolean allBooleans(Object[] values) {
        for (Object o : values) {
            if (o == null || "true".equalsIgnoreCase(o.toString()) || "false".equalsIgnoreCase(o.toString())) continue;
            return false;
        }
        return true;
    }

    protected boolean allIntegers(Object[] values) {
        for (Object o : values) {
            if (o != null && o.toString().contains(".")) {
                return false;
            }
            if (o == null) continue;
            try {
                Integer.parseInt(o.toString());
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    protected boolean allDoubles(Object[] values) {
        for (Object o : values) {
            if (o == null) continue;
            try {
                Double.parseDouble(o.toString());
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    static {
        DEEQU_TO_SPARK.put("ApproxCountDistinct", "distinct");
        DEEQU_TO_SPARK.put("Minimum", "min");
        DEEQU_TO_SPARK.put("Maximum", "max");
        DEEQU_TO_SPARK.put("Mean", "mean");
        DEEQU_TO_SPARK.put("StandardDeviation", "stddev");
        DEEQU_TO_SPARK.put("Histogram", "histogram");
        DEEQU_TO_DBND = new HashMap<String, String>();
        DEEQU_TO_DBND.put("Boolean", "boolean");
        DEEQU_TO_DBND.put("Fractional", "double");
        DEEQU_TO_DBND.put("Integral", "integer");
        DEEQU_TO_DBND.put("String", "string");
        DEEQU_TO_DBND.put("Unknown", "string");
    }
}

